/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_net_InterfaceAddress;
import com.oracle.svm.core.posix.Target_java_net_NetworkInterface;
import com.oracle.svm.core.posix.Target_jni;
import com.oracle.svm.core.posix.Util_java_net_Inet4Address;
import com.oracle.svm.core.posix.Util_java_net_Inet6Address;
import com.oracle.svm.core.posix.Util_java_net_InterfaceAddress;
import com.oracle.svm.core.posix.Util_java_net_NetworkInterface;
import com.oracle.svm.core.posix.VmPrimsJVM;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.NetIf;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.Utf8;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
public class JavaNetNetworkInterface {
    static NetworkInterface createNetworkInterface(netif ifs) {
        String name;
        Target_java_net_NetworkInterface netif_TJNNI = new Target_java_net_NetworkInterface();
        NetworkInterface netifObj = Util_java_net_NetworkInterface.toNetworkInterface(netif_TJNNI);
        netif_TJNNI.name = name = CTypeConversion.toJavaString((CCharPointer)ifs.name);
        netif_TJNNI.displayName = name;
        netif_TJNNI.index = ifs.index;
        netif_TJNNI.virtual = CTypeConversion.toBoolean((int)ifs.virtual);
        int addr_count = 0;
        netaddr addrP = ifs.addr;
        while (addrP != null) {
            ++addr_count;
            addrP = addrP.next;
        }
        InetAddress[] addrArr = new InetAddress[addr_count];
        InterfaceAddress[] bindArr = new InterfaceAddress[addr_count];
        addrP = ifs.addr;
        int addr_index = 0;
        int bind_index = 0;
        while (addrP != null) {
            InetAddress iaObj = null;
            InterfaceAddress ibObj = null;
            if (addrP.family == Socket.AF_INET()) {
                InterfaceAddress ib_IA;
                Inet4Address ia_I4A = Util_java_net_Inet4Address.new_Inet4Address();
                iaObj = ia_I4A;
                if (iaObj == null) {
                    return null;
                }
                JavaNetNetUtil.setInetAddress_addr(ia_I4A, NetinetIn.htonl(((NetinetIn.sockaddr_in)((Object)addrP.addr)).sin_addr().s_addr()));
                Target_java_net_InterfaceAddress ib_TJNIA = new Target_java_net_InterfaceAddress();
                ibObj = ib_IA = Util_java_net_InterfaceAddress.toInterfaceAddress(ib_TJNIA);
                if (ibObj != null) {
                    ib_TJNIA.address = ia_I4A;
                    if (CTypeConversion.toBoolean((PointerBase)addrP.brdcast)) {
                        Inet4Address ia2Obj = null;
                        ia2Obj = Util_java_net_Inet4Address.new_Inet4Address();
                        JavaNetNetUtil.setInetAddress_addr(ia2Obj, NetinetIn.htonl(((NetinetIn.sockaddr_in)((Object)addrP.brdcast)).sin_addr().s_addr()));
                        ib_TJNIA.broadcast = ia2Obj;
                    }
                    ib_TJNIA.maskLength = addrP.mask;
                    bindArr[bind_index++] = ib_IA;
                } else {
                    return null;
                }
            }
            if (IsDefined.socket_AF_INET6() && addrP.family == Socket.AF_INET6()) {
                InterfaceAddress ib_IA;
                int scope = 0;
                Inet6Address ia_I6A = Util_java_net_Inet6Address.new_Inet6Address();
                iaObj = ia_I6A;
                if (iaObj != null) {
                    CCharPointer address = (CCharPointer)((NetinetIn.sockaddr_in6)((Object)addrP.addr)).sin6_addr();
                    int ret = JavaNetNetUtil.setInet6Address_ipaddress(ia_I6A, address);
                    if (ret == Target_jni.JNI_FALSE()) {
                        return null;
                    }
                    scope = ((NetinetIn.sockaddr_in6)((Object)addrP.addr)).sin6_scope_id();
                    if (scope != 0) {
                        JavaNetNetUtil.setInet6Address_scopeid(ia_I6A, scope);
                        JavaNetNetUtil.setInet6Address_scopeifname(ia_I6A, netifObj);
                    }
                } else {
                    return null;
                }
                Target_java_net_InterfaceAddress ib_TJNIA = new Target_java_net_InterfaceAddress();
                ibObj = ib_IA = Util_java_net_InterfaceAddress.toInterfaceAddress(ib_TJNIA);
                if (ibObj != null) {
                    ib_TJNIA.address = iaObj;
                    ib_TJNIA.maskLength = addrP.mask;
                    bindArr[bind_index++] = ib_IA;
                } else {
                    return null;
                }
            }
            addrArr[addr_index++] = iaObj;
            addrP = addrP.next;
        }
        int child_count = 0;
        netif childP = ifs.childs;
        while (childP != null) {
            ++child_count;
            childP = childP.next;
        }
        NetworkInterface[] childArr = new NetworkInterface[child_count];
        int child_index = 0;
        childP = ifs.childs;
        while (childP != null) {
            NetworkInterface tmp = JavaNetNetworkInterface.createNetworkInterface(childP);
            if (tmp == null) {
                return null;
            }
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)tmp).parent = netifObj;
            childArr[child_index++] = tmp;
            childP = childP.next;
        }
        netif_TJNNI.addrs = addrArr;
        netif_TJNNI.bindings = bindArr;
        netif_TJNNI.childs = childArr;
        return netifObj;
    }

    public static netif enumInterfaces() {
        netif ifs;
        int sock;
        PlatformSupport platformSupport = (PlatformSupport)ImageSingletons.lookup(PlatformSupport.class);
        try {
            sock = JavaNetNetworkInterface.openSocket(Socket.AF_INET());
            if (sock < 0) {
                return null;
            }
        }
        catch (SocketException eo) {
            return null;
        }
        try {
            ifs = platformSupport.enumIPv4Interfaces(sock, null);
            Unistd.close(sock);
            if (ifs == null) {
                return null;
            }
        }
        catch (SocketException se) {
            return null;
        }
        if (JavaNetNetUtil.ipv6_available()) {
            try {
                sock = JavaNetNetworkInterface.openSocket(Socket.AF_INET6());
                if (sock < 0) {
                    return null;
                }
            }
            catch (SocketException so) {
                return null;
            }
            try {
                ifs = platformSupport.enumIPv6Interfaces(sock, ifs);
                Unistd.close(sock);
            }
            catch (SocketException se) {
                return null;
            }
        }
        return ifs;
    }

    public static void checkMalloc(PointerBase pointer) {
        if (pointer.isNull()) {
            throw new OutOfMemoryError("Native heap allocation failed");
        }
    }

    public static void freeif(netif ifsParameter) {
        netif ifs;
        netif currif = ifs = ifsParameter;
        while (currif != null) {
            netaddr addrP = currif.addr;
            while (addrP != null) {
                netaddr next = addrP.next;
                netaddr.free(addrP);
                addrP = next;
            }
            if (currif.childs != null) {
                JavaNetNetworkInterface.freeif(currif.childs);
            }
            ifs = currif.next;
            netif.free(currif);
            currif = ifs;
        }
    }

    public static netif addif(int sock, CCharPointer if_name, netif ifsParameter, Socket.sockaddr ifr_addrP, int family, short prefix) {
        CCharPointer name_colonP;
        netif ifs = ifsParameter;
        PlatformSupport platformSupport = (PlatformSupport)ImageSingletons.lookup(PlatformSupport.class);
        netif currif = ifs;
        int ifnam_size = NetIf.IFNAMSIZ();
        CCharPointer name = (CCharPointer)StackValue.get((int)NetIf.IFNAMSIZ(), CCharPointer.class);
        CCharPointer vname = (CCharPointer)StackValue.get((int)NetIf.IFNAMSIZ(), CCharPointer.class);
        boolean isVirtual = false;
        CIntPointer flags_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        flags_Pointer.write(0);
        LibC.strncpy(name, if_name, WordFactory.unsigned((int)ifnam_size));
        name.write(ifnam_size - 1, (byte)0);
        vname.write(0, (byte)0);
        int addr_size = IsDefined.socket_AF_INET6() ? (family == Socket.AF_INET() ? SizeOf.get(NetinetIn.sockaddr_in.class) : SizeOf.get(NetinetIn.sockaddr_in6.class)) : SizeOf.get(NetinetIn.sockaddr_in.class);
        netaddr addrP = netaddr.checked_malloc(addr_size);
        addrP.addr = addrP.addrSpace;
        LibC.memcpy(addrP.addr, ifr_addrP, WordFactory.unsigned((int)addr_size));
        addrP.family = family;
        addrP.brdcast = (Socket.sockaddr)WordFactory.nullPointer();
        addrP.mask = prefix;
        addrP.next = null;
        if (family == Socket.AF_INET()) {
            Socket.sockaddr brdcast_to = addrP.brdcastSpace;
            try {
                addrP.brdcast = platformSupport.getBroadcast(sock, name, brdcast_to);
            }
            catch (SocketException se) {
                return ifs;
            }
            try {
                short mask = platformSupport.getSubnet(sock, name);
                if (mask != -1) {
                    addrP.mask = mask;
                }
            }
            catch (SocketException se) {
                return ifs;
            }
        }
        if ((name_colonP = SubstrateUtil.strchr(name, 58)).isNonNull()) {
            name_colonP.write((byte)0);
            if (platformSupport.getFlags(sock, name, flags_Pointer) < 0 | flags_Pointer.read() < 0) {
                isVirtual = true;
                name_colonP.write((byte)58);
            } else {
                LibC.memcpy(vname, (PointerBase)name, WordFactory.unsigned((int)ifnam_size));
                vname.write((int)PointerUtils.absoluteDifference((PointerBase)name_colonP, (PointerBase)name).rawValue(), (byte)58);
            }
        }
        while (currif != null && LibC.strcmp((PointerBase)name, (PointerBase)currif.name) != 0) {
            currif = currif.next;
        }
        if (currif == null) {
            currif = netif.checked_malloc(ifnam_size);
            LibC.strncpy(currif.name, name, WordFactory.unsigned((int)ifnam_size));
            currif.name.write(ifnam_size - 1, (byte)0);
            currif.index = platformSupport.getIndex(sock, name);
            currif.addr = null;
            currif.addr = null;
            currif.virtual = (byte)(isVirtual ? 1 : 0);
            currif.next = ifs;
            ifs = currif;
        }
        addrP.next = currif.addr;
        currif.addr = addrP;
        netif parent = currif;
        if (CTypeConversion.toBoolean((int)vname.read())) {
            currif = parent.childs;
            while (currif != null && LibC.strcmp((PointerBase)vname, (PointerBase)currif.name) != 0) {
                currif = currif.next;
            }
            if (currif == null) {
                currif = new netif();
                CCharPointer currifName = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)ifnam_size));
                JavaNetNetworkInterface.checkMalloc((PointerBase)currifName);
                currif.name = currifName;
                LibC.strncpy(currif.name, vname, WordFactory.unsigned((int)ifnam_size));
                currif.name.write(ifnam_size - 1, (byte)0);
                currif.index = platformSupport.getIndex(sock, vname);
                currif.addr = null;
                currif.virtual = 1;
                currif.childs = null;
                currif.next = parent.childs;
                parent.childs = currif;
            }
            netaddr tmpaddr = netaddr.checked_malloc(addr_size);
            tmpaddr.copyFields(addrP);
            if (addrP.addr.isNonNull()) {
                LibC.memcpy(tmpaddr.addr, addrP.addr, WordFactory.unsigned((int)addr_size));
            } else {
                LibC.free(tmpaddr.addr);
                tmpaddr.addr = (Socket.sockaddr)WordFactory.nullPointer();
            }
            if (addrP.brdcast.isNonNull()) {
                LibC.memcpy(tmpaddr.brdcast, addrP.brdcast, WordFactory.unsigned((int)addr_size));
            } else {
                LibC.free(tmpaddr.brdcast);
                tmpaddr.brdcast = (Socket.sockaddr)WordFactory.nullPointer();
            }
            tmpaddr.next = currif.addr;
            currif.addr = tmpaddr;
        }
        return ifs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getFlags0(String name) {
        PlatformSupport platformSupport = (PlatformSupport)ImageSingletons.lookup(PlatformSupport.class);
        CIntPointer flags = (CIntPointer)StackValue.get(CIntPointer.class);
        byte[] name_utf = Utf8.stringToUtf8(name, true);
        try (PinnedObject name_utf_Pin = PinnedObject.create((Object)name_utf);){
            CCharPointer name_utf_Pointer = (CCharPointer)name_utf_Pin.addressOfArrayElement(0);
            int sock = JavaNetNetworkInterface.openSocketWithFallback(name_utf_Pointer);
            if (sock < 0) {
                int n2 = -1;
                return n2;
            }
            int ret = platformSupport.getFlags(sock, name_utf_Pointer, flags);
            Unistd.close(sock);
            if (ret < 0) {
                throw new SocketException(PosixUtils.lastErrorString("IOCTL SIOCGLIFFLAGS failed"));
            }
            int n = flags.read();
            return n;
        }
        catch (SocketException e) {
            return -1;
        }
    }

    public static int openSocketWithFallback(CCharPointer ifname) throws SocketException {
        if (IsDefined.socket_AF_INET6()) {
            int sock = VmPrimsJVM.JVM_Socket(Socket.AF_INET(), Socket.SOCK_DGRAM(), 0);
            if (sock < 0) {
                if (Errno.errno() == Errno.EPROTONOSUPPORT()) {
                    sock = VmPrimsJVM.JVM_Socket(Socket.AF_INET6(), Socket.SOCK_DGRAM(), 0);
                    if (sock < 0) {
                        throw new SocketException(PosixUtils.lastErrorString("IPV6 Socket creation failed"));
                    }
                } else {
                    throw new SocketException(PosixUtils.lastErrorString("IPV4 Socket creation failed"));
                }
            }
            return sock;
        }
        return JavaNetNetworkInterface.openSocket(Socket.AF_INET());
    }

    public static int openSocket(int proto) throws SocketException {
        int sock = VmPrimsJVM.JVM_Socket(proto, Socket.SOCK_DGRAM(), 0);
        if (sock < 0 && Errno.errno() != Errno.EPROTONOSUPPORT()) {
            throw new SocketException(PosixUtils.lastErrorString("Socket creation failed"));
        }
        return sock;
    }

    public static interface PlatformSupport {
        public netif enumIPv4Interfaces(int var1, netif var2) throws SocketException;

        public netif enumIPv6Interfaces(int var1, netif var2) throws SocketException;

        public Socket.sockaddr getBroadcast(int var1, CCharPointer var2, Socket.sockaddr var3) throws SocketException;

        public short getSubnet(int var1, CCharPointer var2) throws SocketException;

        public int getFlags(int var1, CCharPointer var2, CIntPointer var3);

        public int getIndex(int var1, CCharPointer var2);

        public int getMacAddress(CCharPointer var1, NetinetIn.in_addr var2, CCharPointer var3) throws SocketException;
    }

    public static class netif {
        CCharPointer name;
        int index;
        byte virtual;
        netaddr addr;
        netif childs;
        netif next;

        public static netif checked_malloc(int nameSize) {
            netif result = new netif();
            result.name = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)nameSize));
            JavaNetNetworkInterface.checkMalloc((PointerBase)result.name);
            return result;
        }

        public static void free(netif that) {
            LibC.free((PointerBase)that.name);
        }

        public void toLog(Log log) {
            log.string("[").object(this).newline().string("  .name: ").string(this.name).newline().string("  .index: ").signed(this.index).newline().string("  .virtual: ").signed(this.virtual).newline().string("  .addr: ").object(this.addr).newline().string("  .childs: ").object(this.childs).newline().string("  .next: ").object(this.next).string("]");
        }
    }

    public static class netaddr {
        public Socket.sockaddr addr;
        public Socket.sockaddr brdcast;
        public short mask;
        public int family;
        public netaddr next;
        Socket.sockaddr addrSpace;
        Socket.sockaddr brdcastSpace;

        public netaddr copyFields(netaddr that) {
            this.addr = that.addr;
            this.brdcast = that.brdcast;
            this.mask = that.mask;
            this.family = that.family;
            this.next = that.next;
            return this;
        }

        public static netaddr checked_malloc(int addr_size) {
            netaddr result = new netaddr();
            result.addrSpace = (Socket.sockaddr)LibC.malloc(WordFactory.unsigned((int)addr_size));
            JavaNetNetworkInterface.checkMalloc(result.addrSpace);
            result.brdcastSpace = (Socket.sockaddr)LibC.malloc(WordFactory.unsigned((int)addr_size));
            JavaNetNetworkInterface.checkMalloc(result.brdcastSpace);
            return result;
        }

        public static void free(netaddr that) {
            LibC.free(that.addrSpace);
            LibC.free(that.brdcastSpace);
        }

        void toLog(Log log) {
            log.string("[").object(this).newline().string("  .addr: ").hex((WordBase)this.addr).newline().string("  .brdcast: ").hex((WordBase)this.brdcast).newline().string("  .mask: ").signed(this.mask).newline().string("  .family: ").signed(this.family).newline().string("  .next: ").object(this.next).newline().string("  .addrSpace: ").hex((WordBase)this.addrSpace).newline().string("  .brdcastSpace: ").hex((WordBase)this.brdcastSpace).string("]");
        }
    }
}

