/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.jdk.BuildStackTraceVisitor;
import com.oracle.svm.core.jdk.GetCallerClassVisitor;
import com.oracle.svm.core.jdk.GetClassContextVisitor;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.stack.JavaStackWalker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.util.DirectAnnotationAccess;
import org.graalvm.word.Pointer;

public class StackTraceUtils {
    private static final Class<?>[] NO_CLASSES = new Class[0];
    private static final StackTraceElement[] NO_ELEMENTS = new StackTraceElement[0];

    public static StackTraceElement[] getStackTrace(boolean filterExceptions, Pointer startSP) {
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(filterExceptions);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static StackTraceElement[] getStackTrace(boolean filterExceptions, IsolateThread thread) {
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(filterExceptions);
        JavaStackWalker.walkThread(thread, visitor);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static Class<?>[] getClassContext(int skip, Pointer startSP) {
        GetClassContextVisitor visitor = new GetClassContextVisitor(skip);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.trace.toArray(NO_CLASSES);
    }

    public static Class<?> getCallerClass(Pointer startSP) {
        return StackTraceUtils.getCallerClass(startSP, 0);
    }

    public static Class<?> getCallerClass(Pointer startSP, int depth) {
        GetCallerClassVisitor visitor = new GetCallerClassVisitor(depth);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.result;
    }

    public static boolean shouldShowFrame(FrameInfoQueryResult frameInfo, boolean showReflectFrames, boolean showHiddenFrames) {
        if (showHiddenFrames) {
            return true;
        }
        Class<?> clazz = frameInfo.getSourceClass();
        if (clazz == null) {
            return false;
        }
        if (DirectAnnotationAccess.isAnnotationPresent(clazz, InternalVMMethod.class)) {
            return false;
        }
        return showReflectFrames || !(clazz == Method.class && "invoke".equals(frameInfo.getSourceMethodName()) || clazz == Constructor.class && "newInstance".equals(frameInfo.getSourceMethodName())) && (clazz != Class.class || !"newInstance".equals(frameInfo.getSourceMethodName()));
    }
}

