/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class DeoptTestNode
extends FixedWithNextNode
implements Lowerable,
DeoptimizingNode.DeoptAfter,
MemoryCheckpoint.Single {
    public static final NodeClass<DeoptTestNode> TYPE = NodeClass.create(DeoptTestNode.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState deoptState;

    public DeoptTestNode() {
        super(TYPE, StampFactory.forVoid());
    }

    public boolean canDeoptimize() {
        return true;
    }

    public boolean hasSideEffect() {
        return true;
    }

    public FrameState stateAfter() {
        return this.deoptState;
    }

    public void setStateAfter(FrameState f) {
        this.updateUsages((Node)this.deoptState, (Node)f);
        this.deoptState = f;
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }
}

