/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.struct.AllowNarrowingCast;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.PointerBase;

@Platforms(value={DeprecatedPlatform.DARWIN_SUBSTITUTION.class, DeprecatedPlatform.LINUX_SUBSTITUTION.class})
@CContext(value=PosixDirectives.class)
public class NetinetIn {
    private NetinetIn() {
    }

    @CConstant
    public static native int IPV6_V6ONLY();

    @CConstant
    public static native int INADDR_ANY();

    @CConstant
    public static native int IPPROTO_IP();

    @CConstant
    public static native int IPPROTO_IPV6();

    @CConstant
    public static native int IPPROTO_TCP();

    @CConstant
    public static native int IP_TOS();

    @CConstant
    public static native int IP_MULTICAST_IF();

    @CConstant
    public static native int IPV6_MULTICAST_IF();

    @CConstant
    public static native int IP_MULTICAST_LOOP();

    @CConstant
    public static native int IPV6_MULTICAST_LOOP();

    @CConstant
    public static native int IPV6_MULTICAST_HOPS();

    @CConstant
    public static native int IPV6_TCLASS();

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    @CConstant
    public static native int IP_MULTICAST_ALL();

    @CConstant
    public static native int IP_MULTICAST_TTL();

    @CConstant
    public static native int IP_ADD_MEMBERSHIP();

    @CConstant
    public static native int IP_DROP_MEMBERSHIP();

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    @CConstant
    public static native int IPV6_ADD_MEMBERSHIP();

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    @CConstant
    public static native int IPV6_DROP_MEMBERSHIP();

    @Platforms(value={DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    @CConstant
    public static native int IPV6_JOIN_GROUP();

    @Platforms(value={DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    @CConstant
    public static native int IPV6_LEAVE_GROUP();

    @CConstant
    public static native int LITTLE_ENDIAN();

    @CConstant
    public static native int BYTE_ORDER();

    public static int htons(int hostshort) {
        int result = NetinetIn.BYTE_ORDER() == NetinetIn.LITTLE_ENDIAN() ? NetinetIn.swap_uint16_t(hostshort) : NetinetIn.int_to_uint16_t(hostshort);
        return result;
    }

    public static int ntohs(int hostshort) {
        int result = NetinetIn.BYTE_ORDER() == NetinetIn.LITTLE_ENDIAN() ? NetinetIn.swap_uint16_t(hostshort) : NetinetIn.int_to_uint16_t(hostshort);
        return result;
    }

    public static int htonl(int hostlong) {
        int result = NetinetIn.BYTE_ORDER() == NetinetIn.LITTLE_ENDIAN() ? NetinetIn.swap_uint32_t(hostlong) : hostlong;
        return result;
    }

    public static int ntohl(int netlong) {
        int result = NetinetIn.BYTE_ORDER() == NetinetIn.LITTLE_ENDIAN() ? NetinetIn.swap_uint32_t(netlong) : netlong;
        return result;
    }

    private static int swap_uint16_t(int value) {
        return NetinetIn.int_to_uint16_t(NetinetIn.insertByte(NetinetIn.extractByte(value, 1), 0) | NetinetIn.insertByte(NetinetIn.extractByte(value, 0), 1));
    }

    private static int int_to_uint16_t(int value) {
        return value & 0xFFFF;
    }

    private static int swap_uint32_t(int value) {
        return NetinetIn.insertByte(NetinetIn.extractByte(value, 3), 0) | NetinetIn.insertByte(NetinetIn.extractByte(value, 2), 1) | NetinetIn.insertByte(NetinetIn.extractByte(value, 1), 2) | NetinetIn.insertByte(NetinetIn.extractByte(value, 0), 3);
    }

    private static int extractByte(int value, int whichByte) {
        assert (0 <= whichByte && whichByte <= 3) : "Which byte not in [0..3]";
        return value >>> whichByte * 8 & 0xFF;
    }

    private static int insertByte(int value, int whichByte) {
        assert (0 <= whichByte && whichByte <= 3) : "Which byte not in [0..3]";
        assert (0 <= value && value <= 255) : "Value not in [0..255]";
        return value << whichByte * 8;
    }

    @CStruct(addStructKeyword=true)
    public static interface ipv6_mreq
    extends PointerBase {
        @CFieldAddress
        public in6_addr ipv6mr_multiaddr();

        @CField
        public int ipv6mr_interface();

        @CField
        public void set_ipv6mr_interface(int var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface ip_mreq
    extends PointerBase {
        @CFieldAddress
        public in_addr imr_multiaddr();

        @CFieldAddress
        public in_addr imr_interface();
    }

    @CStruct(addStructKeyword=true)
    public static interface sockaddr_in6
    extends PointerBase {
        @CField
        @AllowWideningCast
        public int sin6_family();

        @CField
        @AllowNarrowingCast
        public void set_sin6_family(int var1);

        @CField
        @AllowWideningCast
        public int sin6_port();

        @CField
        @AllowNarrowingCast
        public void set_sin6_port(int var1);

        @CField
        public int sin6_flowinfo();

        @CField
        public void set_sin6_flowinfo(int var1);

        @CFieldAddress
        public in6_addr sin6_addr();

        @CField
        public int sin6_scope_id();

        @CField
        public void set_sin6_scope_id(int var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface in6_addr
    extends PointerBase {
        @CFieldAddress
        public CCharPointer s6_addr();
    }

    @CStruct(addStructKeyword=true)
    public static interface in_addr
    extends PointerBase {
        @CField
        public int s_addr();

        @CField
        public void set_s_addr(int var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface sockaddr_in
    extends PointerBase {
        @CField
        @AllowWideningCast
        public int sin_family();

        @CField
        @AllowNarrowingCast
        public void set_sin_family(int var1);

        @CField
        @AllowWideningCast
        public int sin_port();

        @CField
        @AllowNarrowingCast
        public void set_sin_port(int var1);

        @CFieldAddress
        public in_addr sin_addr();
    }
}

