// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SubstrateOptions.java
package com.oracle.svm.core;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class SubstrateOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AOTInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform method inlining in the AOT compiled native image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AOTInline",
                /*option*/ SubstrateOptions.AOTInline);
        }
        case "AOTTrivialInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTTrivialInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform trivial method inlining in the AOT compiled native image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AOTTrivialInline",
                /*option*/ SubstrateOptions.AOTTrivialInline);
        }
        case "APIFunctionPrefix": {
            return OptionDescriptor.create(
                /*name*/ "APIFunctionPrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of API functions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "APIFunctionPrefix",
                /*option*/ SubstrateOptions.APIFunctionPrefix);
        }
        case "AllocateInstancePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocateInstancePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the object address using prefetch instructions generated in JIT compiled code.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocateInstancePrefetchLines",
                /*option*/ SubstrateOptions.AllocateInstancePrefetchLines);
        }
        case "AllocatePrefetchDistance": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchDistance",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchDistance",
                /*option*/ SubstrateOptions.AllocatePrefetchDistance);
        }
        case "AllocatePrefetchInstr": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchInstr",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchInstr",
                /*option*/ SubstrateOptions.AllocatePrefetchInstr);
        }
        case "AllocatePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the array allocation using prefetch instructions generated in JIT compiled code.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchLines",
                /*option*/ SubstrateOptions.AllocatePrefetchLines);
        }
        case "AllocatePrefetchStepSize": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStepSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the step size (in bytes) for sequential prefetch instructions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchStepSize",
                /*option*/ SubstrateOptions.AllocatePrefetchStepSize);
        }
        case "AllocatePrefetchStyle": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStyle",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchStyle",
                /*option*/ SubstrateOptions.AllocatePrefetchStyle);
        }
        case "CCompilerOption": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerOption",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String[].class,
                /*help*/ "Provide custom C compiler option used for query code compilation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CCompilerOption",
                /*option*/ SubstrateOptions.CCompilerOption);
        }
        case "CCompilerPath": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerPath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Provide custom path to C compiler used for query code compilation and linking.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CCompilerPath",
                /*option*/ SubstrateOptions.CCompilerPath);
        }
        case "CLibraryPath": {
            return OptionDescriptor.create(
                /*name*/ "CLibraryPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Search path for C libraries passed to the linker (list of comma-separated directories)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CLibraryPath",
                /*option*/ SubstrateOptions.CLibraryPath);
        }
        case "Class": {
            return OptionDescriptor.create(
                /*name*/ "Class",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Class containing the default entry point method. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Class",
                /*option*/ SubstrateOptions.Class);
        }
        case "CompilerBackend": {
            return OptionDescriptor.create(
                /*name*/ "CompilerBackend",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Backend used by the compiler",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CompilerBackend",
                /*option*/ SubstrateOptions.CompilerBackend);
        }
        case "DeleteLocalSymbols": {
            return OptionDescriptor.create(
                /*name*/ "DeleteLocalSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to remove all local symbols from image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeleteLocalSymbols",
                /*option*/ SubstrateOptions.DeleteLocalSymbols);
        }
        case "EmitStringEncodingSubstitutions": {
            return OptionDescriptor.create(
                /*name*/ "EmitStringEncodingSubstitutions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Emit substitutions for UTF16 and latin1 compression",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EmitStringEncodingSubstitutions",
                /*option*/ SubstrateOptions.EmitStringEncodingSubstitutions);
        }
        case "EnableAllSecurityServices": {
            return OptionDescriptor.create(
                /*name*/ "EnableAllSecurityServices",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Add all security service classes to the generated image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableAllSecurityServices",
                /*option*/ SubstrateOptions.EnableAllSecurityServices);
        }
        case "EnableURLProtocols": {
            return OptionDescriptor.create(
                /*name*/ "EnableURLProtocols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "List of comma separated URL protocols to enable.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableURLProtocols",
                /*option*/ SubstrateOptions.EnableURLProtocols);
        }
        case "EntryPointNamePrefix": {
            return OptionDescriptor.create(
                /*name*/ "EntryPointNamePrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of entry point methods.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EntryPointNamePrefix",
                /*option*/ SubstrateOptions.EntryPointNamePrefix);
        }
        case "FallbackThreshold": {
            return OptionDescriptor.create(
                /*name*/ "FallbackThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define when fallback-image generation should be used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FallbackThreshold",
                /*option*/ SubstrateOptions.FallbackThreshold);
        }
        case "FoldSecurityManagerGetter": {
            return OptionDescriptor.create(
                /*name*/ "FoldSecurityManagerGetter",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fold SecurityManager getter.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FoldSecurityManagerGetter",
                /*option*/ SubstrateOptions.FoldSecurityManagerGetter);
        }
        case "IncludeNodeSourcePositions": {
            return OptionDescriptor.create(
                /*name*/ "IncludeNodeSourcePositions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track NodeSourcePositions during runtime-compilation",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeNodeSourcePositions",
                /*option*/ SubstrateOptions.IncludeNodeSourcePositions);
        }
        case "JNI": {
            return OptionDescriptor.create(
                /*name*/ "JNI",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable Java Native Interface (JNI) support.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNI",
                /*option*/ SubstrateOptions.JNI);
        }
        case "JNIVerboseLookupErrors": {
            return OptionDescriptor.create(
                /*name*/ "JNIVerboseLookupErrors",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report information about known JNI elements when lookup fails",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNIVerboseLookupErrors",
                /*option*/ SubstrateOptions.JNIVerboseLookupErrors);
        }
        case "LinkerRPath": {
            return OptionDescriptor.create(
                /*name*/ "LinkerRPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Path passed to the linker as the -rpath (list of comma-separated directories)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "LinkerRPath",
                /*option*/ SubstrateOptions.LinkerRPath);
        }
        case "MaxInvokesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxInvokesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of invokes in a method so that it is considered trivial (for testing only).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxInvokesInTrivialMethod",
                /*option*/ SubstrateOptions.MaxInvokesInTrivialMethod);
        }
        case "MaxNodesInTrivialLeafMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialLeafMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesInTrivialLeafMethod",
                /*option*/ SubstrateOptions.MaxNodesInTrivialLeafMethod);
        }
        case "MaxNodesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesInTrivialMethod",
                /*option*/ SubstrateOptions.MaxNodesInTrivialMethod);
        }
        case "MaxUnrolledObjectZeroingStores": {
            return OptionDescriptor.create(
                /*name*/ "MaxUnrolledObjectZeroingStores",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define the maximum number of stores for which the loop that zeroes out objects is unrolled.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxUnrolledObjectZeroingStores",
                /*option*/ SubstrateOptions.MaxUnrolledObjectZeroingStores);
        }
        case "Method": {
            return OptionDescriptor.create(
                /*name*/ "Method",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the main entry point method. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Method",
                /*option*/ SubstrateOptions.Method);
        }
        case "MultiThreaded": {
            return OptionDescriptor.create(
                /*name*/ "MultiThreaded",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable support for threads and and thread-local variables (disable for single-threaded implementation)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MultiThreaded",
                /*option*/ SubstrateOptions.MultiThreaded);
        }
        case "Name": {
            return OptionDescriptor.create(
                /*name*/ "Name",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the output file to be generated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Name",
                /*option*/ SubstrateOptions.Name);
        }
        case "Optimize": {
            return OptionDescriptor.create(
                /*name*/ "Optimize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Control native-image code optimizations: 0 - no optimizations, 1 - basic optimizations, 2 - aggressive optimizations.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Optimize",
                /*option*/ SubstrateOptions.Optimize);
        }
        case "ParseRuntimeOptions": {
            return OptionDescriptor.create(
                /*name*/ "ParseRuntimeOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Parse and consume standard options and system properties from the command line arguments when the VM is created.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ParseRuntimeOptions",
                /*option*/ SubstrateOptions.ParseRuntimeOptions);
        }
        case "Path": {
            return OptionDescriptor.create(
                /*name*/ "Path",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Directory of the image file to be generated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Path",
                /*option*/ SubstrateOptions.Path);
        }
        case "PreserveFramePointer": {
            return OptionDescriptor.create(
                /*name*/ "PreserveFramePointer",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Saves stack base pointer on the stack on method entry.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PreserveFramePointer",
                /*option*/ SubstrateOptions.PreserveFramePointer);
        }
        case "PrintFlags": {
            return OptionDescriptor.create(
                /*name*/ "PrintFlags",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Show available options based on comma-separated option-types (allowed categories: User, Expert, Debug).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PrintFlags",
                /*option*/ SubstrateOptions.PrintFlags);
        }
        case "PrintGC": {
            return OptionDescriptor.create(
                /*name*/ "PrintGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after each collection",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PrintGC",
                /*option*/ SubstrateOptions.PrintGC);
        }
        case "PrintGCSummary": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCSummary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after main completion",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PrintGCSummary",
                /*option*/ SubstrateOptions.PrintGCSummary);
        }
        case "PrintGCTimeStamps": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimeStamps",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print a time stamp at each collection, if +PrintGC or +VerboseGC.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PrintGCTimeStamps",
                /*option*/ SubstrateOptions.PrintGCTimeStamps);
        }
        case "RemoveUnusedSymbols": {
            return OptionDescriptor.create(
                /*name*/ "RemoveUnusedSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to prevent unreferenced symbols in image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RemoveUnusedSymbols",
                /*option*/ SubstrateOptions.RemoveUnusedSymbols);
        }
        case "ReportAnalysisForbiddenType": {
            return OptionDescriptor.create(
                /*name*/ "ReportAnalysisForbiddenType",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, InTypeCheck).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ReportAnalysisForbiddenType",
                /*option*/ SubstrateOptions.ReportAnalysisForbiddenType);
        }
        case "RuntimeAssertions": {
            return OptionDescriptor.create(
                /*name*/ "RuntimeAssertions",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable or disable Java assert statements at run time",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RuntimeAssertions",
                /*option*/ SubstrateOptions.RuntimeAssertions);
        }
        case "RuntimeAssertionsFilter": {
            return OptionDescriptor.create(
                /*name*/ "RuntimeAssertionsFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Only use Java assert statements for classes that are matching the comma-separated list of package prefixes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RuntimeAssertionsFilter",
                /*option*/ SubstrateOptions.RuntimeAssertionsFilter);
        }
        case "SharedLibrary": {
            return OptionDescriptor.create(
                /*name*/ "SharedLibrary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build shared library",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SharedLibrary",
                /*option*/ SubstrateOptions.SharedLibrary);
        }
        case "SpawnIsolates": {
            return OptionDescriptor.create(
                /*name*/ "SpawnIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support multiple isolates. ",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SpawnIsolates",
                /*option*/ SubstrateOptions.SpawnIsolates);
        }
        case "StackTrace": {
            return OptionDescriptor.create(
                /*name*/ "StackTrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Provide method names for stack traces.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StackTrace",
                /*option*/ SubstrateOptions.StackTrace);
        }
        case "StaticExecutable": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutable",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build statically linked executable (requires static libc and zlib)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StaticExecutable",
                /*option*/ SubstrateOptions.StaticExecutable);
        }
        case "TearDownFailureNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownFailureNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TearDownFailureNanos",
                /*option*/ SubstrateOptions.TearDownFailureNanos);
        }
        case "TearDownWarningNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownWarningNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TearDownWarningNanos",
                /*option*/ SubstrateOptions.TearDownWarningNanos);
        }
        case "TraceClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "TraceClassInitialization",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instrument code to trace and report class initialization.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceClassInitialization",
                /*option*/ SubstrateOptions.TraceClassInitialization);
        }
        case "TraceVMOperations": {
            return OptionDescriptor.create(
                /*name*/ "TraceVMOperations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace VMOperation execution.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceVMOperations",
                /*option*/ SubstrateOptions.TraceVMOperations);
        }
        case "UseDedicatedVMOperationThread": {
            return OptionDescriptor.create(
                /*name*/ "UseDedicatedVMOperationThread",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if VM operations should be executed in a dedicated thread.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseDedicatedVMOperationThread",
                /*option*/ SubstrateOptions.UseDedicatedVMOperationThread);
        }
        case "UseOnlyWritableBootImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "UseOnlyWritableBootImageHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use only a writable native image heap.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseOnlyWritableBootImageHeap",
                /*option*/ SubstrateOptions.UseOnlyWritableBootImageHeap);
        }
        case "VerboseGC": {
            return OptionDescriptor.create(
                /*name*/ "VerboseGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print more information about the heap before and after each collection",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerboseGC",
                /*option*/ SubstrateOptions.VerboseGC);
        }
        case "VerifyNamingConventions": {
            return OptionDescriptor.create(
                /*name*/ "VerifyNamingConventions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify naming conventions during image construction.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyNamingConventions",
                /*option*/ SubstrateOptions.VerifyNamingConventions);
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 56;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AOTInline");
                    case 1: return get("AOTTrivialInline");
                    case 2: return get("APIFunctionPrefix");
                    case 3: return get("AllocateInstancePrefetchLines");
                    case 4: return get("AllocatePrefetchDistance");
                    case 5: return get("AllocatePrefetchInstr");
                    case 6: return get("AllocatePrefetchLines");
                    case 7: return get("AllocatePrefetchStepSize");
                    case 8: return get("AllocatePrefetchStyle");
                    case 9: return get("CCompilerOption");
                    case 10: return get("CCompilerPath");
                    case 11: return get("CLibraryPath");
                    case 12: return get("Class");
                    case 13: return get("CompilerBackend");
                    case 14: return get("DeleteLocalSymbols");
                    case 15: return get("EmitStringEncodingSubstitutions");
                    case 16: return get("EnableAllSecurityServices");
                    case 17: return get("EnableURLProtocols");
                    case 18: return get("EntryPointNamePrefix");
                    case 19: return get("FallbackThreshold");
                    case 20: return get("FoldSecurityManagerGetter");
                    case 21: return get("IncludeNodeSourcePositions");
                    case 22: return get("JNI");
                    case 23: return get("JNIVerboseLookupErrors");
                    case 24: return get("LinkerRPath");
                    case 25: return get("MaxInvokesInTrivialMethod");
                    case 26: return get("MaxNodesInTrivialLeafMethod");
                    case 27: return get("MaxNodesInTrivialMethod");
                    case 28: return get("MaxUnrolledObjectZeroingStores");
                    case 29: return get("Method");
                    case 30: return get("MultiThreaded");
                    case 31: return get("Name");
                    case 32: return get("Optimize");
                    case 33: return get("ParseRuntimeOptions");
                    case 34: return get("Path");
                    case 35: return get("PreserveFramePointer");
                    case 36: return get("PrintFlags");
                    case 37: return get("PrintGC");
                    case 38: return get("PrintGCSummary");
                    case 39: return get("PrintGCTimeStamps");
                    case 40: return get("RemoveUnusedSymbols");
                    case 41: return get("ReportAnalysisForbiddenType");
                    case 42: return get("RuntimeAssertions");
                    case 43: return get("RuntimeAssertionsFilter");
                    case 44: return get("SharedLibrary");
                    case 45: return get("SpawnIsolates");
                    case 46: return get("StackTrace");
                    case 47: return get("StaticExecutable");
                    case 48: return get("TearDownFailureNanos");
                    case 49: return get("TearDownWarningNanos");
                    case 50: return get("TraceClassInitialization");
                    case 51: return get("TraceVMOperations");
                    case 52: return get("UseDedicatedVMOperationThread");
                    case 53: return get("UseOnlyWritableBootImageHeap");
                    case 54: return get("VerboseGC");
                    case 55: return get("VerifyNamingConventions");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
