/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaThreadsFeature;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ThreadGroupNUnstartedThreadsRecomputation
implements RecomputeFieldValue.CustomFieldValueComputer {
    ThreadGroupNUnstartedThreadsRecomputation() {
    }

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        ThreadGroup group2 = (ThreadGroup)receiver;
        int result = 0;
        for (Thread thread : JavaThreadsFeature.singleton().reachableThreads.keySet()) {
            if (thread.getThreadGroup() != group2 || thread == JavaThreads.singleton().mainThread) continue;
            ++result;
        }
        return result;
    }
}

