/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JavaStackWalker {
    private JavaStackWalker() {
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    private static boolean initWalk(JavaStackWalk walk, Pointer startSP, CodePointer startIP) {
        walk.setSP(startSP);
        walk.setPossiblyStaleIP(startIP);
        walk.setStartSP(startSP);
        walk.setStartIP(startIP);
        walk.setAnchor(JavaFrameAnchors.getFrameAnchor());
        if (startIP.isNonNull()) {
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(startIP));
        } else {
            walk.setIPCodeInfo((UntetheredCodeInfo)WordFactory.nullPointer());
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean initWalk(JavaStackWalk walk, Pointer startSP) {
        boolean result = JavaStackWalker.initWalk(walk, startSP, (CodePointer)WordFactory.nullPointer());
        assert (walk.getIPCodeInfo().isNull()) : "otherwise, the caller would have to be uninterruptible as well";
        return result;
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean initWalk(JavaStackWalk walk, IsolateThread thread) {
        assert (VMOperation.isInProgressAtSafepoint()) : "Walking the stack of another thread is only safe when that thread is stopped at a safepoint";
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
        boolean result = anchor.isNonNull();
        Pointer sp = (Pointer)WordFactory.nullPointer();
        CodePointer ip = (CodePointer)WordFactory.nullPointer();
        if (result) {
            sp = anchor.getLastJavaSP();
            ip = anchor.getLastJavaIP();
        }
        walk.setSP(sp);
        walk.setPossiblyStaleIP(ip);
        walk.setStartSP(sp);
        walk.setStartIP(ip);
        walk.setAnchor(anchor);
        walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(ip));
        return result;
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean continueWalk(JavaStackWalk walk) {
        CodePointer ip;
        long totalFrameSize;
        if (walk.getSP().isNull() || walk.getPossiblyStaleIP().isNull()) {
            return false;
        }
        Pointer sp = walk.getSP();
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
        if (deoptFrame != null) {
            totalFrameSize = deoptFrame.getSourceTotalFrameSize();
        } else {
            ip = walk.getPossiblyStaleIP();
            CodeInfo info = CodeInfoAccess.convert(walk.getIPCodeInfo());
            totalFrameSize = JavaStackWalker.lookupTotalFrameSize0(info, ip);
        }
        if (totalFrameSize == -1L) {
            throw JavaStackWalker.unknownFrameEncountered(walk, sp, deoptFrame);
        }
        if (totalFrameSize != 1L) {
            sp = sp.add(WordFactory.unsigned((long)totalFrameSize));
            ip = FrameAccess.singleton().readReturnAddress(sp);
            walk.setSP(sp);
            walk.setPossiblyStaleIP(ip);
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(ip));
            return true;
        }
        JavaFrameAnchor anchor = walk.getAnchor();
        while (anchor.isNonNull() && anchor.getLastJavaSP().belowOrEqual((UnsignedWord)sp)) {
            anchor = anchor.getPreviousAnchor();
        }
        if (anchor.isNonNull()) {
            assert (anchor.getLastJavaSP().aboveThan((UnsignedWord)sp));
            walk.setSP(anchor.getLastJavaSP());
            walk.setPossiblyStaleIP(anchor.getLastJavaIP());
            walk.setAnchor(anchor.getPreviousAnchor());
            anchor.getLastJavaIP();
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(anchor.getLastJavaIP()));
            return true;
        }
        walk.setSP((Pointer)WordFactory.nullPointer());
        walk.setPossiblyStaleIP((CodePointer)WordFactory.nullPointer());
        walk.setAnchor((JavaFrameAnchor)WordFactory.nullPointer());
        return false;
    }

    @Uninterruptible(reason="Wraps the now safe call to look up the frame size.", calleeMustBe=false)
    private static long lookupTotalFrameSize0(CodeInfo info, CodePointer ip) {
        return CodeInfoAccess.lookupTotalFrameSize(info, CodeInfoAccess.relativeIP(info, ip));
    }

    @Uninterruptible(reason="Not really uninterruptible, but we are about to fatally fail.", calleeMustBe=false)
    private static RuntimeException unknownFrameEncountered(JavaStackWalk walk, Pointer sp, DeoptimizedFrame deoptFrame) {
        Log.log().string("Stack walk must walk only frames of known code:").string("  startSP=").hex((WordBase)walk.getStartSP()).string("  startIP=").hex((WordBase)walk.getStartIP()).string("  sp=").hex((WordBase)sp).string("  ip=").hex((WordBase)walk.getPossiblyStaleIP()).string(deoptFrame != null ? " (possibly before deopt)" : "").string("  deoptFrame=").object(deoptFrame).newline();
        throw VMError.shouldNotReachHere("Stack walk must walk only frames of known code");
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, StackFrameVisitor visitor) {
        return JavaStackWalker.walkCurrentThreadInline(startSP, visitor);
    }

    @AlwaysInline(value="Avoid virtual call to visitor - for the inlining, the caller must be uninterruptible as well.")
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean walkCurrentThreadInline(Pointer startSP, StackFrameVisitor visitor) {
        CodePointer startIP = FrameAccess.singleton().readReturnAddress(startSP);
        return JavaStackWalker.walkCurrentThreadWithForcedIPInline(startSP, startIP, visitor);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThreadWithForcedIP(Pointer startSP, CodePointer startIP, StackFrameVisitor visitor) {
        return JavaStackWalker.walkCurrentThreadWithForcedIPInline(startSP, startIP, visitor);
    }

    @AlwaysInline(value="Avoid virtual call to visitor - for the inlining, the caller must be uninterruptible as well.")
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean walkCurrentThreadWithForcedIPInline(Pointer startSP, CodePointer startIP, StackFrameVisitor visitor) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        boolean hasFrames = JavaStackWalker.initWalk(walk, startSP, startIP);
        return JavaStackWalker.doWalkCurrentThreadInline(walk, visitor, hasFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AlwaysInline(value="Avoid virtual call to visitor - for the inlining, the caller must be uninterruptible as well.")
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    private static boolean doWalkCurrentThreadInline(JavaStackWalk walk, StackFrameVisitor visitor, boolean hasFrames) {
        if (hasFrames) {
            while (true) {
                UntetheredCodeInfo untetheredInfo = walk.getIPCodeInfo();
                Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
                try {
                    if (!JavaStackWalker.callVisitorInline(walk, visitor)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (JavaStackWalker.continueWalk(walk)) continue;
                }
                finally {
                    CodeInfoAccess.releaseTether(untetheredInfo, tether);
                    continue;
                }
                break;
            }
        }
        return true;
    }

    @AlwaysInline(value="Avoid virtual call to visitor - for the inlining, the caller must be uninterruptible as well.")
    @Uninterruptible(reason="Wraps the now safe call to the possibly interruptible visitor.", callerMustBe=true, calleeMustBe=false)
    private static boolean callVisitorInline(JavaStackWalk walk, StackFrameVisitor visitor) {
        return visitor.visitFrame(walk.getSP(), walk.getPossiblyStaleIP(), CodeInfoAccess.convert(walk.getIPCodeInfo()), Deoptimizer.checkDeoptimized(walk.getSP()));
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkThread(IsolateThread thread, StackFrameVisitor visitor) {
        return JavaStackWalker.walkThreadInline(thread, visitor);
    }

    @AlwaysInline(value="Avoid virtual call to visitor - for the inlining, the caller must be uninterruptible as well.")
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean walkThreadInline(IsolateThread thread, StackFrameVisitor visitor) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        boolean hasFrames = JavaStackWalker.initWalk(walk, thread);
        return JavaStackWalker.doWalkCurrentThreadInline(walk, visitor, hasFrames);
    }
}

