/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.NativeImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.graalvm.compiler.options.OptionType;

class DefaultOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private static final String verboseOption = "--verbose";
    private static final String requireValidJarFileMessage = "-jar requires a valid jarfile";
    private static final String newStyleClasspathOptionName = "--class-path";
    static final String helpText = NativeImage.getResource("/Help.txt");
    static final String helpExtraText = NativeImage.getResource("/HelpExtra.txt");
    static final String noServerOption = "--no-server";
    static final String verboseServerOption = "--verbose-server";
    static final String serverOptionPrefix = "--server-";
    boolean useDebugAttach = false;
    boolean disableAtFiles = false;
    private static final String javaRuntimeVersion = System.getProperty("java.runtime.version");

    DefaultOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
    }

    private static void singleArgumentCheck(NativeImage.ArgumentQueue args, String arg) {
        if (!args.isEmpty()) {
            NativeImage.showError("Option " + arg + " cannot be combined with other options.");
        }
    }

    @Override
    public boolean consume(NativeImage.ArgumentQueue args) {
        String headArg;
        switch (headArg = args.peek()) {
            case "--help": {
                args.poll();
                DefaultOptionHandler.singleArgumentCheck(args, headArg);
                this.nativeImage.showMessage(helpText);
                this.nativeImage.showNewline();
                this.nativeImage.apiOptionHandler.printOptions(this.nativeImage::showMessage, false);
                this.nativeImage.showNewline();
                this.nativeImage.optionRegistry.showOptions(null, true, this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                System.exit(0);
                return true;
            }
            case "--version": {
                args.poll();
                DefaultOptionHandler.singleArgumentCheck(args, headArg);
                String message = NativeImage.IS_AOT ? System.getProperty("java.vm.version") : "native-image " + NativeImage.graalvmVersion + " " + NativeImage.graalvmConfig;
                message = message + " (Java Version " + javaRuntimeVersion + ")";
                this.nativeImage.showMessage(message);
                System.exit(0);
                return true;
            }
            case "--help-extra": {
                args.poll();
                DefaultOptionHandler.singleArgumentCheck(args, headArg);
                this.nativeImage.showMessage(helpExtraText);
                this.nativeImage.apiOptionHandler.printOptions(this.nativeImage::showMessage, true);
                this.nativeImage.showNewline();
                this.nativeImage.optionRegistry.showOptions(MacroOption.MacroOptionKind.Macro, true, this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                System.exit(0);
                return true;
            }
            case "-cp": 
            case "-classpath": 
            case "--class-path": {
                args.poll();
                String cpArgs = args.poll();
                if (cpArgs == null) {
                    NativeImage.showError(headArg + " requires class path specification");
                }
                this.processClasspathArgs(cpArgs);
                return true;
            }
            case "-p": 
            case "--module-path": {
                args.poll();
                String mpArgs = args.poll();
                if (mpArgs == null) {
                    NativeImage.showError(headArg + " requires module path specification");
                }
                this.processModulePathArgs(mpArgs);
                return true;
            }
            case "-m": 
            case "--module": {
                String[] mainClassModuleArgParts;
                args.poll();
                String mainClassModuleArg = args.poll();
                if (mainClassModuleArg == null) {
                    NativeImage.showError(headArg + " requires module name");
                }
                if ((mainClassModuleArgParts = mainClassModuleArg.split("/", 2)).length > 1) {
                    this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHClass + mainClassModuleArgParts[1]);
                }
                this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHModule + mainClassModuleArgParts[0]);
                this.nativeImage.setModuleOptionMode(true);
                return true;
            }
            case "--configurations-path": {
                args.poll();
                String configPath = args.poll();
                if (configPath == null) {
                    NativeImage.showError(headArg + " requires a " + File.pathSeparator + " separated list of directories");
                }
                for (String configDir : configPath.split(File.pathSeparator)) {
                    this.nativeImage.addMacroOptionRoot(this.nativeImage.canonicalize(Paths.get(configDir, new String[0])));
                }
                return true;
            }
            case "-jar": {
                args.poll();
                String jarFilePathStr = args.poll();
                if (jarFilePathStr == null) {
                    NativeImage.showError(requireValidJarFileMessage);
                }
                this.handleJarFileArg(this.nativeImage.canonicalize(Paths.get(jarFilePathStr, new String[0])));
                this.nativeImage.setJarOptionMode(true);
                return true;
            }
            case "--verbose": {
                args.poll();
                this.nativeImage.setVerbose(true);
                return true;
            }
            case "--dry-run": {
                args.poll();
                this.nativeImage.setDryRun(true);
                return true;
            }
            case "--expert-options": {
                args.poll();
                this.nativeImage.setPrintFlagsOptionQuery(OptionType.User.name());
                return true;
            }
            case "--expert-options-all": {
                args.poll();
                this.nativeImage.setPrintFlagsOptionQuery("");
                return true;
            }
            case "--expert-options-detail": {
                args.poll();
                String optionNames = args.poll();
                this.nativeImage.setPrintFlagsWithExtraHelpOptionQuery(optionNames);
                return true;
            }
            case "--no-server": 
            case "--verbose-server": {
                args.poll();
                NativeImage.showWarning("Ignoring server-mode native-image argument " + headArg + ".");
                return true;
            }
            case "--exclude-config": {
                String excludeConfig;
                args.poll();
                String excludeJar = args.poll();
                if (excludeJar == null) {
                    NativeImage.showError(headArg + " requires two arguments: a jar regular expression and a resource regular expression");
                }
                if ((excludeConfig = args.poll()) == null) {
                    NativeImage.showError(headArg + " requires resource regular expression");
                }
                this.nativeImage.addExcludeConfig(Pattern.compile(excludeJar), Pattern.compile(excludeConfig));
                return true;
            }
            case "--diagnostics-mode": {
                args.poll();
                this.nativeImage.setDiagnostics(true);
                this.nativeImage.addPlainImageBuilderArg("-H:+DiagnosticsMode");
                this.nativeImage.addPlainImageBuilderArg("-H:DiagnosticsDir=" + this.nativeImage.diagnosticsDir);
                System.out.println("# Diagnostics mode enabled: image-build reports are saved to " + this.nativeImage.diagnosticsDir);
                return true;
            }
            case "--disable-@files": {
                args.poll();
                this.disableAtFiles = true;
                return true;
            }
        }
        String debugAttach = "--debug-attach";
        if (headArg.startsWith(debugAttach)) {
            if (this.useDebugAttach) {
                throw NativeImage.showError("The " + debugAttach + " option can only be used once.");
            }
            this.useDebugAttach = true;
            String debugAttachArg = args.poll();
            String addressSuffix = debugAttachArg.substring(debugAttach.length());
            String address = addressSuffix.isEmpty() ? "8000" : addressSuffix.substring(1);
            this.nativeImage.addImageBuilderJavaArgs("-agentlib:jdwp=transport=dt_socket,server=y,address=" + address + ",suspend=y");
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHDeadlockWatchdogInterval + "0");
            return true;
        }
        String singleArgClasspathPrefix = "--class-path=";
        if (headArg.startsWith(singleArgClasspathPrefix)) {
            String cpArgs = args.poll().substring(singleArgClasspathPrefix.length());
            if (cpArgs.isEmpty()) {
                NativeImage.showError(headArg + " requires class path specification");
            }
            this.processClasspathArgs(cpArgs);
            return true;
        }
        if (headArg.startsWith("-H:")) {
            args.poll();
            this.nativeImage.addCustomImageBuilderArgs(NativeImage.injectHostedOptionOrigin(headArg, args.argumentOrigin));
            return true;
        }
        if (headArg.startsWith("-R:")) {
            args.poll();
            this.nativeImage.addCustomImageBuilderArgs(headArg);
            return true;
        }
        String javaArgsPrefix = "-D";
        if (headArg.startsWith(javaArgsPrefix)) {
            args.poll();
            this.nativeImage.addCustomJavaArgs(headArg);
            return true;
        }
        String optionKeyPrefix = "-V";
        if (headArg.startsWith(optionKeyPrefix)) {
            args.poll();
            String keyValueStr = headArg.substring(optionKeyPrefix.length());
            String[] keyValue = keyValueStr.split("=");
            if (keyValue.length != 2) {
                throw NativeImage.showError("Use " + optionKeyPrefix + "<key>=<value>");
            }
            this.nativeImage.addOptionKeyValue(keyValue[0], keyValue[1]);
            return true;
        }
        if (headArg.startsWith("-J")) {
            args.poll();
            if (headArg.equals("-J")) {
                NativeImage.showError("The -J option should not be followed by a space");
            } else {
                this.nativeImage.addCustomJavaArgs(headArg.substring(2));
            }
            return true;
        }
        String optimizeOption = "-O";
        if (headArg.startsWith(optimizeOption)) {
            args.poll();
            if (headArg.equals(optimizeOption)) {
                NativeImage.showError("The " + optimizeOption + " option should not be followed by a space");
            } else {
                this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHOptimize + headArg.substring(2));
            }
            return true;
        }
        if (headArg.startsWith(serverOptionPrefix)) {
            args.poll();
            NativeImage.showWarning("Ignoring server-mode native-image argument " + headArg + ".");
            String serverOptionCommand = headArg.substring(serverOptionPrefix.length());
            if (!serverOptionCommand.startsWith("session=")) {
                System.exit(0);
            }
            return true;
        }
        if (headArg.startsWith("@") && !this.disableAtFiles) {
            args.poll();
            headArg = headArg.substring(1);
            Path argFile = Paths.get(headArg, new String[0]);
            NativeImage nativeImage = this.nativeImage;
            nativeImage.getClass();
            NativeImage.NativeImageArgsProcessor processor = nativeImage.new NativeImage.NativeImageArgsProcessor(argFile.toString());
            this.readArgFile(argFile).forEach(processor::accept);
            List<String> leftoverArgs = processor.apply(false);
            if (leftoverArgs.size() > 0) {
                NativeImage.showError("Found unrecognized options while parsing argument file '" + argFile + "':\n" + String.join((CharSequence)"\n", leftoverArgs));
            }
            return true;
        }
        return false;
    }

    private List<String> readArgFile(Path file) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--disable-@files");
        String options = null;
        try {
            options = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NativeImage.showError("Error reading argument file", e);
        }
        CTX_ARGS ctx = new CTX_ARGS();
        ctx.state = PARSER_STATE.FIND_NEXT;
        ctx.parts = new ArrayList<String>(4);
        ctx.quoteChar = (char)34;
        ctx.cptr = 0;
        ctx.eob = options.length();
        ctx.options = options;
        String token = DefaultOptionHandler.nextToken(ctx);
        while (token != null) {
            arguments.add(token);
            token = DefaultOptionHandler.nextToken(ctx);
        }
        if ((ctx.state == PARSER_STATE.IN_TOKEN || ctx.state == PARSER_STATE.IN_QUOTE) && ctx.parts.size() != 0) {
            token = String.join((CharSequence)"", ctx.parts);
            arguments.add(token);
        }
        return arguments;
    }

    private static String nextToken(CTX_ARGS ctx) {
        int nextc;
        int eob = ctx.eob;
        int anchor = nextc;
        block13: for (nextc = ctx.cptr; nextc < eob; ++nextc) {
            char ch = ctx.options.charAt(nextc);
            if (ctx.state == PARSER_STATE.FIND_NEXT || ctx.state == PARSER_STATE.SKIP_LEAD_WS) {
                while (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f') {
                    if (++nextc >= eob) {
                        return null;
                    }
                    ch = ctx.options.charAt(nextc);
                }
                ctx.state = ctx.state == PARSER_STATE.FIND_NEXT ? PARSER_STATE.IN_TOKEN : PARSER_STATE.IN_QUOTE;
                anchor = nextc;
            } else {
                if (ctx.state == PARSER_STATE.IN_ESCAPE) {
                    if (ch == '\n' || ch == '\r') {
                        ctx.state = PARSER_STATE.SKIP_LEAD_WS;
                    } else {
                        char[] escaped = new char[2];
                        escaped[1] = '\u0000';
                        switch (ch) {
                            case 'n': {
                                escaped[0] = 10;
                                break;
                            }
                            case 'r': {
                                escaped[0] = 13;
                                break;
                            }
                            case 't': {
                                escaped[0] = 9;
                                break;
                            }
                            case 'f': {
                                escaped[0] = 12;
                                break;
                            }
                            default: {
                                escaped[0] = ch;
                            }
                        }
                        ctx.parts.add(String.valueOf(escaped));
                        ctx.state = PARSER_STATE.IN_QUOTE;
                    }
                    anchor = nextc + 1;
                    continue;
                }
                if (ctx.state == PARSER_STATE.IN_COMMENT) {
                    while (ch != '\n' && ch != '\r') {
                        if (++nextc >= eob) {
                            return null;
                        }
                        ch = ctx.options.charAt(nextc);
                    }
                    anchor = nextc + 1;
                    ctx.state = PARSER_STATE.FIND_NEXT;
                    continue;
                }
            }
            assert (ctx.state != PARSER_STATE.IN_ESCAPE);
            assert (ctx.state != PARSER_STATE.FIND_NEXT);
            assert (ctx.state != PARSER_STATE.SKIP_LEAD_WS);
            assert (ctx.state != PARSER_STATE.IN_COMMENT);
            switch (ch) {
                case '\t': 
                case '\f': 
                case ' ': {
                    if (ctx.state == PARSER_STATE.IN_QUOTE) continue block13;
                }
                case '\n': 
                case '\r': {
                    String token;
                    if (ctx.parts.size() == 0) {
                        token = ctx.options.substring(anchor, nextc);
                    } else {
                        ctx.parts.add(ctx.options.substring(anchor, nextc));
                        token = String.join((CharSequence)"", ctx.parts);
                        ctx.parts = new ArrayList<String>();
                    }
                    ctx.cptr = nextc + 1;
                    ctx.state = PARSER_STATE.FIND_NEXT;
                    return token;
                }
                case '#': {
                    if (ctx.state == PARSER_STATE.IN_QUOTE) continue block13;
                    ctx.state = PARSER_STATE.IN_COMMENT;
                    anchor = nextc + 1;
                    continue block13;
                }
                case '\\': {
                    if (ctx.state != PARSER_STATE.IN_QUOTE) continue block13;
                    ctx.parts.add(ctx.options.substring(anchor, nextc));
                    ctx.state = PARSER_STATE.IN_ESCAPE;
                    anchor = nextc + 1;
                    continue block13;
                }
                case '\"': 
                case '\'': {
                    if (ctx.state == PARSER_STATE.IN_QUOTE && ctx.quoteChar != ch) continue block13;
                    if (anchor != nextc) {
                        ctx.parts.add(ctx.options.substring(anchor, nextc));
                    }
                    anchor = nextc + 1;
                    if (ctx.state == PARSER_STATE.IN_TOKEN) {
                        ctx.quoteChar = ch;
                        ctx.state = PARSER_STATE.IN_QUOTE;
                        continue block13;
                    }
                    ctx.state = PARSER_STATE.IN_TOKEN;
                    continue block13;
                }
            }
        }
        assert (nextc == eob);
        if ((ctx.state == PARSER_STATE.IN_TOKEN || ctx.state == PARSER_STATE.IN_QUOTE) && anchor < nextc) {
            ctx.parts.add(ctx.options.substring(anchor, nextc));
        }
        return null;
    }

    private void processClasspathArgs(String cpArgs) {
        for (String cp : cpArgs.split(File.pathSeparator, Integer.MAX_VALUE)) {
            String cpEntry = cp.isEmpty() ? "." : cp;
            this.nativeImage.addCustomImageClasspath(cpEntry);
        }
    }

    private void processModulePathArgs(String mpArgs) {
        for (String mpEntry : mpArgs.split(File.pathSeparator, Integer.MAX_VALUE)) {
            this.nativeImage.addImageModulePath(Paths.get(mpEntry, new String[0]), false);
        }
    }

    private void handleJarFileArg(Path filePath) {
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            NativeImage.showError(filePath + " is a directory. (" + requireValidJarFileMessage + ")");
        }
        if (!NativeImage.processJarManifestMainAttributes(filePath, this.nativeImage::handleMainClassAttribute)) {
            NativeImage.showError("No manifest in " + filePath);
        }
        this.nativeImage.addCustomImageClasspath(filePath);
    }

    @Override
    void addFallbackBuildArgs(List<String> buildArgs) {
        if (this.nativeImage.isVerbose()) {
            buildArgs.add(verboseOption);
        }
    }

    class CTX_ARGS {
        PARSER_STATE state;
        int cptr;
        int eob;
        char quoteChar;
        List<String> parts;
        String options;

        CTX_ARGS() {
        }
    }

    static enum PARSER_STATE {
        FIND_NEXT,
        IN_COMMENT,
        IN_QUOTE,
        IN_ESCAPE,
        SKIP_LEAD_WS,
        IN_TOKEN;

    }
}

