/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.APIOptionGroup;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.driver.APIOptionSupport;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.nativeimage.ImageSingletons;

class APIOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private final SortedMap<String, OptionInfo> apiOptions;

    APIOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
        if (NativeImage.IS_AOT) {
            this.apiOptions = ((APIOptionSupport)ImageSingletons.lookup(APIOptionSupport.class)).options;
        } else {
            ArrayList<Class<? extends OptionDescriptors>> optionDescriptorsList = new ArrayList<Class<? extends OptionDescriptors>>();
            ServiceLoader<OptionDescriptors> serviceLoader = ServiceLoader.load(OptionDescriptors.class, nativeImage.getClass().getClassLoader());
            for (OptionDescriptors optionDescriptors : serviceLoader) {
                optionDescriptorsList.add(optionDescriptors.getClass());
            }
            this.apiOptions = APIOptionHandler.extractOptions(optionDescriptorsList);
        }
    }

    static SortedMap<String, OptionInfo> extractOptions(List<Class<? extends OptionDescriptors>> optionsClasses) {
        EconomicMap hostedOptions = EconomicMap.create();
        EconomicMap runtimeOptions = EconomicMap.create();
        HostedOptionParser.collectOptions(optionsClasses, (EconomicMap)hostedOptions, (EconomicMap)runtimeOptions);
        TreeMap<String, OptionInfo> apiOptions = new TreeMap<String, OptionInfo>();
        HashMap<String, List> groupDefaults = new HashMap<String, List>();
        HashMap groupInstances = new HashMap();
        hostedOptions.getValues().forEach(o -> APIOptionHandler.extractOption("-H:", o, apiOptions, groupDefaults, groupInstances));
        runtimeOptions.getValues().forEach(o -> APIOptionHandler.extractOption("-R:", o, apiOptions, groupDefaults, groupInstances));
        groupDefaults.forEach((groupName, defaults) -> {
            if (defaults.size() > 1) {
                VMError.shouldNotReachHere((String)String.format("APIOptionGroup %s must only have a single default (but has: %s)", groupName, String.join((CharSequence)", ", defaults)));
            }
        });
        return apiOptions;
    }

    private static void extractOption(String optionPrefix, OptionDescriptor optionDescriptor, SortedMap<String, OptionInfo> apiOptions, Map<String, List<String>> groupDefaults, Map<Class<? extends APIOptionGroup>, APIOptionGroup> groupInstances) {
        try {
            APIOption[] apiAnnotations;
            Field optionField = optionDescriptor.getDeclaringClass().getDeclaredField(optionDescriptor.getFieldName());
            for (APIOption apiAnnotation : apiAnnotations = (APIOption[])optionField.getAnnotationsByType(APIOption.class)) {
                String builderOption = optionPrefix;
                if (apiAnnotation.name().length <= 0) {
                    VMError.shouldNotReachHere((String)String.format("APIOption for %s does not provide a name entry", optionDescriptor.getLocation()));
                }
                String apiOptionName = APIOption.Utils.optionName((String)apiAnnotation.name()[0]);
                String rawOptionName = optionDescriptor.getName();
                APIOptionGroup group = null;
                String defaultValue = null;
                boolean booleanOption = false;
                Class<?> optionValueType = optionDescriptor.getOptionValueType();
                if (optionValueType.isArray()) {
                    VMError.guarantee((boolean)(optionDescriptor.getOptionKey() instanceof HostedOptionKey), (String)"Only HostedOptionKeys are allowed to have array type key values.");
                    optionValueType = optionValueType.getComponentType();
                }
                if (optionValueType.equals(Boolean.class)) {
                    if (!apiAnnotation.group().equals(APIOption.NullGroup.class)) {
                        try {
                            Class groupClass = apiAnnotation.group();
                            group = groupInstances.computeIfAbsent(groupClass, ReflectionUtil::newInstance);
                            String groupName = APIOption.Utils.groupName((APIOptionGroup)group);
                            if (group.helpText() == null || group.helpText().isEmpty()) {
                                VMError.shouldNotReachHere((String)String.format("APIOptionGroup %s(%s) needs to provide help text", groupClass.getName(), group.name()));
                            }
                            String groupMember = apiAnnotation.name()[0];
                            apiOptionName = groupName + groupMember;
                            Boolean isEnabled = (Boolean)optionDescriptor.getOptionKey().getDefaultValue();
                            if (isEnabled.booleanValue()) {
                                groupDefaults.computeIfAbsent(groupName, cls -> new ArrayList()).add(groupMember);
                                defaultValue = groupMember;
                            }
                        }
                        catch (ReflectionUtil.ReflectionUtilError ex) {
                            throw VMError.shouldNotReachHere((String)("Class specified as group for @APIOption " + apiOptionName + " cannot be loaded or instantiated: " + apiAnnotation.group().getTypeName()), (Throwable)ex.getCause());
                        }
                    }
                    if (apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Paths)) {
                        VMError.shouldNotReachHere((String)String.format("Boolean APIOption %s(%s) cannot use APIOptionKind.Paths", apiOptionName, rawOptionName));
                    }
                    if (apiAnnotation.defaultValue().length > 0) {
                        VMError.shouldNotReachHere((String)String.format("Boolean APIOption %s(%s) cannot use APIOption.defaultValue", apiOptionName, rawOptionName));
                    }
                    if (apiAnnotation.fixedValue().length > 0) {
                        VMError.shouldNotReachHere((String)String.format("Boolean APIOption %s(%s) cannot use APIOption.fixedValue", apiOptionName, rawOptionName));
                    }
                    builderOption = builderOption + (apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Negated) ? "-" : "+");
                    builderOption = builderOption + rawOptionName;
                    booleanOption = true;
                } else {
                    if (!apiAnnotation.group().equals(APIOption.NullGroup.class)) {
                        VMError.shouldNotReachHere((String)String.format("Using @APIOption.group not supported for non-boolean APIOption %s(%s)", apiOptionName, rawOptionName));
                    }
                    if (apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Negated)) {
                        VMError.shouldNotReachHere((String)String.format("Non-boolean APIOption %s(%s) cannot use APIOptionKind.Negated", apiOptionName, rawOptionName));
                    }
                    if (apiAnnotation.defaultValue().length > 1) {
                        VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) cannot have more than one APIOption.defaultValue", apiOptionName, rawOptionName));
                    }
                    if (apiAnnotation.fixedValue().length > 1) {
                        VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) cannot have more than one APIOption.fixedValue", apiOptionName, rawOptionName));
                    }
                    if (apiAnnotation.fixedValue().length > 0 && apiAnnotation.defaultValue().length > 0) {
                        VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) APIOption.defaultValue and APIOption.fixedValue cannot be combined", apiOptionName, rawOptionName));
                    }
                    if (apiAnnotation.defaultValue().length > 0) {
                        defaultValue = apiAnnotation.defaultValue()[0];
                    }
                    if (apiAnnotation.fixedValue().length > 0) {
                        defaultValue = apiAnnotation.fixedValue()[0];
                    }
                    builderOption = builderOption + rawOptionName;
                    builderOption = builderOption + "=";
                }
                String helpText = optionDescriptor.getHelp();
                if (!apiAnnotation.customHelp().isEmpty()) {
                    helpText = apiAnnotation.customHelp();
                }
                if (helpText == null || helpText.isEmpty()) {
                    VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) needs to provide help text", apiOptionName, rawOptionName));
                }
                if (group == null) {
                    helpText = APIOptionHandler.startLowerCase(helpText);
                }
                ArrayList<Function<Object, Object>> valueTransformers = new ArrayList<Function<Object, Object>>(apiAnnotation.valueTransformer().length);
                for (Class transformerClass : apiAnnotation.valueTransformer()) {
                    try {
                        valueTransformers.add((Function<Object, Object>)ReflectionUtil.newInstance((Class)transformerClass));
                    }
                    catch (ReflectionUtil.ReflectionUtilError ex) {
                        throw VMError.shouldNotReachHere((String)("Class specified as valueTransformer for @APIOption " + apiOptionName + " cannot be loaded or instantiated: " + transformerClass.getTypeName()), (Throwable)ex.getCause());
                    }
                }
                apiOptions.put(apiOptionName, new OptionInfo(apiAnnotation.name(), apiAnnotation.valueSeparator(), builderOption, defaultValue, helpText, apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Paths), booleanOption || apiAnnotation.fixedValue().length > 0, apiAnnotation.deprecated(), valueTransformers, group, apiAnnotation.extra()));
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private static String startLowerCase(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    @Override
    boolean consume(NativeImage.ArgumentQueue args) {
        String headArg = args.peek();
        String translatedOption = this.translateOption(headArg);
        if (translatedOption != null) {
            args.poll();
            this.nativeImage.addPlainImageBuilderArg(NativeImage.injectHostedOptionOrigin(translatedOption, args.argumentOrigin));
            return true;
        }
        return false;
    }

    String translateOption(String arg) {
        OptionInfo option = null;
        String[] optionNameAndOptionValue = null;
        block0: for (OptionInfo optionInfo : this.apiOptions.values()) {
            for (String variant : optionInfo.variants) {
                String optionName = optionInfo.group == null ? APIOption.Utils.optionName((String)variant) : APIOption.Utils.groupName((APIOptionGroup)optionInfo.group) + variant;
                if (arg.equals(optionName)) {
                    option = optionInfo;
                    optionNameAndOptionValue = new String[]{optionName};
                    break block0;
                }
                if (!arg.startsWith(optionName + optionInfo.valueSeparator)) continue;
                option = optionInfo;
                optionNameAndOptionValue = SubstrateUtil.split((String)arg, (String)Character.toString(optionInfo.valueSeparator), (int)2);
                break block0;
            }
        }
        if (option != null) {
            String optionValue;
            if (!option.deprecationWarning.isEmpty()) {
                NativeImage.showWarning("Using a deprecated option " + (String)optionNameAndOptionValue[0] + ". " + option.deprecationWarning);
            }
            String builderOption = option.builderOption;
            String string = optionValue = option.group != null ? null : option.defaultValue;
            if (optionNameAndOptionValue.length == 2) {
                if (option.defaultFinal) {
                    NativeImage.showError("Passing values to option " + (String)optionNameAndOptionValue[0] + " is not supported.");
                }
                optionValue = optionNameAndOptionValue[1];
            }
            if (optionValue != null) {
                if (option.hasPathArguments) {
                    optionValue = Arrays.stream(SubstrateUtil.split((String)optionValue, (String)",")).filter(s -> !s.isEmpty()).map(this::tryCanonicalize).collect(Collectors.joining(","));
                }
                Object transformed = optionValue;
                for (Function<Object, Object> transformer : option.valueTransformers) {
                    transformed = transformer.apply(transformed);
                }
                builderOption = builderOption + transformed.toString();
            }
            return builderOption;
        }
        return null;
    }

    private String tryCanonicalize(String path) {
        try {
            return this.nativeImage.canonicalize(Paths.get(path, new String[0])).toString();
        }
        catch (NativeImage.NativeImageError e) {
            return path;
        }
    }

    void printOptions(Consumer<String> println, boolean extra) {
        TreeMap<String, List> optionInfo = new TreeMap<String, List>();
        this.apiOptions.forEach((optionName, option) -> {
            String groupOrOptionName;
            if (option.isDeprecated() || option.extra != extra) {
                return;
            }
            String string = groupOrOptionName = option.group != null ? APIOption.Utils.groupName((APIOptionGroup)option.group) : optionName;
            if (optionInfo.containsKey(groupOrOptionName)) {
                ArrayList<OptionInfo> options = (ArrayList<OptionInfo>)optionInfo.get(groupOrOptionName);
                if (options.size() == 1) {
                    options = new ArrayList<OptionInfo>(options);
                    optionInfo.put(groupOrOptionName, options);
                }
                options.add((OptionInfo)option);
            } else {
                optionInfo.put(groupOrOptionName, Collections.singletonList(option));
            }
        });
        optionInfo.forEach((optionName, options) -> {
            if (options.size() == 1) {
                OptionInfo singleOption = (OptionInfo)options.get(0);
                if (singleOption.group == null) {
                    SubstrateOptionsParser.printOption((Consumer)println, (String)optionName, (String)singleOption.helpText, (int)4, (int)22, (int)66);
                } else if (!Arrays.asList(singleOption.variants).contains(singleOption.defaultValue)) {
                    APIOptionHandler.printGroupOption(println, optionName, options);
                }
            } else {
                APIOptionHandler.printGroupOption(println, optionName, options);
            }
        });
    }

    private static void printGroupOption(Consumer<String> println, String groupName, List<OptionInfo> options) {
        APIOptionGroup group = options.get((int)0).group;
        assert (group != null);
        StringBuilder sb = new StringBuilder();
        sb.append(APIOptionHandler.startLowerCase(group.helpText()));
        if (!group.helpText().endsWith(".")) {
            sb.append(".");
        }
        sb.append(" Allowed options for <value>:");
        SubstrateOptionsParser.printOption(println, (String)(groupName + "<value>"), (String)sb.toString(), (int)4, (int)22, (int)66);
        for (OptionInfo groupEntry : options) {
            assert (groupEntry.group == group);
            sb.setLength(0);
            boolean first = true;
            boolean isDefault = false;
            for (String variant : groupEntry.variants) {
                if (variant.equals(groupEntry.defaultValue)) {
                    isDefault = true;
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(" | ");
                }
                sb.append("'").append(variant).append("'");
            }
            sb.append(": ").append(groupEntry.helpText);
            if (isDefault) {
                sb.append(" (default)");
            }
            SubstrateOptionsParser.printOption(println, (String)"", (String)sb.toString(), (int)4, (int)22, (int)66);
        }
    }

    static final class OptionInfo {
        final String[] variants;
        final char valueSeparator;
        final String builderOption;
        final String defaultValue;
        final String helpText;
        final boolean hasPathArguments;
        final boolean defaultFinal;
        final String deprecationWarning;
        final boolean extra;
        final List<Function<Object, Object>> valueTransformers;
        final APIOptionGroup group;

        OptionInfo(String[] variants, char valueSeparator, String builderOption, String defaultValue, String helpText, boolean hasPathArguments, boolean defaultFinal, String deprecationWarning, List<Function<Object, Object>> valueTransformers, APIOptionGroup group, boolean extra) {
            this.variants = variants;
            this.valueSeparator = valueSeparator;
            this.builderOption = builderOption;
            this.defaultValue = defaultValue;
            this.helpText = helpText;
            this.hasPathArguments = hasPathArguments;
            this.defaultFinal = defaultFinal;
            this.deprecationWarning = deprecationWarning;
            this.valueTransformers = valueTransformers;
            this.group = group;
            this.extra = extra;
        }

        boolean isDeprecated() {
            return this.deprecationWarning.length() > 0;
        }
    }
}

