/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.util.LogUtils;
import java.util.List;
import jdk.graal.compiler.phases.common.LazyValue;
import org.graalvm.collections.EconomicMap;

class JniProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;

    JniProcessor(AccessAdvisor advisor) {
        this.advisor = advisor;
    }

    @Override
    void processEntry(EconomicMap<String, Object> entry, ConfigurationSet configurationSet) {
        UnresolvedConfigurationCondition condition = UnresolvedConfigurationCondition.alwaysTrue();
        boolean invalidResult = Boolean.FALSE.equals(entry.get((Object)"result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get((Object)"function");
        String callerClass = (String)entry.get((Object)"caller_class");
        List args = (List)entry.get((Object)"args");
        LazyValue<String> callerClassLazyValue = LazyValueUtils.lazyValue(callerClass);
        if (function.equals("FindClass") || function.equals("DefineClass")) {
            String jniName = (String)JniProcessor.singleElement(args);
            if (ClassNameSupport.isValidJNIName(jniName)) {
                NamedConfigurationTypeDescriptor type = NamedConfigurationTypeDescriptor.fromJNIName(jniName);
                LazyValue<String> reflectionName = LazyValueUtils.lazyValue(ClassNameSupport.jniNameToReflectionName(jniName));
                if (!this.advisor.shouldIgnore(reflectionName, callerClassLazyValue, entry)) {
                    if (function.equals("FindClass")) {
                        if (!this.advisor.shouldIgnoreJniLookup(function, reflectionName, LazyValueUtils.lazyNull(), LazyValueUtils.lazyNull(), callerClassLazyValue, entry)) {
                            configurationSet.getReflectionConfiguration().getOrCreateType(condition, type).setJniAccessible();
                        }
                    } else if (!AccessAdvisor.PROXY_CLASS_NAME_PATTERN.matcher(jniName).matches()) {
                        LogUtils.warning((String)("Unsupported JNI function DefineClass used to load class " + jniName));
                    }
                }
            }
            return;
        }
        ConfigurationTypeDescriptor clazz = JniProcessor.descriptorForClass(entry.get((Object)"class"));
        if (clazz.getAllQualifiedJavaNames().stream().anyMatch(c -> this.advisor.shouldIgnore(LazyValueUtils.lazyValue(c), callerClassLazyValue, entry))) {
            return;
        }
        boolean hasDeclaringClass = entry.containsKey((Object)"declaring_class");
        ConfigurationTypeDescriptor declaringClass = hasDeclaringClass ? JniProcessor.descriptorForClass(entry.get((Object)"declaring_class")) : null;
        ConfigurationTypeDescriptor declaringClassOrClazz = hasDeclaringClass ? declaringClass : clazz;
        ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration = hasDeclaringClass ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED : ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT;
        TypeConfiguration config = configurationSet.getReflectionConfiguration();
        boolean makeTypeJniAccessible = true;
        switch (function) {
            case "AllocObject": {
                JniProcessor.expectSize(args, 0);
                configurationSet.getReflectionConfiguration().getOrCreateType(condition, clazz).setUnsafeAllocated();
                break;
            }
            case "GetStaticMethodID": 
            case "GetMethodID": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                String signature = (String)args.get(1);
                if (!clazz.getAllQualifiedJavaNames().stream().noneMatch(c -> this.advisor.shouldIgnoreJniLookup(function, LazyValueUtils.lazyValue(c), LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(signature), callerClassLazyValue, entry))) break;
                ConfigurationType type = JniProcessor.getOrCreateJniAccessibleType(config, condition, declaringClassOrClazz);
                type.addMethod(name, signature, declaration);
                if (declaringClassOrClazz.equals(clazz)) break;
                config.getOrCreateType(condition, clazz);
                break;
            }
            case "GetFieldID": 
            case "GetStaticFieldID": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                String signature = (String)args.get(1);
                if (!clazz.getAllQualifiedJavaNames().stream().noneMatch(c -> this.advisor.shouldIgnoreJniLookup(function, LazyValueUtils.lazyValue(c), LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(signature), callerClassLazyValue, entry))) break;
                ConfigurationType type = JniProcessor.getOrCreateJniAccessibleType(config, condition, declaringClassOrClazz);
                type.addField(name, declaration, false);
                if (declaringClassOrClazz.equals(clazz)) break;
                config.getOrCreateType(condition, clazz);
                break;
            }
            case "ThrowNew": {
                JniProcessor.expectSize(args, 1);
                String name = "<init>";
                String signature = "(Ljava/lang/String;)V";
                if (!clazz.getAllQualifiedJavaNames().stream().noneMatch(c -> this.advisor.shouldIgnoreJniLookup(function, LazyValueUtils.lazyValue(c), LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(signature), callerClassLazyValue, entry))) break;
                ConfigurationType type = JniProcessor.getOrCreateJniAccessibleType(config, condition, declaringClassOrClazz);
                type.addMethod(name, signature, declaration);
                assert (declaringClassOrClazz.equals(clazz)) : "Constructor can only be accessed via declaring class";
                break;
            }
            case "ToReflectedField": {
                makeTypeJniAccessible = false;
            }
            case "FromReflectedField": {
                JniProcessor.expectSize(args, 1);
                String name = (String)args.get(0);
                ConfigurationType type = config.getOrCreateType(condition, declaringClassOrClazz);
                if (makeTypeJniAccessible) {
                    type.setJniAccessible();
                }
                type.addField(name, declaration, false);
                break;
            }
            case "ToReflectedMethod": {
                makeTypeJniAccessible = false;
            }
            case "FromReflectedMethod": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                String signature = (String)args.get(1);
                ConfigurationType type = config.getOrCreateType(condition, declaringClassOrClazz);
                if (makeTypeJniAccessible) {
                    type.setJniAccessible();
                }
                type.addMethod(name, signature, declaration);
                break;
            }
            case "NewObjectArray": {
                JniProcessor.expectSize(args, 0);
                if (!clazz.getAllQualifiedJavaNames().stream().noneMatch(c -> this.advisor.shouldIgnoreJniLookup(function, LazyValueUtils.lazyValue(c), null, null, callerClassLazyValue, entry))) break;
                config.getOrCreateType(condition, clazz);
            }
        }
    }

    private static ConfigurationType getOrCreateJniAccessibleType(TypeConfiguration config, UnresolvedConfigurationCondition condition, ConfigurationTypeDescriptor typeName) {
        ConfigurationType type = config.getOrCreateType(condition, typeName);
        type.setJniAccessible();
        return type;
    }
}

