/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import java.io.IOException;
import java.util.Objects;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;

public class SerializationConfigurationLambdaCapturingType
implements JsonPrintable,
Comparable<SerializationConfigurationLambdaCapturingType> {
    private final UnresolvedConfigurationCondition condition;
    private final String qualifiedJavaName;

    public SerializationConfigurationLambdaCapturingType(UnresolvedConfigurationCondition condition, String qualifiedJavaName) {
        assert (qualifiedJavaName.indexOf(47) == -1) : "Requires qualified Java name, not the internal representation";
        Objects.requireNonNull(condition);
        this.condition = condition;
        Objects.requireNonNull(qualifiedJavaName);
        this.qualifiedJavaName = qualifiedJavaName;
    }

    public UnresolvedConfigurationCondition getCondition() {
        return this.condition;
    }

    public String getQualifiedJavaName() {
        return this.qualifiedJavaName;
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        ConfigurationConditionPrintable.printConditionAttribute(this.condition, writer, false);
        writer.quote("name").append(":").quote(this.qualifiedJavaName);
        writer.unindent().newline().append('}');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfigurationLambdaCapturingType that = (SerializationConfigurationLambdaCapturingType)o;
        return this.condition.equals(that.condition) && this.qualifiedJavaName.equals(that.qualifiedJavaName);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.qualifiedJavaName);
    }

    @Override
    public int compareTo(SerializationConfigurationLambdaCapturingType other) {
        int compareName = this.qualifiedJavaName.compareTo(other.qualifiedJavaName);
        if (compareName != 0) {
            return compareName;
        }
        return this.condition.compareTo(other.condition);
    }
}

