/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConditionalConfigurationParser;
import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.util.TypeResult;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;

public final class ProxyConfigurationParser<C>
extends ConditionalConfigurationParser {
    private final ConfigurationConditionResolver<C> conditionResolver;
    private final BiConsumer<C, List<String>> proxyConfigConsumer;

    public ProxyConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, EnumSet<ConfigurationParserOption> parserOptions, BiConsumer<C, List<String>> proxyConfigConsumer) {
        super(parserOptions);
        this.proxyConfigConsumer = proxyConfigConsumer;
        this.conditionResolver = conditionResolver;
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        this.parseTopLevelArray(ProxyConfigurationParser.asList(json, "First-level of document must be an array of interface lists"));
    }

    private void parseTopLevelArray(List<Object> proxyConfiguration) {
        boolean foundInterfaceLists = false;
        boolean foundProxyConfigurationObjects = false;
        for (Object proxyConfigurationObject : proxyConfiguration) {
            if (proxyConfigurationObject instanceof List) {
                foundInterfaceLists = true;
                this.parseInterfaceList(this.conditionResolver.alwaysTrue(), ProxyConfigurationParser.asList(proxyConfigurationObject, "<shouldn't reach here>"));
            } else if (proxyConfigurationObject instanceof EconomicMap) {
                foundProxyConfigurationObjects = true;
                this.parseWithConditionalConfig(ProxyConfigurationParser.asMap(proxyConfigurationObject, "<shouldn't reach here>"));
            } else {
                throw new JsonParserException("Second-level must be composed of either interface lists or proxy configuration objects");
            }
            if (!foundInterfaceLists || !foundProxyConfigurationObjects) continue;
            throw new JsonParserException("Second-level can only be populated of either interface lists or proxy configuration objects, but these cannot be mixed");
        }
    }

    private void parseInterfaceList(C condition, List<?> data) {
        List interfaces = data.stream().map(ConfigurationParser::asString).collect(Collectors.toList());
        try {
            this.proxyConfigConsumer.accept(condition, interfaces);
        }
        catch (Exception e) {
            throw new JsonParserException(e.toString());
        }
    }

    private void parseWithConditionalConfig(EconomicMap<String, Object> proxyConfigObject) {
        this.checkAttributes(proxyConfigObject, "proxy descriptor object", Collections.singleton("interfaces"), Collections.singletonList("condition"));
        UnresolvedConfigurationCondition condition = this.parseCondition(proxyConfigObject, false);
        TypeResult<C> resolvedCondition = this.conditionResolver.resolveCondition(condition);
        if (resolvedCondition.isPresent()) {
            this.parseInterfaceList(resolvedCondition.get(), ProxyConfigurationParser.asList(proxyConfigObject.get((Object)"interfaces"), "The interfaces property must be an array of fully qualified interface names"));
        }
    }
}

