/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.ProxyConfigurationParser;
import com.oracle.svm.configure.SerializationConfigurationParser;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.TypeResult;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

final class LegacySerializationConfigurationParser<C>
extends SerializationConfigurationParser<C> {
    private static final String SERIALIZATION_TYPES_KEY = "types";
    private static final String LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY = "lambdaCapturingTypes";
    private static final String PROXY_SERIALIZATION_TYPES_KEY = "proxies";
    private final ProxyConfigurationParser<C> proxyConfigurationParser;
    private boolean customConstructorWarningTriggered = false;

    LegacySerializationConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, RuntimeSerializationSupport<C> serializationSupport, EnumSet<ConfigurationParserOption> parserOptions) {
        super(conditionResolver, serializationSupport, parserOptions);
        this.proxyConfigurationParser = new ProxyConfigurationParser<Object>(conditionResolver, parserOptions, (arg_0, arg_1) -> serializationSupport.registerProxyClass(arg_0, arg_1));
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        if (json instanceof List) {
            this.parseOldConfiguration(LegacySerializationConfigurationParser.asList(json, "First-level of document must be an array of serialization lists"));
        } else if (json instanceof EconomicMap) {
            this.parseNewConfiguration(LegacySerializationConfigurationParser.asMap(json, "First-level of document must be a map of serialization types"));
        } else {
            throw new JsonParserException("First-level of document must either be an array of serialization lists or a map of serialization types");
        }
    }

    private void parseOldConfiguration(List<Object> listOfSerializationConfigurationObjects) {
        this.parseSerializationTypes(LegacySerializationConfigurationParser.asList(listOfSerializationConfigurationObjects, "Second-level of document must be serialization descriptor objects"), false);
    }

    private void parseNewConfiguration(EconomicMap<String, Object> listOfSerializationConfigurationObjects) {
        if (!listOfSerializationConfigurationObjects.containsKey((Object)SERIALIZATION_TYPES_KEY) || !listOfSerializationConfigurationObjects.containsKey((Object)LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY)) {
            throw new JsonParserException("Second-level of document must be arrays of serialization descriptor objects");
        }
        this.parseSerializationTypes(LegacySerializationConfigurationParser.asList(listOfSerializationConfigurationObjects.get((Object)SERIALIZATION_TYPES_KEY), "The types property must be an array of serialization descriptor objects"), false);
        this.parseSerializationTypes(LegacySerializationConfigurationParser.asList(listOfSerializationConfigurationObjects.get((Object)LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY), "The lambdaCapturingTypes property must be an array of serialization descriptor objects"), true);
        if (listOfSerializationConfigurationObjects.containsKey((Object)PROXY_SERIALIZATION_TYPES_KEY)) {
            this.proxyConfigurationParser.parseAndRegister(listOfSerializationConfigurationObjects.get((Object)PROXY_SERIALIZATION_TYPES_KEY), null);
        }
    }

    @Override
    protected void parseSerializationDescriptorObject(EconomicMap<String, Object> data, boolean lambdaCapturingType) {
        if (lambdaCapturingType) {
            this.checkAttributes(data, "serialization descriptor object", Collections.singleton("name"), Collections.singleton("condition"));
        } else {
            this.checkAttributes(data, "serialization descriptor object", Collections.singleton("name"), Arrays.asList("customTargetConstructorClass", "condition"));
        }
        NamedConfigurationTypeDescriptor targetSerializationClass = NamedConfigurationTypeDescriptor.fromJSONName(LegacySerializationConfigurationParser.asString(data.get((Object)"name")));
        UnresolvedConfigurationCondition unresolvedCondition = this.parseCondition(data, false);
        TypeResult condition = this.conditionResolver.resolveCondition(unresolvedCondition);
        if (!condition.isPresent()) {
            return;
        }
        if (lambdaCapturingType) {
            String className = targetSerializationClass.name();
            this.serializationSupport.registerLambdaCapturingClass(condition.get(), className);
        } else {
            if (!this.customConstructorWarningTriggered && data.containsKey((Object)"customTargetConstructorClass")) {
                this.customConstructorWarningTriggered = true;
                LogUtils.warning((String)"\"customTargetConstructorClass\" is deprecated in serialization-config.json. All serializable classes can be instantiated through any superclass constructor without the use of the flag.");
            }
            this.serializationSupport.register(condition.get(), targetSerializationClass.name());
        }
    }
}

