/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shaded.org.capnproto;

import com.oracle.svm.shaded.org.capnproto.Allocator;
import com.oracle.svm.shaded.org.capnproto.AnyPointer;
import com.oracle.svm.shaded.org.capnproto.BuilderArena;
import com.oracle.svm.shaded.org.capnproto.DefaultAllocator;
import com.oracle.svm.shaded.org.capnproto.FromPointerBuilder;
import com.oracle.svm.shaded.org.capnproto.MessageReader;
import com.oracle.svm.shaded.org.capnproto.SegmentBuilder;
import com.oracle.svm.shaded.org.capnproto.SetPointerBuilder;
import java.nio.ByteBuffer;

public final class MessageBuilder {
    private final BuilderArena arena;

    public MessageBuilder() {
        this.arena = new BuilderArena(1024, BuilderArena.SUGGESTED_ALLOCATION_STRATEGY);
    }

    public MessageBuilder(int firstSegmentWords) {
        this.arena = new BuilderArena(firstSegmentWords, BuilderArena.SUGGESTED_ALLOCATION_STRATEGY);
    }

    public MessageBuilder(int firstSegmentWords, BuilderArena.AllocationStrategy allocationStrategy) {
        this.arena = new BuilderArena(firstSegmentWords, allocationStrategy);
    }

    public MessageBuilder(Allocator allocator) {
        this.arena = new BuilderArena(allocator);
    }

    public MessageBuilder(Allocator allocator, ByteBuffer firstSegment) {
        this.arena = new BuilderArena(allocator, firstSegment);
    }

    public MessageBuilder(ByteBuffer firstSegment) {
        this.arena = new BuilderArena(new DefaultAllocator(), firstSegment);
    }

    private MessageBuilder(MessageReader messageReader) {
        this.arena = new BuilderArena(messageReader.arena);
    }

    public static MessageBuilder unsafeConstructFromMessageReader(MessageReader messageReader) {
        return new MessageBuilder(messageReader);
    }

    private AnyPointer.Builder getRootInternal() {
        SegmentBuilder rootSegment;
        if (this.arena.segments.isEmpty()) {
            this.arena.allocate(1);
        }
        if ((rootSegment = this.arena.segments.get(0)).currentSize() == 0) {
            int location = rootSegment.allocate(1);
            if (location == -1) {
                throw new RuntimeException("could not allocate root pointer");
            }
            if (location != 0) {
                throw new RuntimeException("First allocated word of new segment was not at offset 0");
            }
            return new AnyPointer.Builder(rootSegment, location);
        }
        return new AnyPointer.Builder(rootSegment, 0);
    }

    public <T> T getRoot(FromPointerBuilder<T> factory) {
        return this.getRootInternal().getAs(factory);
    }

    public <T, U> void setRoot(SetPointerBuilder<T, U> factory, U reader) {
        this.getRootInternal().setAs(factory, reader);
    }

    public <T> T initRoot(FromPointerBuilder<T> factory) {
        return this.getRootInternal().initAs(factory);
    }

    public final ByteBuffer[] getSegmentsForOutput() {
        return this.arena.getSegmentsForOutput();
    }

    public final void clearFirstSegment() {
        this.arena.segments.get(0).clear();
    }
}

