/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.tracing.core;

import com.oracle.svm.jni.nativeapi.JNIMethodId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class Tracer {
    public static final String EXPLICIT_NULL = new String("null");
    public static final String UNKNOWN_VALUE = new String("\u0000");

    protected static Object handleSpecialValue(Object obj) {
        if (obj == EXPLICIT_NULL) {
            return null;
        }
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            Object[] newArray = null;
            for (int i = 0; i < array.length; ++i) {
                Object newValue = Tracer.handleSpecialValue(array[i]);
                if (newValue == array[i]) continue;
                if (newArray == null) {
                    newArray = Arrays.copyOf(array, array.length);
                }
                newArray[i] = newValue;
            }
            return newArray != null ? newArray : array;
        }
        return obj;
    }

    public void traceInitialization() {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("tracer", "meta");
        entry.put("event", "initialization");
        entry.put("version", "1");
        this.traceEntry(entry);
    }

    public void tracePhaseChange(String phase) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("tracer", "meta");
        entry.put("event", "phase_change");
        entry.put("phase", phase);
        this.traceEntry(entry);
    }

    public void traceCall(String tracer, String function, Object clazz, Object declaringClass, Object callerClass, Object result, JNIMethodId[] stackTrace, Object ... args) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("tracer", tracer);
        entry.put("function", function);
        if (clazz != null) {
            entry.put("class", Tracer.handleSpecialValue(clazz));
        }
        if (declaringClass != null) {
            entry.put("declaring_class", Tracer.handleSpecialValue(declaringClass));
        }
        if (callerClass != null) {
            entry.put("caller_class", Tracer.handleSpecialValue(callerClass));
        }
        if (result != null) {
            entry.put("result", Tracer.handleSpecialValue(result));
        }
        if (args != null) {
            entry.put("args", Tracer.handleSpecialValue(args));
        }
        if (stackTrace != null) {
            entry.put("stack_trace", stackTrace);
        }
        this.traceEntry(entry);
    }

    protected abstract void traceEntry(Map<String, Object> var1);
}

