/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import java.util.List;
import java.util.Map;

public class SerializationProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;
    private final SerializationConfiguration serializationConfiguration;

    public SerializationProcessor(AccessAdvisor advisor, SerializationConfiguration serializationConfiguration) {
        this.advisor = advisor;
        this.serializationConfiguration = serializationConfiguration;
    }

    public SerializationConfiguration getSerializationConfiguration() {
        return this.serializationConfiguration;
    }

    @Override
    void processEntry(Map<String, ?> entry) {
        boolean invalidResult = Boolean.FALSE.equals(entry.get("result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get("function");
        List args = (List)entry.get("args");
        if ("ObjectStreamClass.<init>".equals(function)) {
            SerializationProcessor.expectSize(args, 2);
            if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue((String)args.get(0)), LazyValueUtils.lazyValue(null))) {
                return;
            }
            this.serializationConfiguration.add((String)args.get(0), (String)args.get(1));
        }
    }
}

