/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationMemberKind;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SignatureUtil;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.compiler.phases.common.LazyValue;

class ReflectionProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;
    private final TypeConfiguration configuration;
    private final ProxyConfiguration proxyConfiguration;
    private final ResourceConfiguration resourceConfiguration;

    ReflectionProcessor(AccessAdvisor advisor, TypeConfiguration typeConfiguration, ProxyConfiguration proxyConfiguration, ResourceConfiguration resourceConfiguration) {
        this.advisor = advisor;
        this.configuration = typeConfiguration;
        this.proxyConfiguration = proxyConfiguration;
        this.resourceConfiguration = resourceConfiguration;
    }

    public TypeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    @Override
    public void processEntry(Map<String, ?> entry) {
        String clazz;
        boolean invalidResult = Boolean.FALSE.equals(entry.get("result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get("function");
        List args = (List)entry.get("args");
        switch (function) {
            case "getResource": 
            case "getResourceAsStream": 
            case "getSystemResource": 
            case "getSystemResourceAsStream": 
            case "getResources": 
            case "getSystemResources": {
                String literal = (String)ReflectionProcessor.singleElement(args);
                String regex = Pattern.quote(literal);
                this.resourceConfiguration.addResourcePattern(regex);
                return;
            }
        }
        String callerClass = (String)entry.get("caller_class");
        boolean isLoadClass = function.equals("loadClass");
        if (isLoadClass || function.equals("forName") || function.equals("findClass")) {
            String name = (String)ReflectionProcessor.singleElement(args);
            if (isLoadClass) {
                name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
            }
            if (!(this.advisor.shouldIgnore(LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(callerClass)) || isLoadClass && this.advisor.shouldIgnoreLoadClass(LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(callerClass)))) {
                this.configuration.getOrCreateType(name);
            }
            return;
        }
        if (function.equals("methodTypeDescriptor")) {
            List typeNames = (List)ReflectionProcessor.singleElement(args);
            for (String type : typeNames) {
                if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue(type), LazyValueUtils.lazyValue(callerClass))) continue;
                this.configuration.getOrCreateType(type);
            }
        }
        if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue(clazz = (String)entry.get("class")), LazyValueUtils.lazyValue(callerClass))) {
            return;
        }
        ConfigurationMemberKind memberKind = ConfigurationMemberKind.PUBLIC;
        String clazzOrDeclaringClass = entry.containsKey("declaring_class") ? (String)entry.get("declaring_class") : clazz;
        switch (function) {
            case "getDeclaredFields": {
                this.configuration.getOrCreateType(clazz).setAllDeclaredFields();
                break;
            }
            case "getFields": {
                this.configuration.getOrCreateType(clazz).setAllPublicFields();
                break;
            }
            case "getDeclaredMethods": {
                this.configuration.getOrCreateType(clazz).setAllDeclaredMethods();
                break;
            }
            case "asInterfaceInstance": 
            case "getMethods": {
                this.configuration.getOrCreateType(clazz).setAllPublicMethods();
                break;
            }
            case "getDeclaredConstructors": {
                this.configuration.getOrCreateType(clazz).setAllDeclaredConstructors();
                break;
            }
            case "getConstructors": {
                this.configuration.getOrCreateType(clazz).setAllPublicConstructors();
                break;
            }
            case "getDeclaredClasses": {
                this.configuration.getOrCreateType(clazz).setAllDeclaredClasses();
                break;
            }
            case "getClasses": {
                this.configuration.getOrCreateType(clazz).setAllPublicClasses();
                break;
            }
            case "objectFieldOffset": 
            case "findFieldHandle": 
            case "unreflectField": 
            case "getDeclaredField": {
                memberKind = "findFieldHandle".equals(function) ? ConfigurationMemberKind.PRESENT : ConfigurationMemberKind.DECLARED;
            }
            case "getField": {
                this.configuration.getOrCreateType(clazzOrDeclaringClass).addField((String)ReflectionProcessor.singleElement(args), memberKind, false);
                if (clazzOrDeclaringClass.equals(clazz)) break;
                this.configuration.getOrCreateType(clazz);
                break;
            }
            case "getDeclaredMethod": 
            case "findMethodHandle": {
                memberKind = "findMethodHandle".equals(function) ? ConfigurationMemberKind.PRESENT : ConfigurationMemberKind.DECLARED;
            }
            case "getMethod": {
                ReflectionProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                List parameterTypes = (List)args.get(1);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                this.configuration.getOrCreateType(clazzOrDeclaringClass).addMethod(name, SignatureUtil.toInternalSignature(parameterTypes), memberKind);
                if (clazzOrDeclaringClass.equals(clazz)) break;
                this.configuration.getOrCreateType(clazz);
                break;
            }
            case "getDeclaredConstructor": 
            case "findConstructorHandle": {
                memberKind = "findConstructorHandle".equals(function) ? ConfigurationMemberKind.PRESENT : ConfigurationMemberKind.DECLARED;
            }
            case "getConstructor": {
                List parameterTypes = (List)ReflectionProcessor.singleElement(args);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                String signature = SignatureUtil.toInternalSignature(parameterTypes);
                assert (clazz.equals(clazzOrDeclaringClass)) : "Constructor can only be accessed via declaring class";
                this.configuration.getOrCreateType(clazzOrDeclaringClass).addMethod("<init>", signature, memberKind);
                break;
            }
            case "getProxyClass": {
                ReflectionProcessor.expectSize(args, 2);
                this.addDynamicProxy((List)args.get(1), LazyValueUtils.lazyValue(callerClass));
                break;
            }
            case "newProxyInstance": {
                ReflectionProcessor.expectSize(args, 3);
                this.addDynamicProxy((List)args.get(1), LazyValueUtils.lazyValue(callerClass));
                break;
            }
            case "newMethodHandleProxyInstance": {
                ReflectionProcessor.expectSize(args, 1);
                this.addDynamicProxyUnchecked((List)args.get(0), Collections.singletonList("sun.invoke.WrapperInstance"), LazyValueUtils.lazyValue(callerClass));
                break;
            }
            case "getEnclosingConstructor": 
            case "getEnclosingMethod": {
                String result = (String)entry.get("result");
                this.addFullyQualifiedDeclaredMethod(result);
                break;
            }
            case "newInstance": {
                if (clazz.equals("java.lang.reflect.Array")) {
                    this.configuration.getOrCreateType((String)args.get(0));
                    break;
                }
                this.configuration.getOrCreateType(clazz).addMethod("<init>", "()V", ConfigurationMemberKind.DECLARED);
                break;
            }
            case "getBundleImplJDK8OrEarlier": {
                ReflectionProcessor.expectSize(args, 4);
                this.resourceConfiguration.addBundle((String)args.get(0));
                break;
            }
            case "getBundleImplJDK11OrLater": {
                ReflectionProcessor.expectSize(args, 5);
                this.resourceConfiguration.addBundle((String)args.get(2));
                break;
            }
            default: {
                System.err.println("Unsupported reflection method: " + function);
            }
        }
    }

    private void addFullyQualifiedDeclaredMethod(String descriptor) {
        int sigbegin = descriptor.indexOf(40);
        int classend = descriptor.lastIndexOf(46, sigbegin - 1);
        String qualifiedClass = descriptor.substring(0, classend);
        String methodName = descriptor.substring(classend + 1, sigbegin);
        String signature = descriptor.substring(sigbegin);
        this.configuration.getOrCreateType(qualifiedClass).addMethod(methodName, signature, ConfigurationMemberKind.DECLARED);
    }

    private void addDynamicProxy(List<?> interfaceList, LazyValue<String> callerClass) {
        List<String> interfaces = interfaceList;
        for (String iface : interfaces) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), callerClass)) continue;
            return;
        }
        this.proxyConfiguration.add(interfaces);
    }

    private void addDynamicProxyUnchecked(List<?> checkedInterfaceList, List<?> uncheckedInterfaceList, LazyValue<String> callerClass) {
        List<?> checkedInterfaces = checkedInterfaceList;
        for (String iface : checkedInterfaces) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), callerClass)) continue;
            return;
        }
        List<?> uncheckedInterfaces = uncheckedInterfaceList;
        ArrayList<String> interfaces = new ArrayList<String>();
        interfaces.addAll(checkedInterfaces);
        interfaces.addAll(uncheckedInterfaces);
        this.proxyConfiguration.add(interfaces);
    }
}

