/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractProcessor {
    AbstractProcessor() {
    }

    abstract void processEntry(Map<String, ?> var1);

    void setInLivePhase(boolean live) {
    }

    static void logWarning(String warning) {
        System.err.println("WARNING: " + warning);
    }

    static <T> T singleElement(List<?> list) {
        AbstractProcessor.expectSize(list, 1);
        return (T)list.get(0);
    }

    static void expectSize(Collection<?> collection, int size) {
        if (collection.size() != size) {
            throw new IllegalArgumentException("List must have exactly " + size + " element(s)");
        }
    }

    static byte[] asBinary(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return Base64.getDecoder().decode((String)obj);
    }
}

