/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.core.SubstrateUtil;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SerializationConfiguration
implements ConfigurationBase {
    private static final String KEY_SEPARATOR = "|";
    private final Set<String> serializations = ConcurrentHashMap.newKeySet();

    public void add(String serializationTargetClass, String customTargetConstructorClass) {
        this.serializations.add(serializationTargetClass + (customTargetConstructorClass != null ? KEY_SEPARATOR + customTargetConstructorClass : ""));
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('[').indent();
        String prefix = "";
        for (String entry : this.serializations) {
            writer.append(prefix);
            writer.newline().append('{').newline();
            String[] serializationKeyValues = SubstrateUtil.split((String)entry, (String)KEY_SEPARATOR, (int)2);
            String className = serializationKeyValues[0];
            writer.quote("name").append(":").quote(className);
            if (serializationKeyValues.length > 1) {
                writer.append(",").newline();
                writer.quote("customTargetConstructorClass").append(":").quote(serializationKeyValues[1]);
            }
            writer.newline().append('}');
            prefix = ",";
        }
        writer.unindent().newline();
        writer.append(']');
    }

    @Override
    public boolean isEmpty() {
        return this.serializations.isEmpty();
    }
}

