/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberKind;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import java.util.List;

public class ParserConfigurationAdapter
implements ReflectionConfigurationParserDelegate<ConfigurationType> {
    private final TypeConfiguration configuration;

    public ParserConfigurationAdapter(TypeConfiguration configuration) {
        this.configuration = configuration;
    }

    public TypeResult<ConfigurationType> resolveTypeResult(String typeName) {
        ConfigurationType type = this.configuration.get(typeName);
        ConfigurationType result = type != null ? type : new ConfigurationType(typeName);
        return TypeResult.forType((String)typeName, (Object)result);
    }

    public void registerType(ConfigurationType type) {
        this.configuration.add(type);
    }

    public void registerField(ConfigurationType type, String fieldName, boolean finalButWritable) {
        type.addField(fieldName, ConfigurationMemberKind.PRESENT, finalButWritable);
    }

    public boolean registerAllMethodsWithName(ConfigurationType type, String methodName) {
        type.addMethodsWithName(methodName, ConfigurationMemberKind.PRESENT);
        return true;
    }

    public boolean registerAllConstructors(ConfigurationType type) {
        type.addMethodsWithName("<init>", ConfigurationMemberKind.PRESENT);
        return true;
    }

    public void registerMethod(ConfigurationType type, String methodName, List<ConfigurationType> methodParameterTypes) {
        type.addMethod(methodName, ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberKind.PRESENT);
    }

    public void registerConstructor(ConfigurationType type, List<ConfigurationType> methodParameterTypes) {
        type.addMethod("<init>", ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberKind.PRESENT);
    }

    public void registerPublicClasses(ConfigurationType type) {
        type.setAllPublicClasses();
    }

    public void registerDeclaredClasses(ConfigurationType type) {
        type.setAllDeclaredClasses();
    }

    public void registerPublicFields(ConfigurationType type) {
        type.setAllPublicFields();
    }

    public void registerDeclaredFields(ConfigurationType type) {
        type.setAllDeclaredFields();
    }

    public void registerPublicMethods(ConfigurationType type) {
        type.setAllPublicMethods();
    }

    public void registerDeclaredMethods(ConfigurationType type) {
        type.setAllDeclaredMethods();
    }

    public void registerPublicConstructors(ConfigurationType type) {
        type.setAllPublicConstructors();
    }

    public void registerDeclaredConstructors(ConfigurationType type) {
        type.setAllDeclaredConstructors();
    }

    public String getTypeName(ConfigurationType type) {
        return type.getQualifiedJavaName();
    }

    public String getSimpleName(ConfigurationType type) {
        return this.getTypeName(type);
    }
}

