/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberKind;

final class FieldInfo {
    private static final FieldInfo[] FINAL_NOT_WRITABLE_CACHE;
    private final ConfigurationMemberKind kind;
    private final boolean finalButWritable;

    static FieldInfo get(ConfigurationMemberKind kind, boolean finalButWritable) {
        if (finalButWritable) {
            return new FieldInfo(kind, finalButWritable);
        }
        return FINAL_NOT_WRITABLE_CACHE[kind.ordinal()];
    }

    private FieldInfo(ConfigurationMemberKind kind, boolean finalButWritable) {
        this.kind = kind;
        this.finalButWritable = finalButWritable;
    }

    public ConfigurationMemberKind getKind() {
        return this.kind;
    }

    public boolean isFinalButWritable() {
        return this.finalButWritable;
    }

    public boolean equals(Object obj) {
        if (obj != this && obj instanceof FieldInfo) {
            FieldInfo other = (FieldInfo)obj;
            return this.kind.equals((Object)other.kind) && this.finalButWritable == other.finalButWritable;
        }
        return obj == this;
    }

    public int hashCode() {
        return Boolean.hashCode(this.finalButWritable) * 31 + this.kind.hashCode();
    }

    static {
        ConfigurationMemberKind[] values = ConfigurationMemberKind.values();
        FINAL_NOT_WRITABLE_CACHE = new FieldInfo[values.length];
        for (ConfigurationMemberKind value : values) {
            FieldInfo.FINAL_NOT_WRITABLE_CACHE[value.ordinal()] = new FieldInfo(value, false);
        }
    }
}

