/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ParserConfigurationAdapter;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.PredefinedClassesConfigurationParser;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public class ConfigurationSet {
    public static final Function<IOException, Exception> FAIL_ON_EXCEPTION = e -> e;
    private final Set<URI> jniConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> reflectConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> proxyConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> resourceConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> serializationConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> predefinedClassesConfigPaths = new LinkedHashSet<URI>();

    public void addDirectory(Path path) {
        this.jniConfigPaths.add(path.resolve(ConfigurationFile.JNI.getFileName()).toUri());
        this.reflectConfigPaths.add(path.resolve(ConfigurationFile.REFLECTION.getFileName()).toUri());
        this.proxyConfigPaths.add(path.resolve(ConfigurationFile.DYNAMIC_PROXY.getFileName()).toUri());
        this.resourceConfigPaths.add(path.resolve(ConfigurationFile.RESOURCES.getFileName()).toUri());
        this.serializationConfigPaths.add(path.resolve(ConfigurationFile.SERIALIZATION.getFileName()).toUri());
        this.predefinedClassesConfigPaths.add(path.resolve(ConfigurationFile.PREDEFINED_CLASSES_NAME.getFileName()).toUri());
    }

    public boolean isEmpty() {
        return this.jniConfigPaths.isEmpty() && this.reflectConfigPaths.isEmpty() && this.proxyConfigPaths.isEmpty() && this.resourceConfigPaths.isEmpty() && this.serializationConfigPaths.isEmpty() && this.predefinedClassesConfigPaths.isEmpty();
    }

    public Set<URI> getJniConfigPaths() {
        return this.jniConfigPaths;
    }

    public Set<URI> getReflectConfigPaths() {
        return this.reflectConfigPaths;
    }

    public Set<URI> getProxyConfigPaths() {
        return this.proxyConfigPaths;
    }

    public Set<URI> getResourceConfigPaths() {
        return this.resourceConfigPaths;
    }

    public Set<URI> getSerializationConfigPaths() {
        return this.serializationConfigPaths;
    }

    public Set<URI> getPredefinedClassesConfigPaths() {
        return this.predefinedClassesConfigPaths;
    }

    public TypeConfiguration loadJniConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        return ConfigurationSet.loadTypeConfig(this.jniConfigPaths, exceptionHandler);
    }

    public TypeConfiguration loadReflectConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        return ConfigurationSet.loadTypeConfig(this.reflectConfigPaths, exceptionHandler);
    }

    public ProxyConfiguration loadProxyConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        ConfigurationSet.loadConfig(this.proxyConfigPaths, (ConfigurationParser)new ProxyConfigurationParser(types -> proxyConfiguration.add(Arrays.asList(types))), exceptionHandler);
        return proxyConfiguration;
    }

    public PredefinedClassesConfiguration loadPredefinedClassesConfig(Path[] classDestinationDirs, Function<IOException, Exception> exceptionHandler) throws Exception {
        PredefinedClassesConfiguration predefinedClassesConfiguration = new PredefinedClassesConfiguration(classDestinationDirs);
        ConfigurationSet.loadConfig(this.predefinedClassesConfigPaths, (ConfigurationParser)new PredefinedClassesConfigurationParser(predefinedClassesConfiguration::add), exceptionHandler);
        return predefinedClassesConfiguration;
    }

    public ResourceConfiguration loadResourceConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration();
        ConfigurationSet.loadConfig(this.resourceConfigPaths, (ConfigurationParser)new ResourceConfigurationParser((ResourcesRegistry)new ResourceConfiguration.ParserAdapter(resourceConfiguration)), exceptionHandler);
        return resourceConfiguration;
    }

    public SerializationConfiguration loadSerializationConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        SerializationConfiguration serializationConfiguration = new SerializationConfiguration();
        ConfigurationSet.loadConfig(this.serializationConfigPaths, (ConfigurationParser)new SerializationConfigurationParser(serializationConfiguration::add), exceptionHandler);
        return serializationConfiguration;
    }

    private static TypeConfiguration loadTypeConfig(Collection<URI> uris, Function<IOException, Exception> exceptionHandler) throws Exception {
        TypeConfiguration configuration = new TypeConfiguration();
        ConfigurationSet.loadConfig(uris, (ConfigurationParser)new ReflectionConfigurationParser((ReflectionConfigurationParserDelegate)new ParserConfigurationAdapter(configuration)), exceptionHandler);
        return configuration;
    }

    private static void loadConfig(Collection<URI> configPaths, ConfigurationParser configurationParser, Function<IOException, Exception> exceptionHandler) throws Exception {
        for (URI uri : configPaths) {
            Path path = Paths.get(uri);
            try {
                configurationParser.parseAndRegister(path);
            }
            catch (IOException ioe) {
                Exception e = ioe;
                if (exceptionHandler != null) {
                    e = exceptionHandler.apply(ioe);
                }
                if (e == null) continue;
                throw e;
            }
        }
    }
}

