/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.NativeImageAgent;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.TraceWriter;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNINativeMethod;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIValue;
import com.oracle.svm.jvmtiagentbase.AgentIsolate;
import com.oracle.svm.jvmtiagentbase.ConstantPoolTool;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiCapabilities;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEvent;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventCallbacks;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventMode;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiFrameInfo;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiLocationFormat;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class BreakpointInterceptor {
    private static TraceWriter traceWriter;
    private static NativeImageAgent agent;
    private static Map<Long, Breakpoint> installedBreakpoints;
    private static Map<Long, Long> boundNativeMethods;
    private static Map<Long, NativeBreakpoint> nativeBreakpoints;
    private static boolean experimentalClassLoaderSupport;
    private static ConcurrentMap<MethodLocation, Boolean> observedExplicitLoadClassCallSites;
    private static final ReentrantLock nativeBreakpointsInitLock;
    private static final ThreadLocal<Boolean> recursive;
    private static final CEntryPointLiteral<ObjectFieldOffsetFunctionPointer> nativeObjectFieldOffsetLiteral;
    private static final NativeBreakpointSpecification NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC;
    private static final CEntryPointLiteral<CFunctionPointer> onBreakpointLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onNativeMethodBindLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onClassPrepareLiteral;
    private static final BreakpointSpecification[] BREAKPOINT_SPECIFICATIONS;
    private static final BreakpointSpecification CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION;
    private static final NativeBreakpointSpecification[] NATIVE_BREAKPOINT_SPECIFICATIONS;

    private static void traceBreakpoint(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, String function, Object result, Object ... args) {
        if (traceWriter != null) {
            traceWriter.traceCall("reflect", function, Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)clazz, null, (String)TraceWriter.UNKNOWN_VALUE), Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)declaringClass, null, (String)TraceWriter.UNKNOWN_VALUE), Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)callerClass, null, (String)TraceWriter.UNKNOWN_VALUE), result, args);
            VMError.guarantee((!Support.testException((JNIEnvironment)env) ? 1 : 0) != 0);
        }
    }

    private static boolean forName(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle name = Support.getObjectArgument((int)0);
        String className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name);
        boolean classLoaderValid = true;
        WordPointer classLoaderPtr = (WordPointer)StackValue.get(WordPointer.class);
        if (bp.method == ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassForName3) {
            classLoaderValid = Support.jvmtiFunctions().GetLocalObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 0, 2, (PointerBase)classLoaderPtr) == JvmtiError.JVMTI_ERROR_NONE;
        } else {
            classLoaderPtr.write((WordBase)JNIObjectHandles.nullHandle());
            if (callerClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                classLoaderValid = Support.jvmtiFunctions().GetClassLoader().invoke(Support.jvmtiEnv(), callerClass, (PointerBase)classLoaderPtr) == JvmtiError.JVMTI_ERROR_NONE;
            }
        }
        Object result = TraceWriter.UNKNOWN_VALUE;
        if (classLoaderValid) {
            int initialize = 0;
            JNIObjectHandle loadedClass = Support.callStaticObjectMethodLIL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassForName3, (JNIObjectHandle)name, (int)initialize, (JNIObjectHandle)((JNIObjectHandle)classLoaderPtr.read()));
            if (Support.clearException((JNIEnvironment)jni)) {
                loadedClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            result = loadedClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
        }
        BreakpointInterceptor.traceBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, className);
        return true;
    }

    private static boolean getFields(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetFields(jni, bp);
    }

    private static boolean getDeclaredFields(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetFields(jni, bp);
    }

    private static boolean handleGetFields(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, new Object[0]);
        return true;
    }

    private static boolean getMethods(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, bp);
    }

    private static boolean getDeclaredMethods(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, bp);
    }

    private static boolean getConstructors(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, bp);
    }

    private static boolean getDeclaredConstructors(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, bp);
    }

    private static boolean handleGetMethods(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, new Object[0]);
        return true;
    }

    private static boolean getClasses(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetClasses(jni, bp);
    }

    private static boolean getDeclaredClasses(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetClasses(jni, bp);
    }

    private static boolean handleGetClasses(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, new Object[0]);
        return true;
    }

    private static boolean getField(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetField(jni, bp, false);
    }

    private static boolean getDeclaredField(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetField(jni, bp, true);
    }

    private static boolean handleGetField(JNIEnvironment jni, Breakpoint bp, boolean declaredOnly) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle name = Support.getObjectArgument((int)1);
        JNIObjectHandle result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)name);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (!declaredOnly && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, self, declaring, callerClass, ((BreakpointSpecification)bp.specification).methodName, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        return true;
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    static long nativeObjectFieldOffset(JNIEnvironment jni, JNIObjectHandle self, JNIObjectHandle field) {
        VMError.guarantee((BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed != null && BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed.replacedFunction.isNonNull() ? 1 : 0) != 0, (String)"incompletely installed");
        ObjectFieldOffsetFunctionPointer original = (ObjectFieldOffsetFunctionPointer)BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed.replacedFunction;
        long result = original.invoke(jni, self, field);
        if (!Support.isInitialized()) {
            return result;
        }
        boolean validResult = !Support.clearException((JNIEnvironment)jni);
        JNIMethodId currentMethod = Support.getCallerMethod((int)0);
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (field.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            name = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetName);
            if (Support.clearException((JNIEnvironment)jni)) {
                name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        if (!BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, currentMethod, callerClass)) {
            return Long.MIN_VALUE;
        }
        if (!validResult) {
            return original.invoke(jni, self, field);
        }
        return result;
    }

    private static boolean objectFieldOffset(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle field = Support.getObjectArgument((int)1);
        Support.callLongMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)field);
        boolean validResult = !Support.clearException((JNIEnvironment)jni);
        JNIObjectHandle name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (field.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            name = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetName);
            if (Support.clearException((JNIEnvironment)jni)) {
                name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        return BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, bp.method, callerClass);
    }

    private static boolean verifyAndTraceObjectFieldOffset(JNIEnvironment jni, boolean validResult, JNIObjectHandle name, JNIObjectHandle declaring, JNIMethodId currentMethod, JNIObjectHandle callerClass) {
        JNIObjectHandle clazz = Support.getMethodDeclaringClass((JNIMethodId)currentMethod);
        BreakpointInterceptor.traceBreakpoint(jni, clazz, declaring, callerClass, "objectFieldOffset", validResult, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        return true;
    }

    private static boolean objectFieldOffsetByName(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle declaring = Support.getObjectArgument((int)1);
        JNIObjectHandle name = Support.getObjectArgument((int)2);
        Support.callLongMethodLL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)declaring, (JNIObjectHandle)name);
        boolean validResult = !Support.clearException((JNIEnvironment)jni);
        return BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, bp.method, callerClass);
    }

    private static boolean getConstructor(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle paramTypesHandle = Support.getObjectArgument((int)1);
        JNIObjectHandle result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)paramTypesHandle);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, JNIObjectHandles.nullHandle().notEqual((ComparableWord)result), paramTypes);
        return true;
    }

    private static boolean getMethod(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethod(jni, bp, false);
    }

    private static boolean getDeclaredMethod(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethod(jni, bp, true);
    }

    private static boolean handleGetMethod(JNIEnvironment jni, Breakpoint bp, boolean declaredOnly) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle nameHandle = Support.getObjectArgument((int)1);
        JNIObjectHandle paramTypesHandle = Support.getObjectArgument((int)2);
        JNIObjectHandle result = Support.callObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)nameHandle, (JNIObjectHandle)paramTypesHandle);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (!declaredOnly && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)nameHandle);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        BreakpointInterceptor.traceBreakpoint(jni, self, declaring, callerClass, ((BreakpointSpecification)bp.specification).methodName, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name, paramTypes);
        return true;
    }

    private static boolean getEnclosingMethod(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        String result = TraceWriter.EXPLICIT_NULL;
        JNIObjectHandle enclosing = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method);
        if (!Support.clearException((JNIEnvironment)jni) && enclosing.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            result = TraceWriter.UNKNOWN_VALUE;
            JNIMethodId enclosingID = Support.jniFunctions().getFromReflectedMethod().invoke(jni, enclosing);
            if (!Support.clearException((JNIEnvironment)jni) && enclosingID.isNonNull()) {
                String holderName;
                WordPointer holderPtr = (WordPointer)StackValue.get(WordPointer.class);
                if (Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), enclosingID, holderPtr) == JvmtiError.JVMTI_ERROR_NONE && (holderName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)((JNIObjectHandle)holderPtr.read()))) != null) {
                    CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                    CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                    if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), enclosingID, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
                        String name = Support.fromCString((CCharPointer)namePtr.read());
                        String signature = Support.fromCString((CCharPointer)signaturePtr.read());
                        result = holderName + "." + name + signature;
                        Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
                        Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
                    }
                }
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, enclosing.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) ? result : Boolean.valueOf(false), new Object[0]);
        return true;
    }

    private static boolean newInstance(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIMethodId result = (JNIMethodId)WordFactory.nullPointer();
        String name = "<init>";
        String signature = "()V";
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        if (self.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            try (CTypeConversion.CCharPointerHolder ctorName = Support.toCString((String)name);
                 CTypeConversion.CCharPointerHolder ctorSignature = Support.toCString((String)signature);){
                result = Support.jniFunctions().getGetMethodID().invoke(jni, self, ctorName.get(), ctorSignature.get());
            }
            if (Support.clearException((JNIEnvironment)jni)) {
                result = (JNIMethodId)WordFactory.nullPointer();
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), new Object[0]);
        return true;
    }

    private static boolean newArrayInstance(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle componentClass = Support.getObjectArgument((int)0);
        CIntPointer lengthPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        boolean lengthValid = Support.jvmtiFunctions().GetLocalInt().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 0, 1, (PointerBase)lengthPtr) == JvmtiError.JVMTI_ERROR_NONE;
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(componentClass);
        args.addressOf(1).setInt(lengthPtr.read());
        return BreakpointInterceptor.newArrayInstance0(jni, bp, args, lengthValid);
    }

    private static boolean newArrayInstanceMulti(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle componentClass = Support.getObjectArgument((int)0);
        JNIObjectHandle dimensionsArray = Support.getObjectArgument((int)1);
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(componentClass);
        args.addressOf(1).setObject(dimensionsArray);
        return BreakpointInterceptor.newArrayInstance0(jni, bp, args, dimensionsArray.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
    }

    private static boolean newArrayInstance0(JNIEnvironment jni, Breakpoint bp, JNIValue args, boolean argsValid) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle resultClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle componentClass = args.addressOf(0).getObject();
        if (componentClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && argsValid) {
            result = Support.jniFunctions().getCallStaticObjectMethodA().invoke(jni, bp.clazz, bp.method, args);
            if (Support.clearException((JNIEnvironment)jni)) {
                result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            } else {
                resultClass = Support.jniFunctions().getGetObjectClass().invoke(jni, result);
                if (Support.clearException((JNIEnvironment)jni)) {
                    resultClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                }
            }
        }
        String resultClassName = Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)resultClass, null, (String)TraceWriter.UNKNOWN_VALUE);
        BreakpointInterceptor.traceBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), resultClassName);
        return true;
    }

    private static boolean getResource(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetResources(jni, bp, false);
    }

    private static boolean getResources(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetResources(jni, bp, true);
    }

    private static boolean handleGetResources(JNIEnvironment jni, Breakpoint bp, boolean returnsEnumeration) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle name = Support.getObjectArgument((int)1);
        JNIObjectHandle returnValue = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)name);
        boolean result = returnValue.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
        if (Support.clearException((JNIEnvironment)jni)) {
            result = false;
        }
        if (result && returnsEnumeration) {
            result = BreakpointInterceptor.hasEnumerationElements(jni, returnValue);
        }
        JNIObjectHandle selfClazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (self.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            selfClazz = Support.jniFunctions().getGetObjectClass().invoke(jni, self);
            if (Support.clearException((JNIEnvironment)jni)) {
                selfClazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, selfClazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        return true;
    }

    private static boolean hasEnumerationElements(JNIEnvironment jni, JNIObjectHandle obj) {
        boolean hasElements = Support.callBooleanMethod((JNIEnvironment)jni, (JNIObjectHandle)obj, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilEnumerationHasMoreElements);
        if (Support.clearException((JNIEnvironment)jni)) {
            hasElements = false;
        }
        return hasElements;
    }

    private static boolean getSystemResource(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetSystemResources(jni, bp, false);
    }

    private static boolean getSystemResources(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetSystemResources(jni, bp, true);
    }

    private static boolean handleGetSystemResources(JNIEnvironment jni, Breakpoint bp, boolean returnsEnumeration) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle name = Support.getObjectArgument((int)0);
        JNIObjectHandle returnValue = Support.callStaticObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)name);
        boolean result = returnValue.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
        if (Support.clearException((JNIEnvironment)jni)) {
            result = false;
        }
        if (result && returnsEnumeration) {
            result = BreakpointInterceptor.hasEnumerationElements(jni, returnValue);
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        return true;
    }

    private static boolean newProxyInstance(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle classLoader = Support.getObjectArgument((int)0);
        JNIObjectHandle ifaces = Support.getObjectArgument((int)1);
        Object ifaceNames = BreakpointInterceptor.getClassArrayNames(jni, ifaces);
        JNIObjectHandle invokeHandler = Support.getObjectArgument((int)2);
        boolean result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)Support.callStaticObjectMethodLLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)classLoader, (JNIObjectHandle)ifaces, (JNIObjectHandle)invokeHandler));
        if (Support.clearException((JNIEnvironment)jni)) {
            result = false;
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, TraceWriter.UNKNOWN_VALUE, ifaceNames, TraceWriter.UNKNOWN_VALUE);
        return true;
    }

    private static boolean getProxyClass(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle classLoader = Support.getObjectArgument((int)0);
        JNIObjectHandle ifaces = Support.getObjectArgument((int)1);
        Object ifaceNames = BreakpointInterceptor.getClassArrayNames(jni, ifaces);
        boolean result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)Support.callStaticObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)classLoader, (JNIObjectHandle)ifaces));
        if (Support.clearException((JNIEnvironment)jni)) {
            result = false;
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, TraceWriter.UNKNOWN_VALUE, ifaceNames);
        return true;
    }

    private static Object getClassArrayNames(JNIEnvironment jni, JNIObjectHandle classArray) {
        String[] classNames = TraceWriter.EXPLICIT_NULL;
        if (classArray.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            classNames = TraceWriter.UNKNOWN_VALUE;
            int length = Support.jniFunctions().getGetArrayLength().invoke(jni, classArray);
            if (!Support.clearException((JNIEnvironment)jni) && length >= 0) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    JNIObjectHandle clazz = Support.jniFunctions().getGetObjectArrayElement().invoke(jni, classArray, i);
                    if (!Support.clearException((JNIEnvironment)jni)) {
                        list.add(Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)clazz, (String)TraceWriter.EXPLICIT_NULL, (String)TraceWriter.UNKNOWN_VALUE));
                        continue;
                    }
                    list.add(TraceWriter.UNKNOWN_VALUE);
                }
                classNames = list.toArray(new String[0]);
            }
        }
        return classNames;
    }

    private static boolean getBundleImplJDK8OrEarlier(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getCallerClass((int)2);
        JNIObjectHandle baseName = Support.getObjectArgument((int)0);
        JNIObjectHandle locale = Support.getObjectArgument((int)1);
        JNIObjectHandle loader = Support.getObjectArgument((int)2);
        JNIObjectHandle control = Support.getObjectArgument((int)3);
        JNIObjectHandle result = Support.callStaticObjectMethodLLLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)baseName, (JNIObjectHandle)locale, (JNIObjectHandle)loader, (JNIObjectHandle)control);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "getBundleImplJDK8OrEarlier", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)baseName), TraceWriter.UNKNOWN_VALUE, TraceWriter.UNKNOWN_VALUE, TraceWriter.UNKNOWN_VALUE);
        return true;
    }

    private static boolean getBundleImplJDK11OrLater(JNIEnvironment jni, Breakpoint bp) {
        JNIMethodId intermediateMethod = Support.getCallerMethod((int)2);
        JNIMethodId callerMethod = intermediateMethod.equal((ComparableWord)((NativeImageAgentJNIHandleSet)agent.handles()).tryGetJavaUtilResourceBundleGetBundleImplSLCC(jni)) ? Support.getCallerMethod((int)4) : Support.getCallerMethod((int)3);
        JNIObjectHandle callerClass = Support.getMethodDeclaringClass((JNIMethodId)callerMethod);
        JNIObjectHandle callerModule = Support.getObjectArgument((int)0);
        JNIObjectHandle module = Support.getObjectArgument((int)1);
        JNIObjectHandle baseName = Support.getObjectArgument((int)2);
        JNIObjectHandle locale = Support.getObjectArgument((int)3);
        JNIObjectHandle control = Support.getObjectArgument((int)4);
        JNIObjectHandle result = Support.callStaticObjectMethodLLLLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)callerModule, (JNIObjectHandle)module, (JNIObjectHandle)baseName, (JNIObjectHandle)locale, (JNIObjectHandle)control);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "getBundleImplJDK11OrLater", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), TraceWriter.UNKNOWN_VALUE, TraceWriter.UNKNOWN_VALUE, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)baseName), TraceWriter.UNKNOWN_VALUE, TraceWriter.UNKNOWN_VALUE);
        return true;
    }

    private static boolean loadClass(JNIEnvironment jni, Breakpoint bp) {
        assert (experimentalClassLoaderSupport);
        JNIObjectHandle callerClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JvmtiFrameInfo frameInfo = (JvmtiFrameInfo)StackValue.get(JvmtiFrameInfo.class);
        CIntPointer frameCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        if (Support.jvmtiFunctions().GetStackTrace().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 1, 1, (WordPointer)frameInfo, frameCountPtr) == JvmtiError.JVMTI_ERROR_NONE && frameCountPtr.read() == 1) {
            callerClass = Support.getMethodDeclaringClass((JNIMethodId)frameInfo.getMethod());
            if (callerClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && Support.jniFunctions().getIsAssignableFrom().invoke(jni, callerClass, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassLoader)) {
                return true;
            }
            MethodLocation location = new MethodLocation(frameInfo.getMethod(), NumUtil.safeToInt((long)frameInfo.getLocation()));
            if (!observedExplicitLoadClassCallSites.containsKey(location)) {
                if (!BreakpointInterceptor.isLoadClassInvocation(callerClass, location.method, location.bci, ((BreakpointSpecification)bp.specification).methodName, ((BreakpointSpecification)bp.specification).signature)) {
                    return true;
                }
                observedExplicitLoadClassCallSites.put(location, Boolean.TRUE);
            }
        }
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle name = Support.getObjectArgument((int)1);
        String className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name);
        JNIObjectHandle clazz = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)name);
        if (Support.clearException((JNIEnvironment)jni)) {
            clazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        BreakpointInterceptor.traceBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), className);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLoadClassInvocation(JNIObjectHandle clazz, JNIMethodId method, int bci, String methodName, String signature) {
        int cpi;
        CIntPointer lengthPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CCharPointerPointer bytecodesPtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetBytecodes().invoke(Support.jvmtiEnv(), method, lengthPtr, bytecodesPtr) != JvmtiError.JVMTI_ERROR_NONE) {
            return false;
        }
        CCharPointer bytecodes = bytecodesPtr.read();
        try {
            if (bci + 2 >= lengthPtr.read()) {
                boolean bl = false;
                return bl;
            }
            int instruction = Byte.toUnsignedInt(bytecodes.read(bci));
            if (instruction != 182) {
                boolean bl = false;
                return bl;
            }
            int indexbyte1 = Byte.toUnsignedInt(bytecodes.read(bci + 1));
            int indexbyte2 = Byte.toUnsignedInt(bytecodes.read(bci + 2));
            cpi = indexbyte1 << 8 | indexbyte2;
        }
        finally {
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)bytecodes);
        }
        CIntPointer constantPoolCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer constantPoolByteCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CCharPointerPointer constantPoolBytesPtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetConstantPool().invoke(Support.jvmtiEnv(), clazz, constantPoolCountPtr, constantPoolByteCountPtr, constantPoolBytesPtr) != JvmtiError.JVMTI_ERROR_NONE) {
            return false;
        }
        CCharPointer constantPool = constantPoolBytesPtr.read();
        try {
            ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)constantPool, (int)constantPoolByteCountPtr.read());
            buffer.order(ByteOrder.BIG_ENDIAN);
            try {
                ConstantPoolTool.MethodReference ref = new ConstantPoolTool(buffer).readMethodReference(cpi);
                boolean bl = methodName.contentEquals(ref.name) && signature.contentEquals(ref.descriptor);
                return bl;
            }
            catch (ConstantPoolTool.ConstantPoolException e) {
                boolean bl = false;
                Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)constantPool);
                return bl;
            }
        }
        finally {
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)constantPool);
        }
    }

    private static boolean findMethodHandle(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle lookup = Support.getObjectArgument((int)0);
        JNIObjectHandle declaringClass = Support.getObjectArgument((int)1);
        JNIObjectHandle methodName = Support.getObjectArgument((int)2);
        JNIObjectHandle methodType = Support.getObjectArgument((int)3);
        JNIObjectHandle result = Support.callObjectMethodLLL((JNIEnvironment)jni, (JNIObjectHandle)lookup, (JNIMethodId)bp.method, (JNIObjectHandle)declaringClass, (JNIObjectHandle)methodName, (JNIObjectHandle)methodType);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalAccessException);
        return BreakpointInterceptor.methodMethodHandle(jni, declaringClass, callerClass, methodName, BreakpointInterceptor.getParamTypes(jni, methodType), result);
    }

    private static boolean findSpecialHandle(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle lookup = Support.getObjectArgument((int)0);
        JNIObjectHandle declaringClass = Support.getObjectArgument((int)1);
        JNIObjectHandle methodName = Support.getObjectArgument((int)2);
        JNIObjectHandle methodType = Support.getObjectArgument((int)3);
        JNIObjectHandle specialCaller = Support.getObjectArgument((int)4);
        JNIObjectHandle result = Support.callObjectMethodLLLL((JNIEnvironment)jni, (JNIObjectHandle)lookup, (JNIMethodId)bp.method, (JNIObjectHandle)declaringClass, (JNIObjectHandle)methodName, (JNIObjectHandle)methodType, (JNIObjectHandle)specialCaller);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalAccessException);
        return BreakpointInterceptor.methodMethodHandle(jni, declaringClass, callerClass, methodName, BreakpointInterceptor.getParamTypes(jni, methodType), result);
    }

    private static boolean bindHandle(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle lookup = Support.getObjectArgument((int)0);
        JNIObjectHandle receiver = Support.getObjectArgument((int)1);
        JNIObjectHandle methodName = Support.getObjectArgument((int)2);
        JNIObjectHandle methodType = Support.getObjectArgument((int)3);
        JNIObjectHandle result = Support.callObjectMethodLLL((JNIEnvironment)jni, (JNIObjectHandle)lookup, (JNIMethodId)bp.method, (JNIObjectHandle)receiver, (JNIObjectHandle)methodName, (JNIObjectHandle)methodType);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalAccessException);
        JNIObjectHandle declaringClass = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)receiver, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangObjectGetClass);
        if (Support.clearException((JNIEnvironment)jni)) {
            declaringClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return BreakpointInterceptor.methodMethodHandle(jni, declaringClass, callerClass, methodName, BreakpointInterceptor.getParamTypes(jni, methodType), result);
    }

    private static boolean methodMethodHandle(JNIEnvironment jni, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, JNIObjectHandle nameHandle, JNIObjectHandle paramTypesHandle, JNIObjectHandle result) {
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)nameHandle);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        BreakpointInterceptor.traceBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findMethodHandle", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name, paramTypes);
        return true;
    }

    private static boolean findConstructorHandle(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle lookup = Support.getObjectArgument((int)0);
        JNIObjectHandle declaringClass = Support.getObjectArgument((int)1);
        JNIObjectHandle methodType = Support.getObjectArgument((int)2);
        JNIObjectHandle result = Support.callObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)lookup, (JNIMethodId)bp.method, (JNIObjectHandle)declaringClass, (JNIObjectHandle)methodType);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalAccessException);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, BreakpointInterceptor.getParamTypes(jni, methodType));
        BreakpointInterceptor.traceBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findConstructorHandle", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), paramTypes);
        return true;
    }

    private static JNIObjectHandle getParamTypes(JNIEnvironment jni, JNIObjectHandle methodType) {
        JNIObjectHandle paramTypesHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)methodType, (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeMethodTypeParameterArray(jni));
        if (Support.clearException((JNIEnvironment)jni)) {
            paramTypesHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return paramTypesHandle;
    }

    private static boolean findFieldHandle(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle lookup = Support.getObjectArgument((int)0);
        JNIObjectHandle declaringClass = Support.getObjectArgument((int)1);
        JNIObjectHandle fieldName = Support.getObjectArgument((int)2);
        JNIObjectHandle fieldType = Support.getObjectArgument((int)3);
        JNIObjectHandle result = Support.callObjectMethodLLL((JNIEnvironment)jni, (JNIObjectHandle)lookup, (JNIMethodId)bp.method, (JNIObjectHandle)declaringClass, (JNIObjectHandle)fieldName, (JNIObjectHandle)fieldType);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalAccessException);
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)fieldName);
        BreakpointInterceptor.traceBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findFieldHandle", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name);
        return true;
    }

    private static boolean findClass(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle lookup = Support.getObjectArgument((int)0);
        JNIObjectHandle className = Support.getObjectArgument((int)1);
        JNIObjectHandle result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)lookup, (JNIMethodId)bp.method, (JNIObjectHandle)className);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalAccessException);
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)className);
        BreakpointInterceptor.traceBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findClass", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name);
        return true;
    }

    private static boolean unreflectField(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle lookup = Support.getObjectArgument((int)0);
        JNIObjectHandle field = Support.getObjectArgument((int)1);
        JNIObjectHandle result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)lookup, (JNIMethodId)bp.method, (JNIObjectHandle)field);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalAccessException);
        JNIObjectHandle declaringClass = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
        if (Support.clearException((JNIEnvironment)jni)) {
            declaringClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle fieldNameHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetName);
        if (Support.clearException((JNIEnvironment)jni)) {
            fieldNameHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        String fieldName = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)fieldNameHandle);
        BreakpointInterceptor.traceBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "unreflectField", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), fieldName);
        return true;
    }

    private static boolean asInterfaceInstance(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle intfc = Support.getObjectArgument((int)0);
        JNIObjectHandle methodHandle = Support.getObjectArgument((int)1);
        JNIObjectHandle result = Support.callStaticObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)intfc, (JNIObjectHandle)methodHandle);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangInvokeWrongMethodTypeException, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalArgumentException);
        JNIObjectHandle intfcNameHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)intfc, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetName);
        if (Support.clearException((JNIEnvironment)jni)) {
            intfcNameHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        String intfcName = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)intfcNameHandle);
        BreakpointInterceptor.traceBreakpoint(jni, intfc, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "asInterfaceInstance", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), new Object[0]);
        String[] intfcNames = new String[]{intfcName};
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "newMethodHandleProxyInstance", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), new Object[]{intfcNames});
        return true;
    }

    private static boolean constantBootstrapGetStaticFinal(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle lookup = Support.getObjectArgument((int)0);
        JNIObjectHandle fieldName = Support.getObjectArgument((int)1);
        JNIObjectHandle type = Support.getObjectArgument((int)2);
        JNIObjectHandle declaringClass = Support.getObjectArgument((int)3);
        JNIObjectHandle result = Support.callStaticObjectMethodLLLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)lookup, (JNIObjectHandle)fieldName, (JNIObjectHandle)type, (JNIObjectHandle)declaringClass);
        result = BreakpointInterceptor.shouldIncludeMethod(jni, result, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangIllegalAccessException);
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)fieldName);
        BreakpointInterceptor.traceBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findFieldHandle", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name);
        return true;
    }

    private static boolean methodTypeFromDescriptor(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle descriptor = Support.getObjectArgument((int)0);
        JNIObjectHandle classLoader = Support.getObjectArgument((int)1);
        JNIObjectHandle result = Support.callStaticObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)descriptor, (JNIObjectHandle)classLoader);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        ArrayList<String> types = new ArrayList<String>();
        if (result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Object ptypeNames;
            String rtypeName;
            JNIObjectHandle rtype = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeMethodTypeReturnType(jni));
            if (Support.clearException((JNIEnvironment)jni)) {
                rtype = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            if ((rtypeName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)rtype)) != null) {
                types.add(rtypeName);
            }
            JNIObjectHandle ptypes = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeMethodTypeParameterArray(jni));
            if (Support.clearException((JNIEnvironment)jni)) {
                ptypes = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            if ((ptypeNames = BreakpointInterceptor.getClassArrayNames(jni, ptypes)) instanceof String[]) {
                types.addAll(Arrays.asList((String[])ptypeNames));
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "methodTypeDescriptor", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), types);
        return true;
    }

    private static JNIObjectHandle shouldIncludeMethod(JNIEnvironment jni, JNIObjectHandle result, JNIObjectHandle ... acceptedExceptions) {
        JNIObjectHandle exception = Support.handleException((JNIEnvironment)jni);
        if (exception.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            for (JNIObjectHandle acceptedException : acceptedExceptions) {
                if (!Support.jniFunctions().getIsInstanceOf().invoke(jni, exception, acceptedException)) continue;
                return JNIObjectHandles.createLocal((Object)Boolean.TRUE);
            }
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return result;
    }

    private static boolean objectStreamClassConstructor(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle serializeTargetClass = Support.getObjectArgument((int)1);
        String serializeTargetClassName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)serializeTargetClass);
        JNIObjectHandle objectStreamClassInstance = Support.newObjectL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)serializeTargetClass);
        boolean validObjectStreamClassInstance = JNIObjectHandles.nullHandle().notEqual((ComparableWord)objectStreamClassInstance);
        if (Support.clearException((JNIEnvironment)jni)) {
            validObjectStreamClassInstance = false;
        }
        if (serializeTargetClassName.contains("$$Lambda$")) {
            return true;
        }
        ArrayList<String> transitiveSerializeTargets = new ArrayList<String>();
        transitiveSerializeTargets.add(serializeTargetClassName);
        JNIMethodId getClassDataLayout0MId = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIoObjectStreamClassGetClassDataLayout0(jni, bp.clazz);
        JNIObjectHandle dataLayoutArray = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)objectStreamClassInstance, (JNIMethodId)getClassDataLayout0MId);
        if (!Support.clearException((JNIEnvironment)jni) && JNIObjectHandles.nullHandle().notEqual((ComparableWord)dataLayoutArray)) {
            int length = Support.jniFunctions().getGetArrayLength().invoke(jni, dataLayoutArray);
            if (!Support.clearException((JNIEnvironment)jni) && length > 1) {
                JNIFieldId hasDataFId = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIOObjectStreamClassClassDataSlotHasData(jni);
                JNIFieldId descFId = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIOObjectStreamClassClassDataSlotDesc(jni);
                JNIMethodId javaIoObjectStreamClassForClassMId = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIoObjectStreamClassForClass(jni, bp.clazz);
                for (int i = 0; i < length; ++i) {
                    JNIObjectHandle classDataSlot = Support.jniFunctions().getGetObjectArrayElement().invoke(jni, dataLayoutArray, i);
                    boolean hasData = Support.jniFunctions().getGetBooleanField().invoke(jni, classDataSlot, hasDataFId);
                    if (!hasData) continue;
                    JNIObjectHandle oscInstanceInSlot = Support.jniFunctions().getGetObjectField().invoke(jni, classDataSlot, descFId);
                    if (Support.jniFunctions().getIsSameObject().invoke(jni, oscInstanceInSlot, objectStreamClassInstance)) continue;
                    JNIObjectHandle oscClazz = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)oscInstanceInSlot, (JNIMethodId)javaIoObjectStreamClassForClassMId);
                    String oscClassName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)oscClazz);
                    transitiveSerializeTargets.add(oscClassName);
                }
            }
        }
        for (String className : transitiveSerializeTargets) {
            if (traceWriter == null) continue;
            traceWriter.traceCall("serialization", "ObjectStreamClass.<init>", null, null, null, validObjectStreamClassInstance, className, null);
            VMError.guarantee((!Support.testException((JNIEnvironment)jni) ? 1 : 0) != 0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onBreakpoint(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, long location) {
        if (recursive.get().booleanValue()) {
            return;
        }
        recursive.set(true);
        try {
            Breakpoint bp = installedBreakpoints.get(method.rawValue());
            if (((BreakpointSpecification)bp.specification).handler.dispatch(jni, bp)) {
                VMError.guarantee((!Support.testException((JNIEnvironment)jni) ? 1 : 0) != 0);
            }
        }
        catch (Throwable t) {
            VMError.shouldNotReachHere((Throwable)t);
        }
        finally {
            recursive.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onNativeMethodBind(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, CodePointer address, WordPointer newAddressPtr) {
        if (recursive.get().booleanValue()) {
            return;
        }
        nativeBreakpointsInitLock.lock();
        try {
            if (nativeBreakpoints != null) {
                NativeBreakpoint bp = nativeBreakpoints.get(method.rawValue());
                if (bp != null) {
                    BreakpointInterceptor.bindNativeBreakpoint(jni, bp, address, newAddressPtr);
                }
            } else {
                boundNativeMethods.put(method.rawValue(), address.rawValue());
            }
        }
        finally {
            nativeBreakpointsInitLock.unlock();
        }
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onClassPrepare(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIObjectHandle clazz) {
        assert (experimentalClassLoaderSupport);
        BreakpointInterceptor.installBreakpointIfClassLoader(jni, clazz, installedBreakpoints);
    }

    private static void installBreakpointIfClassLoader(JNIEnvironment jni, JNIObjectHandle clazz, Map<Long, Breakpoint> breakpoints) {
        String className;
        if (Support.jniFunctions().getIsAssignableFrom().invoke(jni, clazz, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassLoader) && (className = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)clazz)) != null) {
            BreakpointSpecification proto = CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION;
            JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, proto.methodName, proto.signature, true);
            if (method.isNonNull() && Support.jvmtiFunctions().SetBreakpoint().invoke(Support.jvmtiEnv(), method, 0L) == JvmtiError.JVMTI_ERROR_NONE) {
                BreakpointSpecification spec = new BreakpointSpecification(className, proto.methodName, proto.signature, proto.handler, proto.optional);
                JNIObjectHandle gclazz = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, clazz);
                breakpoints.put(method.rawValue(), new Breakpoint(spec, gclazz, method));
            }
        }
    }

    public static void onLoad(JvmtiEnv jvmti, JvmtiEventCallbacks callbacks, TraceWriter writer, NativeImageAgent nativeImageTracingAgent, boolean exptlClassLoaderSupport) {
        traceWriter = writer;
        agent = nativeImageTracingAgent;
        experimentalClassLoaderSupport = exptlClassLoaderSupport;
        JvmtiCapabilities capabilities = (JvmtiCapabilities)UnmanagedMemory.calloc((int)SizeOf.get(JvmtiCapabilities.class));
        Support.check((JvmtiError)jvmti.getFunctions().GetCapabilities().invoke(jvmti, capabilities));
        capabilities.setCanGenerateBreakpointEvents(1);
        capabilities.setCanAccessLocalVariables(1);
        capabilities.setCanGenerateNativeMethodBindEvents(1);
        if (exptlClassLoaderSupport) {
            capabilities.setCanGetBytecodes(1);
            capabilities.setCanGetConstantPool(1);
            CIntPointer formatPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            VMError.guarantee((jvmti.getFunctions().GetJLocationFormat().invoke(jvmti, formatPtr) == JvmtiError.JVMTI_ERROR_NONE && formatPtr.read() == JvmtiLocationFormat.JVMTI_JLOCATION_JVMBCI.getCValue() ? 1 : 0) != 0, (String)"Expecting BCI locations");
        }
        Support.check((JvmtiError)jvmti.getFunctions().AddCapabilities().invoke(jvmti, capabilities));
        UnmanagedMemory.free((PointerBase)capabilities);
        callbacks.setBreakpoint(onBreakpointLiteral.getFunctionPointer());
        callbacks.setNativeMethodBind(onNativeMethodBindLiteral.getFunctionPointer());
        if (exptlClassLoaderSupport) {
            callbacks.setClassPrepare(onClassPrepareLiteral.getFunctionPointer());
        }
        boundNativeMethods = new HashMap<Long, Long>();
        Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_NATIVE_METHOD_BIND, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVMInit(JvmtiEnv jvmti, JNIEnvironment jni) {
        JNIObjectHandle clazz;
        ConcurrentHashMap<Long, Breakpoint> breakpoints;
        if (experimentalClassLoaderSupport) {
            breakpoints = new ConcurrentHashMap(BREAKPOINT_SPECIFICATIONS.length);
            observedExplicitLoadClassCallSites = new ConcurrentHashMap<MethodLocation, Boolean>();
            CIntPointer classCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            WordPointer classesPtr = (WordPointer)StackValue.get(WordPointer.class);
            Support.check((JvmtiError)Support.jvmtiFunctions().GetLoadedClasses().invoke(jvmti, classCountPtr, classesPtr));
            WordPointer classesArray = (WordPointer)classesPtr.read();
            for (int i = 0; i < classCountPtr.read(); ++i) {
                JNIObjectHandle clazz2 = (JNIObjectHandle)classesArray.read(i);
                BreakpointInterceptor.installBreakpointIfClassLoader(jni, clazz2, breakpoints);
            }
            Support.check((JvmtiError)Support.jvmtiFunctions().Deallocate().invoke(jvmti, (PointerBase)classesArray));
        } else {
            breakpoints = new HashMap(BREAKPOINT_SPECIFICATIONS.length);
        }
        JNIObjectHandle lastClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String lastClassName = null;
        for (BreakpointSpecification breakpointSpecification : BREAKPOINT_SPECIFICATIONS) {
            Breakpoint bp;
            clazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            if (lastClassName != null && lastClassName.equals(breakpointSpecification.className)) {
                clazz = lastClass;
            }
            if ((bp = BreakpointInterceptor.installBreakpoint(jni, breakpointSpecification, breakpoints, clazz)) == null) continue;
            lastClass = bp.clazz;
            lastClassName = breakpointSpecification.className;
        }
        installedBreakpoints = breakpoints;
        nativeBreakpointsInitLock.lock();
        try {
            nativeBreakpoints = new HashMap<Long, NativeBreakpoint>(NATIVE_BREAKPOINT_SPECIFICATIONS.length);
            for (AbstractBreakpointSpecification abstractBreakpointSpecification : NATIVE_BREAKPOINT_SPECIFICATIONS) {
                if (lastClassName != null && lastClassName.equals(((NativeBreakpointSpecification)abstractBreakpointSpecification).className)) {
                    clazz = lastClass;
                } else {
                    lastClass = clazz = BreakpointInterceptor.resolveBreakpointClass(jni, ((NativeBreakpointSpecification)abstractBreakpointSpecification).className, ((NativeBreakpointSpecification)abstractBreakpointSpecification).optional);
                    lastClassName = ((NativeBreakpointSpecification)abstractBreakpointSpecification).className;
                }
                JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, ((NativeBreakpointSpecification)abstractBreakpointSpecification).methodName, ((NativeBreakpointSpecification)abstractBreakpointSpecification).signature, ((NativeBreakpointSpecification)abstractBreakpointSpecification).optional);
                if (!method.isNonNull()) continue;
                NativeBreakpoint bp = new NativeBreakpoint((NativeBreakpointSpecification)abstractBreakpointSpecification, clazz, method);
                nativeBreakpoints.put(method.rawValue(), bp);
                Long original = boundNativeMethods.get(method.rawValue());
                if (original == null) continue;
                BreakpointInterceptor.bindNativeBreakpoint(jni, bp, (CodePointer)WordFactory.pointer((long)original), (WordPointer)WordFactory.nullPointer());
            }
            boundNativeMethods = null;
        }
        finally {
            nativeBreakpointsInitLock.unlock();
        }
        Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_BREAKPOINT, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        if (experimentalClassLoaderSupport) {
            Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_CLASS_PREPARE, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        }
    }

    private static Breakpoint installBreakpoint(JNIEnvironment jni, BreakpointSpecification br, Map<Long, Breakpoint> map, JNIObjectHandle knownClass) {
        JNIObjectHandle clazz = knownClass;
        if (clazz.equal((ComparableWord)JNIObjectHandles.nullHandle()) && (clazz = BreakpointInterceptor.resolveBreakpointClass(jni, br.className, br.optional)).equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            VMError.guarantee((boolean)br.optional);
            return null;
        }
        JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, br.methodName, br.signature, br.optional);
        JvmtiError result = Support.jvmtiFunctions().SetBreakpoint().invoke(Support.jvmtiEnv(), method, 0L);
        if (result != JvmtiError.JVMTI_ERROR_NONE) {
            VMError.guarantee((boolean)br.optional, (String)"Setting breakpoint failed");
            return null;
        }
        Breakpoint bp = new Breakpoint(br, clazz, method);
        VMError.guarantee((map.put(method.rawValue(), bp) == null ? 1 : 0) != 0, (String)("Duplicate breakpoint: " + bp));
        return bp;
    }

    private static JNIObjectHandle resolveBreakpointClass(JNIEnvironment jni, String className, boolean optional) {
        JNIObjectHandle clazz;
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)className);){
            clazz = Support.jniFunctions().getFindClass().invoke(jni, cname.get());
            if (optional && (Support.clearException((JNIEnvironment)jni) || clazz.equal((ComparableWord)JNIObjectHandles.nullHandle()))) {
                JNIObjectHandle jNIObjectHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                return jNIObjectHandle;
            }
            Support.checkNoException((JNIEnvironment)jni);
        }
        clazz = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, clazz);
        Support.checkNoException((JNIEnvironment)jni);
        return clazz;
    }

    private static JNIMethodId resolveBreakpointMethod(JNIEnvironment jni, JNIObjectHandle clazz, String methodName, String signature, boolean optional) {
        JNIMethodId method;
        VMError.guarantee((boolean)clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)methodName);
             CTypeConversion.CCharPointerHolder csignature = Support.toCString((String)signature);){
            method = Support.jniFunctions().getGetMethodID().invoke(jni, clazz, cname.get(), csignature.get());
            if (method.isNull()) {
                Support.clearException((JNIEnvironment)jni);
                method = Support.jniFunctions().getGetStaticMethodID().invoke(jni, clazz, cname.get(), csignature.get());
            }
        }
        if (optional && (Support.clearException((JNIEnvironment)jni) || method.isNull())) {
            return (JNIMethodId)WordFactory.nullPointer();
        }
        VMError.guarantee((!Support.testException((JNIEnvironment)jni) && method.isNonNull() ? 1 : 0) != 0);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindNativeBreakpoint(JNIEnvironment jni, NativeBreakpoint bp, CodePointer originalAddress, WordPointer newAddressPtr) {
        assert (!recursive.get().booleanValue());
        bp.replacedFunction = originalAddress;
        CFunctionPointer breakpointMethod = ((NativeBreakpointSpecification)bp.specification).handlerLiteral.getFunctionPointer();
        if (newAddressPtr.isNonNull()) {
            newAddressPtr.write((WordBase)breakpointMethod);
        } else {
            recursive.set(true);
            try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)((NativeBreakpointSpecification)bp.specification).methodName);
                 CTypeConversion.CCharPointerHolder csignature = Support.toCString((String)((NativeBreakpointSpecification)bp.specification).signature);){
                JNINativeMethod nativeMethod = (JNINativeMethod)StackValue.get(JNINativeMethod.class);
                nativeMethod.setName(cname.get());
                nativeMethod.setSignature(csignature.get());
                nativeMethod.setFnPtr(breakpointMethod);
                Support.checkJni((int)jni.getFunctions().getRegisterNatives().invoke(jni, bp.clazz, nativeMethod, 1));
            }
            finally {
                recursive.set(false);
            }
        }
    }

    public static void onUnload() {
        installedBreakpoints = null;
        nativeBreakpoints = null;
        observedExplicitLoadClassCallSites = null;
        traceWriter = null;
    }

    private static BreakpointSpecification brk(String className, String methodName, String signature, BreakpointHandler handler) {
        return new BreakpointSpecification(className, methodName, signature, handler, false);
    }

    private static BreakpointSpecification optionalBrk(String className, String methodName, String signature, BreakpointHandler handler) {
        return new BreakpointSpecification(className, methodName, signature, handler, true);
    }

    private BreakpointInterceptor() {
    }

    static {
        experimentalClassLoaderSupport = false;
        nativeBreakpointsInitLock = new ReentrantLock();
        recursive = ThreadLocal.withInitial(() -> Boolean.FALSE);
        nativeObjectFieldOffsetLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"nativeObjectFieldOffset", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class});
        NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC = new NativeBreakpointSpecification("sun/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", nativeObjectFieldOffsetLiteral);
        onBreakpointLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onBreakpoint", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, Long.TYPE});
        onNativeMethodBindLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onNativeMethodBind", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, CodePointer.class, WordPointer.class});
        onClassPrepareLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onClassPrepare", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class});
        BREAKPOINT_SPECIFICATIONS = new BreakpointSpecification[]{BreakpointInterceptor.brk("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::forName), BreakpointInterceptor.brk("java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", BreakpointInterceptor::forName), BreakpointInterceptor.brk("java/lang/Class", "getFields", "()[Ljava/lang/reflect/Field;", BreakpointInterceptor::getFields), BreakpointInterceptor.brk("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;", BreakpointInterceptor::getMethods), BreakpointInterceptor.brk("java/lang/Class", "getConstructors", "()[Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructors), BreakpointInterceptor.brk("java/lang/Class", "getClasses", "()[Ljava/lang/Class;", BreakpointInterceptor::getClasses), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredFields", "()[Ljava/lang/reflect/Field;", BreakpointInterceptor::getDeclaredFields), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredMethods", "()[Ljava/lang/reflect/Method;", BreakpointInterceptor::getDeclaredMethods), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getDeclaredConstructors), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredClasses", "()[Ljava/lang/Class;", BreakpointInterceptor::getDeclaredClasses), BreakpointInterceptor.brk("java/lang/Class", "getField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", BreakpointInterceptor::getField), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", BreakpointInterceptor::getDeclaredField), BreakpointInterceptor.brk("java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", BreakpointInterceptor::getMethod), BreakpointInterceptor.brk("java/lang/Class", "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructor), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", BreakpointInterceptor::getDeclaredMethod), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructor), BreakpointInterceptor.brk("java/lang/Class", "getEnclosingMethod", "()Ljava/lang/reflect/Method;", BreakpointInterceptor::getEnclosingMethod), BreakpointInterceptor.brk("java/lang/Class", "getEnclosingConstructor", "()Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getEnclosingMethod), BreakpointInterceptor.brk("java/lang/Class", "newInstance", "()Ljava/lang/Object;", BreakpointInterceptor::newInstance), BreakpointInterceptor.brk("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;", BreakpointInterceptor::newArrayInstance), BreakpointInterceptor.brk("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;[I)Ljava/lang/Object;", BreakpointInterceptor::newArrayInstanceMulti), BreakpointInterceptor.brk("java/lang/ClassLoader", "getResource", "(Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::getResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", BreakpointInterceptor::getResources), BreakpointInterceptor.brk("java/lang/ClassLoader", "getSystemResource", "(Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::getSystemResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getSystemResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", BreakpointInterceptor::getSystemResources), BreakpointInterceptor.brk("java/lang/reflect/Proxy", "getProxyClass", "(Ljava/lang/ClassLoader;[Ljava/lang/Class;)Ljava/lang/Class;", BreakpointInterceptor::getProxyClass), BreakpointInterceptor.brk("java/lang/reflect/Proxy", "newProxyInstance", "(Ljava/lang/ClassLoader;[Ljava/lang/Class;Ljava/lang/reflect/InvocationHandler;)Ljava/lang/Object;", BreakpointInterceptor::newProxyInstance), BreakpointInterceptor.brk("java/io/ObjectStreamClass", "<init>", "(Ljava/lang/Class;)V", BreakpointInterceptor::objectStreamClassConstructor), BreakpointInterceptor.optionalBrk("java/util/ResourceBundle", "getBundleImpl", "(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/ClassLoader;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", BreakpointInterceptor::getBundleImplJDK8OrEarlier), BreakpointInterceptor.optionalBrk("java/util/ResourceBundle", "getBundleImpl", "(Ljava/lang/Module;Ljava/lang/Module;Ljava/lang/String;Ljava/util/Locale;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", BreakpointInterceptor::getBundleImplJDK11OrLater), BreakpointInterceptor.optionalBrk("sun/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", BreakpointInterceptor::objectFieldOffset), BreakpointInterceptor.optionalBrk("jdk/internal/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", BreakpointInterceptor::objectFieldOffset), BreakpointInterceptor.optionalBrk("jdk/internal/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/Class;Ljava/lang/String;)J", BreakpointInterceptor::objectFieldOffsetByName), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findStatic", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findMethodHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findVirtual", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findMethodHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findConstructor", "(Ljava/lang/Class;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findConstructorHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findSpecial", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findSpecialHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "bind", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::bindHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findGetter", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findSetter", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findStaticGetter", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findStaticSetter", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findVarHandle", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findStaticVarHandle", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findClass", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::findClass), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "unreflectGetter", "(Ljava/lang/reflect/Field;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::unreflectField), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "unreflectSetter", "(Ljava/lang/reflect/Field;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::unreflectField), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandleProxies", "asInterfaceInstance", "(Ljava/lang/Class;Ljava/lang/invoke/MethodHandle;)Ljava/lang/Object;", BreakpointInterceptor::asInterfaceInstance), BreakpointInterceptor.optionalBrk("java/lang/invoke/ConstantBootstraps", "getStaticFinal", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/Object;", BreakpointInterceptor::constantBootstrapGetStaticFinal), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodType", "fromMethodDescriptorString", "(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/lang/invoke/MethodType;", BreakpointInterceptor::methodTypeFromDescriptor)};
        CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION = BreakpointInterceptor.optionalBrk("java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::loadClass);
        NATIVE_BREAKPOINT_SPECIFICATIONS = new NativeBreakpointSpecification[]{NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC};
    }

    private static final class MethodLocation {
        final JNIMethodId method;
        final int bci;

        MethodLocation(JNIMethodId method, int bci) {
            this.method = method;
            this.bci = bci;
        }

        public boolean equals(Object obj) {
            if (obj != this && obj instanceof MethodLocation) {
                MethodLocation other = (MethodLocation)obj;
                return this.method.equal((ComparableWord)other.method) && this.bci == other.bci;
            }
            return obj == this;
        }

        public int hashCode() {
            return 31 * Long.hashCode(this.method.rawValue()) + this.bci;
        }
    }

    private static final class NativeBreakpoint
    extends AbstractBreakpoint<NativeBreakpointSpecification> {
        CodePointer replacedFunction;

        NativeBreakpoint(NativeBreakpointSpecification specification, JNIObjectHandle clazz, JNIMethodId method) {
            super(specification, clazz, method);
            assert (specification.installed == null) : "must be installed exactly once";
            specification.installed = this;
        }
    }

    private static final class Breakpoint
    extends AbstractBreakpoint<BreakpointSpecification> {
        Breakpoint(BreakpointSpecification specification, JNIObjectHandle clazz, JNIMethodId method) {
            super(specification, clazz, method);
        }
    }

    private static abstract class AbstractBreakpoint<T extends AbstractBreakpointSpecification> {
        final T specification;
        final JNIObjectHandle clazz;
        final JNIMethodId method;

        AbstractBreakpoint(T specification, JNIObjectHandle clazz, JNIMethodId method) {
            this.specification = specification;
            this.clazz = clazz;
            this.method = method;
        }

        public String toString() {
            return ((AbstractBreakpointSpecification)this.specification).toString();
        }
    }

    private static class NativeBreakpointSpecification
    extends AbstractBreakpointSpecification {
        final CEntryPointLiteral<?> handlerLiteral;
        NativeBreakpoint installed;

        NativeBreakpointSpecification(String className, String methodName, String signature, CEntryPointLiteral<?> handlerLiteral) {
            super(className, methodName, signature, true);
            this.handlerLiteral = handlerLiteral;
        }
    }

    private static class BreakpointSpecification
    extends AbstractBreakpointSpecification {
        final BreakpointHandler handler;

        BreakpointSpecification(String className, String methodName, String signature, BreakpointHandler handler, boolean optional) {
            super(className, methodName, signature, optional);
            this.handler = handler;
        }
    }

    private static abstract class AbstractBreakpointSpecification {
        final String className;
        final String methodName;
        final String signature;
        final boolean optional;

        AbstractBreakpointSpecification(String className, String methodName, String signature, boolean optional) {
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.optional = optional;
        }

        public String toString() {
            return this.className + ":" + this.methodName + this.signature + (this.optional ? " (optional)" : "");
        }
    }

    private static interface BreakpointHandler {
        public boolean dispatch(JNIEnvironment var1, Breakpoint var2);
    }

    private static interface ObjectFieldOffsetFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public long invoke(JNIEnvironment var1, JNIObjectHandle var2, JNIObjectHandle var3);
    }
}

