/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaUtil;

public class SignatureUtil {
    public static String[] toParameterTypes(String signature) {
        ArrayList<String> list = new ArrayList<String>();
        int position = 1;
        int arrayDimensions = 0;
        while (signature.charAt(position) != ')') {
            String type = null;
            if (signature.charAt(position) == '[') {
                ++arrayDimensions;
            } else if (signature.charAt(position) == 'L') {
                int end = signature.indexOf(59, position + 1);
                type = MetaUtil.internalNameToJava((String)signature.substring(position, end + 1), (boolean)true, (boolean)false);
                position = end;
            } else {
                type = JavaKind.fromPrimitiveOrVoidTypeChar((char)signature.charAt(position)).toString();
            }
            ++position;
            if (type == null) continue;
            String s = type;
            while (arrayDimensions > 0) {
                s = s + "[]";
                --arrayDimensions;
            }
            list.add(s);
        }
        if (arrayDimensions > 0) {
            throw new IllegalArgumentException("Invalid array in signature: " + signature);
        }
        return list.toArray(new String[0]);
    }

    public static String toInternalSignature(List<?> parameterTypes) {
        StringBuilder sb = new StringBuilder("(");
        for (Object type : parameterTypes) {
            sb.append(MetaUtil.toInternalName((String)type.toString()));
        }
        return sb.append(')').toString();
    }
}

