/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SerializationConfiguration
implements JsonPrintable {
    private final ConcurrentHashMap<String, Set<String>> serializations = new ConcurrentHashMap();

    public void addAll(String serializationTargetClass, Collection<String> checksums) {
        this.serializations.computeIfAbsent(serializationTargetClass, key -> new LinkedHashSet()).addAll(checksums);
    }

    public void add(String serializationTargetClass, String checksum) {
        if (checksum == null) {
            this.addAll(serializationTargetClass, Collections.emptySet());
        } else {
            this.addAll(serializationTargetClass, Collections.singleton(checksum));
        }
    }

    public boolean contains(String serializationTargetClass, String checksum) {
        Set<String> checksums = this.serializations.get(serializationTargetClass);
        return checksums != null && checksums.contains(checksum);
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('[').indent();
        String prefix = "";
        for (Map.Entry<String, Set<String>> entry : this.serializations.entrySet()) {
            writer.append(prefix);
            writer.newline().append('{').newline();
            String className = entry.getKey();
            writer.quote("name").append(":").quote(className);
            Set<String> checksums = entry.getValue();
            if (!checksums.isEmpty()) {
                writer.append(",").newline();
                writer.quote("checksum").append(':');
                if (checksums.size() == 1) {
                    writer.quote(checksums.iterator().next());
                } else {
                    writer.append(checksums.stream().map(JsonWriter::quoteString).collect(Collectors.joining(", ", "[", "]")));
                }
            }
            writer.newline().append('}');
            prefix = ",";
        }
        writer.unindent().newline();
        writer.append(']').newline();
    }
}

