/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberKind;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.FieldInfo;
import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonPrinter;
import com.oracle.svm.configure.json.JsonWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ConfigurationType
implements JsonPrintable {
    private final String qualifiedJavaName;
    private Map<String, FieldInfo> fields;
    private Map<ConfigurationMethod, ConfigurationMemberKind> methods;
    private boolean allDeclaredClasses;
    private boolean allPublicClasses;
    private boolean allDeclaredFields;
    private boolean allPublicFields;
    private boolean allDeclaredMethods;
    private boolean allPublicMethods;
    private boolean allDeclaredConstructors;
    private boolean allPublicConstructors;

    public ConfigurationType(String qualifiedJavaName) {
        assert (qualifiedJavaName.indexOf(47) == -1) : "Requires qualified Java name, not internal representation";
        assert (!qualifiedJavaName.startsWith("[")) : "Requires Java source array syntax, for example java.lang.String[]";
        this.qualifiedJavaName = qualifiedJavaName;
    }

    public String getQualifiedJavaName() {
        return this.qualifiedJavaName;
    }

    public void addField(String name, ConfigurationMemberKind memberKind, boolean finalButWritable, boolean allowUnsafeAccess) {
        if (!finalButWritable && !allowUnsafeAccess && (memberKind.includes(ConfigurationMemberKind.DECLARED) && this.haveAllDeclaredFields() || memberKind.includes(ConfigurationMemberKind.PUBLIC) && this.haveAllPublicFields())) {
            this.fields = ConfigurationType.maybeRemove(this.fields, map -> {
                FieldInfo cfr_ignored_0 = (FieldInfo)map.remove(name);
            });
            return;
        }
        if (this.fields == null) {
            this.fields = new HashMap<String, FieldInfo>();
        }
        this.fields.compute(name, (k, v) -> v != null ? FieldInfo.get(v.getKind().intersect(memberKind), v.isFinalButWritable() || finalButWritable, v.isUnsafeAccessible() || allowUnsafeAccess) : FieldInfo.get(memberKind, finalButWritable, allowUnsafeAccess));
    }

    public void addMethodsWithName(String name, ConfigurationMemberKind memberKind) {
        this.addMethod(name, null, memberKind);
    }

    public void addMethod(String name, String internalSignature, ConfigurationMemberKind memberKind) {
        boolean matchesAllSignatures;
        boolean bl = matchesAllSignatures = internalSignature == null;
        if (ConfigurationMethod.isConstructorName(name) ? this.haveAllDeclaredConstructors() || memberKind.includes(ConfigurationMemberKind.PUBLIC) && this.haveAllPublicConstructors() : memberKind.includes(ConfigurationMemberKind.DECLARED) && this.haveAllDeclaredMethods() || memberKind.includes(ConfigurationMemberKind.PUBLIC) && this.haveAllPublicMethods()) {
            if (!matchesAllSignatures) {
                this.methods = ConfigurationType.maybeRemove(this.methods, map -> {
                    ConfigurationMemberKind cfr_ignored_0 = (ConfigurationMemberKind)((Object)((Object)map.remove(new ConfigurationMethod(name, internalSignature))));
                });
            }
            return;
        }
        if (this.methods == null) {
            this.methods = new HashMap<ConfigurationMethod, ConfigurationMemberKind>();
        }
        ConfigurationMethod method = new ConfigurationMethod(name, internalSignature);
        if (matchesAllSignatures) {
            this.methods.compute(method, (k, v) -> memberKind.union((ConfigurationMemberKind)((Object)v)));
            this.methods = ConfigurationType.maybeRemove(this.methods, map -> map.entrySet().removeIf(entry -> name.equals(((ConfigurationMethod)entry.getKey()).getName()) && memberKind.includes((ConfigurationMemberKind)((Object)((Object)((Object)entry.getValue())))) && !method.equals(entry.getKey())));
        } else {
            this.methods.compute(method, (k, v) -> memberKind.intersect((ConfigurationMemberKind)((Object)v)));
        }
        assert (this.methods.containsKey(method));
    }

    public boolean haveAllDeclaredClasses() {
        return this.allDeclaredClasses;
    }

    public boolean haveAllPublicClasses() {
        return this.allPublicClasses;
    }

    public void setAllDeclaredClasses() {
        this.allDeclaredClasses = true;
    }

    public void setAllPublicClasses() {
        this.allPublicClasses = true;
    }

    public boolean haveAllDeclaredFields() {
        return this.allDeclaredFields;
    }

    public boolean haveAllPublicFields() {
        return this.allPublicFields;
    }

    public void setAllDeclaredFields() {
        this.allDeclaredFields = true;
        this.removeFields(ConfigurationMemberKind.DECLARED);
    }

    public void setAllPublicFields() {
        this.allPublicFields = true;
        this.removeFields(ConfigurationMemberKind.PUBLIC);
    }

    public boolean haveAllDeclaredMethods() {
        return this.allDeclaredMethods;
    }

    public boolean haveAllPublicMethods() {
        return this.allPublicMethods;
    }

    public void setAllDeclaredMethods() {
        this.allDeclaredMethods = true;
        this.removeMethods(ConfigurationMemberKind.DECLARED, false);
    }

    public void setAllPublicMethods() {
        this.allPublicMethods = true;
        this.removeMethods(ConfigurationMemberKind.PUBLIC, false);
    }

    public boolean haveAllDeclaredConstructors() {
        return this.allDeclaredConstructors;
    }

    public boolean haveAllPublicConstructors() {
        return this.allPublicConstructors;
    }

    public void setAllDeclaredConstructors() {
        this.allDeclaredConstructors = true;
        this.removeMethods(ConfigurationMemberKind.DECLARED, true);
    }

    public void setAllPublicConstructors() {
        this.allPublicConstructors = true;
        this.removeMethods(ConfigurationMemberKind.PUBLIC, true);
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        writer.quote("name").append(':').quote(this.qualifiedJavaName);
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.haveAllDeclaredFields(), "allDeclaredFields");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.haveAllPublicFields(), "allPublicFields");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.haveAllDeclaredMethods(), "allDeclaredMethods");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.haveAllPublicMethods(), "allPublicMethods");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.haveAllDeclaredConstructors(), "allDeclaredConstructors");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.haveAllPublicConstructors(), "allPublicConstructors");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.haveAllDeclaredClasses(), "allDeclaredClasses");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.haveAllPublicClasses(), "allPublicClasses");
        if (this.fields != null) {
            writer.append(',').newline().quote("fields").append(':');
            JsonPrinter.printCollection(writer, this.fields.entrySet(), Map.Entry.comparingByKey(), ConfigurationType::printField);
        }
        if (this.methods != null) {
            writer.append(',').newline().quote("methods").append(':');
            JsonPrinter.printCollection(writer, this.methods.keySet(), Comparator.comparing(ConfigurationMethod::getName).thenComparing(Comparator.nullsFirst(Comparator.comparing(ConfigurationMethod::getInternalSignature))), JsonPrintable::printJson);
        }
        writer.unindent().newline();
        writer.append('}');
    }

    private static void printField(Map.Entry<String, FieldInfo> entry, JsonWriter w) throws IOException {
        w.append('{').quote("name").append(':').quote(entry.getKey());
        if (entry.getValue().isFinalButWritable()) {
            w.append(", ").quote("allowWrite").append(':').append("true");
        }
        if (entry.getValue().isUnsafeAccessible()) {
            w.append(", ").quote("allowUnsafeAccess").append(':').append("true");
        }
        w.append('}');
    }

    private static void optionallyPrintJsonBoolean(JsonWriter writer, boolean predicate, String attribute) throws IOException {
        if (predicate) {
            writer.append(',').newline().quote(attribute).append(":true");
        }
    }

    private void removeFields(ConfigurationMemberKind memberKind) {
        this.fields = ConfigurationType.maybeRemove(this.fields, map -> map.values().removeIf(v -> !v.isUnsafeAccessible() && memberKind.includes(v.getKind())));
    }

    private void removeMethods(ConfigurationMemberKind memberKind, boolean constructors) {
        this.methods = ConfigurationType.maybeRemove(this.methods, map -> map.entrySet().removeIf(entry -> ((ConfigurationMethod)entry.getKey()).isConstructor() == constructors && memberKind.includes((ConfigurationMemberKind)((Object)((Object)((Object)entry.getValue()))))));
    }

    private static <T, S> Map<T, S> maybeRemove(Map<T, S> fromMap, Consumer<Map<T, S>> action) {
        Map<T, S> map = fromMap;
        if (map != null) {
            action.accept(map);
            if (map.isEmpty()) {
                map = null;
            }
        }
        return map;
    }
}

