/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.TraceWriter;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;

class TraceFileWriter
extends TraceWriter {
    private final Object lock = new Object();
    private final BufferedWriter writer;
    private boolean open = true;
    private int written = 0;

    TraceFileWriter(Path path) throws IOException {
        this.writer = Files.newBufferedWriter(path, new OpenOption[0]);
        JsonWriter json = new JsonWriter(this.writer);
        json.append('[').newline();
        this.traceInitialization();
        json.flush();
    }

    @Override
    void traceEntry(Map<String, Object> entry) {
        try {
            StringWriter str = new StringWriter();
            try (JsonWriter json = new JsonWriter(str);){
                json.append('{');
                boolean first = true;
                for (Map.Entry<String, Object> mapEntry : entry.entrySet()) {
                    if (!first) {
                        json.append(", ");
                    }
                    json.quote(mapEntry.getKey()).append(':');
                    if (mapEntry.getValue() instanceof Object[]) {
                        this.printArray(json, (Object[])mapEntry.getValue());
                    } else {
                        json.quote(mapEntry.getValue());
                    }
                    first = false;
                }
                json.append('}');
            }
            this.traceEntry(str.toString());
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere((Throwable)e);
        }
    }

    private void printArray(JsonWriter json, Object[] array) throws IOException {
        json.append('[');
        for (int i = 0; i < array.length; ++i) {
            Object obj;
            if (i > 0) {
                json.append(',');
            }
            if ((obj = array[i]) instanceof Object[]) {
                this.printArray(json, (Object[])obj);
                continue;
            }
            json.quote(array[i]);
        }
        json.append(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceEntry(String s) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.open) {
                if (this.written > 0) {
                    this.writer.write(",\n");
                }
                this.writer.write(s);
                ++this.written;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.writer.write("\n]\n");
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.open = false;
        }
    }
}

