/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.json;

import com.oracle.svm.configure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public interface JsonPrinter<T> {
    public void print(T var1, JsonWriter var2) throws IOException;

    public static <T> void printCollection(JsonWriter writer, Collection<T> collection, Comparator<T> comparator, JsonPrinter<T> elementPrinter) throws IOException {
        writer.append('[');
        writer.indent();
        String prefix = "";
        Collection<T> ordered = collection;
        if (comparator != null) {
            ordered = new ArrayList<T>(collection);
            ((List)ordered).sort(comparator);
        }
        for (T t : ordered) {
            writer.append(prefix);
            if (collection.size() > 1) {
                writer.newline();
            }
            elementPrinter.print(t, writer);
            prefix = ", ";
        }
        writer.unindent();
        if (collection.size() > 1) {
            writer.newline();
        }
        writer.append("]");
    }
}

