/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyConfiguration
implements JsonPrintable {
    private final ConcurrentHashMap.KeySetView<List<String>, Boolean> interfaceLists = ConcurrentHashMap.newKeySet();

    public void add(List<String> interfaceList) {
        this.interfaceLists.add(interfaceList);
    }

    public boolean contains(List<String> interfaceList) {
        return this.interfaceLists.contains(interfaceList);
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        ArrayList<String[]> lists = new ArrayList<String[]>(this.interfaceLists.size());
        for (List<String> list : this.interfaceLists) {
            lists.add(list.toArray(new String[0]));
        }
        lists.sort((a, b) -> {
            int c = 0;
            for (int i = 0; c == 0 && i < ((String[])a).length && i < ((String[])b).length; ++i) {
                c = a[i].compareTo(b[i]);
            }
            return c != 0 ? c : ((String[])a).length - ((String[])b).length;
        });
        writer.append('[');
        writer.indent();
        String prefix = "";
        for (String[] list : lists) {
            writer.append(prefix).newline().append('[');
            String typePrefix = "";
            for (String type : list) {
                writer.append(typePrefix).quote(type);
                typePrefix = ",";
            }
            writer.append(']');
            prefix = ",";
        }
        writer.unindent().newline();
        writer.append(']').newline();
    }
}

