/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import org.graalvm.word.ComparableWord;

public class NativeImageAgentJNIHandleSet
extends JNIHandleSet {
    final JNIMethodId javaLangClassForName3;
    final JNIMethodId javaLangReflectMemberGetName;
    final JNIMethodId javaLangReflectMemberGetDeclaringClass;
    final JNIMethodId javaUtilEnumerationHasMoreElements;
    final JNIMethodId javaUtilMissingResourceExceptionCtor3;
    final JNIObjectHandle javaLangClassLoader;
    public final JNIObjectHandle javaLangSecurityException;
    public final JNIObjectHandle javaLangNoClassDefFoundError;
    public final JNIObjectHandle javaLangNoSuchMethodError;
    final JNIObjectHandle javaLangNoSuchMethodException;
    public final JNIObjectHandle javaLangNoSuchFieldError;
    final JNIObjectHandle javaLangNoSuchFieldException;
    final JNIObjectHandle javaLangClassNotFoundException;
    final JNIObjectHandle javaLangRuntimeException;
    final JNIObjectHandle javaUtilMissingResourceException;
    final JNIMethodId javaLangClassGetDeclaredMethod;
    final JNIMethodId javaLangClassGetDeclaredConstructor;
    final JNIMethodId javaLangClassGetDeclaredField;
    final JNIMethodId javaLangClassGetName;
    final JNIMethodId javaLangInvokeMemberNameGetDeclaringClass;
    final JNIMethodId javaLangInvokeMemberNameGetName;
    final JNIMethodId javaLangInvokeMemberNameGetParameterTypes;
    final JNIMethodId javaLangInvokeMemberNameIsMethod;
    final JNIMethodId javaLangInvokeMemberNameIsField;
    final JNIMethodId javaLangInvokeMemberNameIsConstructor;
    private JNIObjectHandle javaLangReflectField;
    private JNIObjectHandle javaLangReflectMethod;
    private JNIObjectHandle javaLangReflectConstructor;
    private JNIObjectHandle javaUtilCollections;
    private JNIMethodId javaUtilCollectionsEmptyEnumeration;
    private JNIMethodId javaUtilResourceBundleGetBundleImplSLCC;
    private boolean queriedJavaUtilResourceBundleGetBundleImplSLCC;

    NativeImageAgentJNIHandleSet(JNIEnvironment env) {
        super(env);
        JNIObjectHandle javaLangClass = this.findClass(env, "java/lang/Class");
        this.javaLangClassForName3 = this.getMethodId(env, javaLangClass, "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", true);
        this.javaLangClassGetDeclaredMethod = this.getMethodId(env, javaLangClass, "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
        this.javaLangClassGetDeclaredConstructor = this.getMethodId(env, javaLangClass, "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", false);
        this.javaLangClassGetDeclaredField = this.getMethodId(env, javaLangClass, "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", false);
        this.javaLangClassGetName = this.getMethodId(env, javaLangClass, "getName", "()Ljava/lang/String;", false);
        JNIObjectHandle javaLangReflectMember = this.findClass(env, "java/lang/reflect/Member");
        this.javaLangReflectMemberGetName = this.getMethodId(env, javaLangReflectMember, "getName", "()Ljava/lang/String;", false);
        this.javaLangReflectMemberGetDeclaringClass = this.getMethodId(env, javaLangReflectMember, "getDeclaringClass", "()Ljava/lang/Class;", false);
        JNIObjectHandle javaUtilEnumeration = this.findClass(env, "java/util/Enumeration");
        this.javaUtilEnumerationHasMoreElements = this.getMethodId(env, javaUtilEnumeration, "hasMoreElements", "()Z", false);
        this.javaLangClassLoader = this.newClassGlobalRef(env, "java/lang/ClassLoader");
        this.javaLangSecurityException = this.newClassGlobalRef(env, "java/lang/SecurityException");
        this.javaLangNoClassDefFoundError = this.newClassGlobalRef(env, "java/lang/NoClassDefFoundError");
        this.javaLangNoSuchMethodError = this.newClassGlobalRef(env, "java/lang/NoSuchMethodError");
        this.javaLangNoSuchMethodException = this.newClassGlobalRef(env, "java/lang/NoSuchMethodException");
        this.javaLangNoSuchFieldError = this.newClassGlobalRef(env, "java/lang/NoSuchFieldError");
        this.javaLangNoSuchFieldException = this.newClassGlobalRef(env, "java/lang/NoSuchFieldException");
        this.javaLangClassNotFoundException = this.newClassGlobalRef(env, "java/lang/ClassNotFoundException");
        this.javaLangRuntimeException = this.newClassGlobalRef(env, "java/lang/RuntimeException");
        this.javaUtilMissingResourceException = this.newClassGlobalRef(env, "java/util/MissingResourceException");
        this.javaUtilMissingResourceExceptionCtor3 = this.getMethodId(env, this.javaUtilMissingResourceException, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
        JNIObjectHandle javaLangInvokeMemberName = this.findClass(env, "java/lang/invoke/MemberName");
        this.javaLangInvokeMemberNameGetDeclaringClass = this.getMethodId(env, javaLangInvokeMemberName, "getDeclaringClass", "()Ljava/lang/Class;", false);
        this.javaLangInvokeMemberNameGetName = this.getMethodId(env, javaLangInvokeMemberName, "getName", "()Ljava/lang/String;", false);
        this.javaLangInvokeMemberNameGetParameterTypes = this.getMethodId(env, javaLangInvokeMemberName, "getParameterTypes", "()[Ljava/lang/Class;", false);
        this.javaLangInvokeMemberNameIsMethod = this.getMethodId(env, javaLangInvokeMemberName, "isMethod", "()Z", false);
        this.javaLangInvokeMemberNameIsConstructor = this.getMethodId(env, javaLangInvokeMemberName, "isConstructor", "()Z", false);
        this.javaLangInvokeMemberNameIsField = this.getMethodId(env, javaLangInvokeMemberName, "isField", "()Z", false);
    }

    public JNIObjectHandle getJavaLangReflectField(JNIEnvironment env) {
        if (this.javaLangReflectField.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaLangReflectField = this.newClassGlobalRef(env, "java/lang/reflect/Field");
        }
        return this.javaLangReflectField;
    }

    JNIObjectHandle getJavaLangReflectMethod(JNIEnvironment env) {
        if (this.javaLangReflectMethod.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaLangReflectMethod = this.newClassGlobalRef(env, "java/lang/reflect/Method");
        }
        return this.javaLangReflectMethod;
    }

    JNIObjectHandle getJavaLangReflectConstructor(JNIEnvironment env) {
        if (this.javaLangReflectConstructor.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaLangReflectConstructor = this.newClassGlobalRef(env, "java/lang/reflect/Constructor");
        }
        return this.javaLangReflectConstructor;
    }

    JNIObjectHandle getJavaUtilCollections(JNIEnvironment env) {
        if (this.javaUtilCollections.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaUtilCollections = this.newClassGlobalRef(env, "java/util/Collections");
        }
        return this.javaUtilCollections;
    }

    JNIMethodId getJavaUtilCollectionsEmptyEnumeration(JNIEnvironment env) {
        if (this.javaUtilCollectionsEmptyEnumeration.isNull()) {
            this.javaUtilCollectionsEmptyEnumeration = this.getMethodId(env, this.getJavaUtilCollections(env), "emptyEnumeration", "()Ljava/util/Enumeration;", true);
        }
        return this.javaUtilCollectionsEmptyEnumeration;
    }

    JNIMethodId tryGetJavaUtilResourceBundleGetBundleImplSLCC(JNIEnvironment env) {
        if (!this.queriedJavaUtilResourceBundleGetBundleImplSLCC) {
            JNIObjectHandle javaUtilResourceBundle = this.findClass(env, "java/util/ResourceBundle");
            this.javaUtilResourceBundleGetBundleImplSLCC = this.getMethodIdOptional(env, javaUtilResourceBundle, "getBundleImpl", "(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/Class;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", true);
            this.queriedJavaUtilResourceBundleGetBundleImplSLCC = true;
        }
        return this.javaUtilResourceBundleGetBundleImplSLCC;
    }
}

