/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import java.util.Arrays;
import org.graalvm.compiler.phases.common.LazyValue;

public class ProxyAccessVerifier
extends AbstractAccessVerifier {
    private final ProxyConfiguration configuration;

    public ProxyAccessVerifier(ProxyConfiguration configuration, AccessAdvisor advisor) {
        super(advisor);
        this.configuration = configuration;
    }

    public boolean verifyNewProxyInstance(JNIEnvironment env, Object interfaceNames, JNIObjectHandle callerClass) {
        return this.verifyProxyAccess(env, interfaceNames, callerClass);
    }

    public boolean verifyGetProxyClass(JNIEnvironment env, Object interfaceNames, JNIObjectHandle callerClass) {
        return this.verifyProxyAccess(env, interfaceNames, callerClass);
    }

    private boolean verifyProxyAccess(JNIEnvironment env, Object interfaceNames, JNIObjectHandle callerClass) {
        String[] interfaceNamesArray;
        LazyValue<String> lazyCallerClass = ProxyAccessVerifier.lazyClassNameOrNull(env, callerClass);
        if (this.shouldApproveWithoutChecks(LazyValueUtils.lazyNull(), lazyCallerClass)) {
            return true;
        }
        if (!(interfaceNames instanceof String[])) {
            return false;
        }
        for (String name : interfaceNamesArray = (String[])interfaceNames) {
            if (!this.shouldApproveWithoutChecks(LazyValueUtils.lazyValue(name), lazyCallerClass)) continue;
            return true;
        }
        return this.configuration.contains(Arrays.asList(interfaceNamesArray));
    }
}

