/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonPrinter;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class ResourceConfiguration
implements JsonPrintable {
    private final ConcurrentMap<String, Pattern> resources = new ConcurrentHashMap<String, Pattern>();
    private final ConcurrentHashMap.KeySetView<String, Boolean> bundles = ConcurrentHashMap.newKeySet();

    public void addResourcePattern(String pattern) {
        this.resources.computeIfAbsent(pattern, Pattern::compile);
    }

    public void addBundle(String bundle) {
        this.bundles.add(bundle);
    }

    public boolean anyResourceMatches(String s) {
        for (Pattern pattern : this.resources.values()) {
            if (!pattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean anyBundleMatches(String s) {
        return this.bundles.contains(s);
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        writer.quote("resources").append(':');
        JsonPrinter.printCollection(writer, this.resources.keySet(), Comparator.naturalOrder(), (p, w) -> w.append('{').quote("pattern").append(':').quote((String)p).append('}'));
        writer.append(',').newline();
        writer.quote("bundles").append(':');
        JsonPrinter.printCollection(writer, this.bundles, Comparator.naturalOrder(), (p, w) -> w.append('{').quote("name").append(':').quote((String)p).append('}'));
        writer.unindent().newline().append('}').newline();
    }

    public static class ParserAdapter
    implements ResourcesRegistry {
        private final ResourceConfiguration configuration;

        public ParserAdapter(ResourceConfiguration configuration) {
            this.configuration = configuration;
        }

        public void addResources(String pattern) {
            this.configuration.addResourcePattern(pattern);
        }

        public void addResourceBundles(String name) {
            this.configuration.addBundle(name);
        }
    }
}

