/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.filters.RuleNode;
import org.graalvm.compiler.phases.common.LazyValue;

public final class AccessAdvisor {
    private static final RuleNode internalsFilter = RuleNode.createRoot();
    private RuleNode callerFilter = internalsFilter;
    private boolean heuristicsEnabled = true;
    private boolean isInLivePhase = false;
    private int launchPhase = 0;

    public static RuleNode copyBuiltinFilterTree() {
        return internalsFilter.copy();
    }

    private boolean filterExcludesCaller(String qualifiedClass) {
        assert (qualifiedClass == null || qualifiedClass.indexOf(47) == -1) : "expecting Java-format qualifiers, not internal format";
        return qualifiedClass != null && !this.callerFilter.treeIncludes(qualifiedClass);
    }

    public void setHeuristicsEnabled(boolean enable) {
        this.heuristicsEnabled = enable;
    }

    public void setCallerFilterTree(RuleNode rootNode) {
        this.callerFilter = rootNode;
    }

    public void setInLivePhase(boolean live) {
        this.isInLivePhase = live;
    }

    public boolean shouldIgnoreCaller(LazyValue<String> qualifiedClass) {
        return this.heuristicsEnabled && !this.isInLivePhase || this.filterExcludesCaller((String)qualifiedClass.get());
    }

    public boolean shouldIgnoreJniMethodLookup(LazyValue<String> queriedClass, LazyValue<String> name, LazyValue<String> signature, LazyValue<String> callerClass) {
        if (this.shouldIgnoreCaller(callerClass)) {
            return true;
        }
        if (!this.heuristicsEnabled) {
            return false;
        }
        if ("sun.launcher.LauncherHelper".equals(queriedClass.get())) {
            if (this.launchPhase == 0 && "getApplicationClass".equals(name.get()) && "()Ljava/lang/Class;".equals(signature.get())) {
                this.launchPhase = 1;
            }
            return true;
        }
        if (this.launchPhase == 1 && "getCanonicalName".equals(name.get()) && "()Ljava/lang/String;".equals(signature.get())) {
            this.launchPhase = 2;
            return true;
        }
        if (this.launchPhase > 0) {
            this.launchPhase = -1;
            if ("main".equals(name.get()) && "([Ljava/lang/String;)V".equals(signature.get())) {
                return true;
            }
        }
        if (callerClass.get() == null && "jdk.vm.ci.services.Services".equals(queriedClass.get()) && "getJVMCIClassLoader".equals(name.get()) && "()Ljava/lang/ClassLoader;".equals(signature.get())) {
            return true;
        }
        return callerClass.get() == null && "org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMToHotSpotEntryPoints".equals(queriedClass.get());
    }

    public boolean shouldIgnoreJniClassLookup(LazyValue<String> name, LazyValue<String> callerClass) {
        if (this.shouldIgnoreCaller(callerClass)) {
            return true;
        }
        if (!this.heuristicsEnabled) {
            return false;
        }
        return callerClass.get() == null && "jdk.vm.ci.services.Services".equals(name.get());
    }

    public boolean shouldIgnoreJniNewObjectArray(LazyValue<String> arrayClass, LazyValue<String> callerClass) {
        if (this.shouldIgnoreCaller(callerClass)) {
            return true;
        }
        if (!this.heuristicsEnabled) {
            return false;
        }
        return callerClass.get() == null && "[Ljava.lang.String;".equals(arrayClass.get());
    }

    static {
        internalsFilter.addOrGetChildren("**", RuleNode.Inclusion.Include);
        internalsFilter.addOrGetChildren("java.**", RuleNode.Inclusion.Exclude);
        internalsFilter.addOrGetChildren("javax.**", RuleNode.Inclusion.Exclude);
        internalsFilter.addOrGetChildren("sun.**", RuleNode.Inclusion.Exclude);
        internalsFilter.addOrGetChildren("com.sun.**", RuleNode.Inclusion.Exclude);
        internalsFilter.addOrGetChildren("jdk.**", RuleNode.Inclusion.Exclude);
        internalsFilter.addOrGetChildren("org.graalvm.compiler.**", RuleNode.Inclusion.Exclude);
        internalsFilter.removeRedundantNodes();
    }
}

