/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.filters;

import com.oracle.svm.configure.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class RuleNode {
    private static final Inclusion DEFAULT_INCLUSION = Inclusion.Exclude;
    private static final String CHILDREN_PATTERN = "*";
    private static final String DESCENDANTS_PATTERN = "**";
    private final String name;
    private Inclusion inclusion;
    private Inclusion childrenInclusion;
    private Inclusion descendantsInclusion;
    private Map<String, RuleNode> children;

    public static RuleNode createRoot() {
        return new RuleNode("");
    }

    private RuleNode(String unqualifiedName) {
        this.name = unqualifiedName;
    }

    public void addOrGetChildren(String qualifiedName, Inclusion leafInclusion) {
        if (leafInclusion != Inclusion.Include && leafInclusion != Inclusion.Exclude) {
            throw new IllegalArgumentException((Object)((Object)leafInclusion) + " not supported");
        }
        RuleNode parent = this;
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".", false);
        while (tokenizer.hasMoreTokens()) {
            boolean isPattern;
            String token = tokenizer.nextToken();
            boolean isLeaf = !tokenizer.hasMoreTokens();
            boolean bl = isPattern = token.indexOf(42) != -1;
            if (isPattern) {
                boolean recursive = token.equals(DESCENDANTS_PATTERN);
                if (!isLeaf || !recursive && !token.equals(CHILDREN_PATTERN)) {
                    throw new IllegalArgumentException(qualifiedName + ": only " + CHILDREN_PATTERN + " and " + DESCENDANTS_PATTERN + " are allowed as the entire pattern (no complex patterns), and only in the last position");
                }
                if (recursive) {
                    parent.descendantsInclusion = leafInclusion;
                    parent.childrenInclusion = null;
                    parent.children = null;
                    continue;
                }
                parent.childrenInclusion = leafInclusion;
                if (parent.children == null) continue;
                parent.children.values().removeIf(c -> {
                    c.inclusion = null;
                    return c.isRedundantLeaf();
                });
                continue;
            }
            RuleNode node = null;
            if (parent.children != null) {
                node = parent.children.get(token);
            } else {
                parent.children = new HashMap<String, RuleNode>();
            }
            if (node != null) {
                if (isLeaf) {
                    node.inclusion = leafInclusion;
                }
            } else {
                node = new RuleNode(token);
                node.inclusion = isLeaf ? leafInclusion : null;
                parent.children.put(token, node);
            }
            parent = node;
        }
    }

    private boolean isLeafNode() {
        return this.children == null || this.children.isEmpty();
    }

    public void reduceExhaustiveTree() {
        if (this.children != null) {
            for (RuleNode child : this.children.values()) {
                child.reduceExhaustiveTree0();
            }
        }
        this.removeRedundantNodes();
    }

    private int reduceExhaustiveTree0() {
        if (this.descendantsInclusion != null) {
            throw new IllegalStateException("Recursive rules are not allowed");
        }
        if (this.children != null) {
            int sum = 0;
            for (RuleNode child : this.children.values()) {
                sum += child.reduceExhaustiveTree0();
            }
            if (this.descendantsInclusion == null) {
                this.descendantsInclusion = sum > 0 ? Inclusion.Include : Inclusion.Exclude;
            }
        }
        int score = 0;
        score = RuleNode.addToScore(this.inclusion, score);
        score = RuleNode.addToScore(this.childrenInclusion, score);
        score = RuleNode.addToScore(this.descendantsInclusion, score);
        return score;
    }

    private static int addToScore(Inclusion inclusion, int score) {
        if (inclusion == Inclusion.Include) {
            return score + 1;
        }
        if (inclusion == Inclusion.Exclude) {
            return score - 1;
        }
        return score;
    }

    public void removeRedundantNodes() {
        this.removeRedundantDescendants(DEFAULT_INCLUSION);
    }

    private void removeRedundantDescendants(Inclusion inheritedDescendantsInclusion) {
        if (!this.isLeafNode()) {
            Inclusion descendantsDefaultInclusion = this.descendantsInclusion != null ? this.descendantsInclusion : inheritedDescendantsInclusion;
            Inclusion childrenDefaultInclusion = this.childrenInclusion != null ? this.childrenInclusion : descendantsDefaultInclusion;
            this.children.values().removeIf(c -> c.removeRedundantNodes(childrenDefaultInclusion, descendantsDefaultInclusion));
        }
    }

    private boolean removeRedundantNodes(Inclusion defaultInclusion, Inclusion descendantsDefaultInclusion) {
        assert (defaultInclusion == Inclusion.Include || descendantsDefaultInclusion == Inclusion.Exclude);
        assert (descendantsDefaultInclusion == Inclusion.Include || descendantsDefaultInclusion == Inclusion.Exclude);
        this.removeRedundantDescendants(descendantsDefaultInclusion);
        if (this.inclusion == defaultInclusion) {
            this.inclusion = null;
        }
        if (this.descendantsInclusion == descendantsDefaultInclusion) {
            this.descendantsInclusion = null;
        }
        if (this.childrenInclusion == this.descendantsInclusion || this.descendantsInclusion == null && this.childrenInclusion == descendantsDefaultInclusion) {
            this.childrenInclusion = null;
        }
        return this.isRedundantLeaf();
    }

    private boolean isRedundantLeaf() {
        return this.inclusion == null && this.childrenInclusion == null && this.descendantsInclusion == null && this.isLeafNode();
    }

    public void printJsonTree(OutputStream out) throws IOException {
        try (JsonWriter writer = new JsonWriter(new OutputStreamWriter(out));){
            writer.append('{');
            writer.indent().newline();
            writer.quote("rules").append(": [").indent().newline();
            boolean[] isFirstRule = new boolean[]{true};
            this.printJsonEntries(writer, isFirstRule, "");
            writer.unindent().newline();
            writer.append(']').unindent().newline();
            writer.append('}').newline();
        }
    }

    private void printJsonEntries(JsonWriter writer, boolean[] isFirstRule, String parentQualified) throws IOException {
        String qualified = parentQualified.isEmpty() ? this.name : parentQualified + '.' + this.name;
        String patternBegin = qualified.isEmpty() ? qualified : qualified + ".";
        RuleNode.printJsonRule(writer, isFirstRule, patternBegin + DESCENDANTS_PATTERN, this.descendantsInclusion);
        RuleNode.printJsonRule(writer, isFirstRule, patternBegin + CHILDREN_PATTERN, this.childrenInclusion);
        RuleNode.printJsonRule(writer, isFirstRule, qualified, this.inclusion);
        if (this.children != null) {
            RuleNode[] sorted = this.children.values().toArray(new RuleNode[0]);
            Arrays.sort(sorted, Comparator.comparing(child -> child.name));
            for (RuleNode child2 : sorted) {
                child2.printJsonEntries(writer, isFirstRule, qualified);
            }
        }
    }

    private static void printJsonRule(JsonWriter writer, boolean[] isFirstRule, String qualified, Inclusion inclusion) throws IOException {
        if (inclusion == null) {
            return;
        }
        if (!isFirstRule[0]) {
            writer.append(',').newline();
        } else {
            isFirstRule[0] = false;
        }
        writer.append('{');
        switch (inclusion) {
            case Include: {
                writer.quote("includeClasses");
                break;
            }
            case Exclude: {
                writer.quote("excludeClasses");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported inclusion value: " + inclusion.name());
            }
        }
        writer.append(':');
        writer.quote(qualified);
        writer.append("}");
    }

    public boolean treeIncludes(String qualifiedName) {
        RuleNode current = this;
        Inclusion inheritedInclusion = DEFAULT_INCLUSION;
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".", false);
        while (tokenizer.hasMoreTokens()) {
            RuleNode child;
            String part;
            if (current.descendantsInclusion != null) {
                inheritedInclusion = current.descendantsInclusion;
            }
            if ((part = tokenizer.nextToken()).indexOf(42) != -1) {
                throw new IllegalArgumentException("Patterns are not allowed for querying");
            }
            RuleNode ruleNode = child = current.children != null ? current.children.get(part) : null;
            if (child == null) {
                boolean isDirectChild;
                boolean bl = isDirectChild = !tokenizer.hasMoreTokens();
                if (isDirectChild && current.childrenInclusion != null) {
                    return current.childrenInclusion == Inclusion.Include;
                }
                return inheritedInclusion == Inclusion.Include;
            }
            current = child;
        }
        return current.inclusion == Inclusion.Include;
    }

    public RuleNode copy() {
        RuleNode copy = new RuleNode(this.name);
        copy.inclusion = this.inclusion;
        copy.childrenInclusion = this.childrenInclusion;
        copy.descendantsInclusion = this.descendantsInclusion;
        if (this.children != null) {
            copy.children = new HashMap<String, RuleNode>();
            for (Map.Entry<String, RuleNode> entry : this.children.entrySet()) {
                RuleNode childCopy = entry.getValue().copy();
                copy.children.put(entry.getKey(), childCopy);
            }
        }
        return copy;
    }

    public static enum Inclusion {
        Include("+"),
        Exclude("-");

        final String s;

        private Inclusion(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

