/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.filters;

import com.oracle.svm.configure.filters.RuleNode;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public class FilterConfigurationParser
extends ConfigurationParser {
    private final RuleNode rootNode;

    public FilterConfigurationParser(RuleNode rootNode) {
        assert (rootNode != null);
        this.rootNode = rootNode;
    }

    public void parseAndRegister(Reader reader) throws IOException {
        Object json = new JSONParser(reader).parse();
        this.parseTopLevelObject(FilterConfigurationParser.asMap((Object)json, (String)"First level of document must be an object"));
    }

    private void parseTopLevelObject(Map<String, Object> top) {
        Object rulesObject = null;
        for (Map.Entry<String, Object> pair : top.entrySet()) {
            if ("rules".equals(pair.getKey())) {
                rulesObject = pair.getValue();
                continue;
            }
            throw new JSONParserException("Unknown attribute '" + pair.getKey() + "' (supported attributes: name) in resource definition");
        }
        if (rulesObject != null) {
            List rulesList = FilterConfigurationParser.asList(rulesObject, (String)"Attribute 'list' must be a list of rule objects");
            for (Object entryObject : rulesList) {
                this.parseEntry(entryObject);
            }
        }
    }

    private void parseEntry(Object entryObject) {
        Map entry = FilterConfigurationParser.asMap((Object)entryObject, (String)"Filter entries must be objects");
        Object qualified = null;
        RuleNode.Inclusion inclusion = null;
        String exactlyOneMessage = "Exactly one of attributes 'includeClasses' and 'excludeClasses' must be specified for a filter entry";
        for (Map.Entry pair : entry.entrySet()) {
            if (qualified != null) {
                throw new JSONParserException(exactlyOneMessage);
            }
            qualified = pair.getValue();
            if ("includeClasses".equals(pair.getKey())) {
                inclusion = RuleNode.Inclusion.Include;
                continue;
            }
            if ("excludeClasses".equals(pair.getKey())) {
                inclusion = RuleNode.Inclusion.Exclude;
                continue;
            }
            throw new JSONParserException("Unknown attribute '" + (String)pair.getKey() + "' (supported attributes: 'includeClasses', 'excludeClasses') in filter");
        }
        if (qualified == null) {
            throw new JSONParserException(exactlyOneMessage);
        }
        this.rootNode.addOrGetChildren(qualified.toString(), inclusion);
    }
}

