/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.Support;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import org.graalvm.compiler.phases.common.LazyValue;

class AbstractAccessVerifier {
    protected final AccessAdvisor accessAdvisor;

    AbstractAccessVerifier(AccessAdvisor advisor) {
        this.accessAdvisor = advisor;
    }

    protected boolean shouldApproveWithoutChecks(JNIEnvironment env, JNIObjectHandle callerClass) {
        return this.accessAdvisor.shouldIgnoreCaller(AbstractAccessVerifier.lazyClassNameOrNull(env, callerClass));
    }

    protected static LazyValue<String> lazyClassNameOrNull(JNIEnvironment env, JNIObjectHandle clazz) {
        return LazyValueUtils.lazyGet(() -> Support.getClassNameOrNull(env, clazz));
    }
}

