/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.ConstantPoolException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;

class ConstantPoolTool {
    private static final int INVALID_LENGTH = -1;
    private final ByteBuffer buffer;
    private int cachedIndex = 1;
    private int cachedIndexOffset = 0;

    ConstantPoolTool(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    MethodReference readMethodReference(int cpi) {
        try {
            this.seekEntryPastTag(cpi, ConstantKind.METHODREF);
            this.buffer.getShort();
            int nameAndTypeIndex = Short.toUnsignedInt(this.buffer.getShort());
            this.seekEntryPastTag(nameAndTypeIndex, ConstantKind.NAMEANDTYPE);
            int nameIndex = Short.toUnsignedInt(this.buffer.getShort());
            int descriptorIndex = Short.toUnsignedInt(this.buffer.getShort());
            CharSequence name = this.readUTF(nameIndex);
            CharSequence descriptor = this.readUTF(descriptorIndex);
            return new MethodReference(name, descriptor);
        }
        catch (IllegalArgumentException | BufferUnderflowException | CharacterCodingException e) {
            throw new ConstantPoolException("Malformed constant pool", e);
        }
    }

    private void seekEntryPastTag(int cpi, ConstantKind expectedKind) {
        this.seekEntry(cpi);
        int tag = Byte.toUnsignedInt(this.buffer.get());
        if (tag != expectedKind.ordinal()) {
            throw new ConstantPoolException("Expected tag " + expectedKind.ordinal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence readUTF(int cpi) throws CharacterCodingException {
        this.seekEntryPastTag(cpi, ConstantKind.UTF8);
        int length = Short.toUnsignedInt(this.buffer.getShort());
        int previousLimit = this.buffer.limit();
        this.buffer.limit(this.buffer.position() + length);
        try {
            CharBuffer charBuffer = StandardCharsets.UTF_8.newDecoder().decode(this.buffer);
            return charBuffer;
        }
        finally {
            this.buffer.limit(previousLimit);
        }
    }

    private void seekEntry(int cpi) {
        int index;
        ConstantKind kind;
        boolean resumeAtCachedIndex = cpi >= this.cachedIndex;
        this.buffer.position(resumeAtCachedIndex ? this.cachedIndexOffset : 0);
        for (index = resumeAtCachedIndex ? this.cachedIndex : 1; index < cpi; index += kind.tableEntries) {
            int tag = Byte.toUnsignedInt(this.buffer.get());
            if (tag >= ConstantKind.VALUES.length) {
                throw new ConstantPoolException("Invalid constant pool entry tag: " + tag);
            }
            kind = ConstantKind.VALUES[tag];
            int length = kind.lengthWithoutTag;
            if (kind == ConstantKind.UTF8) {
                length = Short.toUnsignedInt(this.buffer.getShort());
            }
            if (length <= 0 || kind.tableEntries <= 0) {
                throw new ConstantPoolException("Invalid constant pool entry kind: " + (Object)((Object)kind));
            }
            this.buffer.position(this.buffer.position() + length);
        }
        if (index != cpi) {
            throw new ConstantPoolException("Constant pool index is not valid or unusable: " + cpi);
        }
        this.cachedIndex = cpi;
        this.cachedIndexOffset = this.buffer.position();
    }

    static class MethodReference {
        final CharSequence name;
        final CharSequence descriptor;

        MethodReference(CharSequence name, CharSequence descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }
    }

    static enum ConstantKind {
        UNUSED_0(-1),
        UTF8(-1),
        UNUSED_2(-1),
        INTEGER(4),
        FLOAT(4),
        LONG(8, 2),
        DOUBLE(8, 2),
        CLASS(2),
        STRING(2),
        FIELDREF(4),
        METHODREF(4),
        INTERFACEMETHODREF(4),
        NAMEANDTYPE(4),
        UNUSED_13(-1),
        UNUSED_14(-1),
        METHODHANDLE(3),
        METHODTYPE(2),
        DYNAMIC(4),
        INVOKEDYNAMIC(4),
        MODULE(2),
        PACKAGE(2);

        static final ConstantKind[] VALUES;
        final int lengthWithoutTag;
        final int tableEntries;

        private ConstantKind(int lengthWithoutTag) {
            this(lengthWithoutTag, 1);
        }

        private ConstantKind(int lengthWithoutTag, int tableEntries) {
            this.lengthWithoutTag = lengthWithoutTag;
            this.tableEntries = tableEntries;
        }

        static {
            VALUES = ConstantKind.values();
        }
    }
}

