/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestate.TypeStateUtils;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.BitSet;
import java.util.Iterator;

public class MultiTypeState
extends TypeState {
    protected final BitSet typesBitSet;
    protected final int typesCount;
    protected final boolean canBeNull;
    protected boolean merged;

    public MultiTypeState(boolean canBeNull, BitSet typesBitSet, int typesCount) {
        assert (!TypeStateUtils.needsTrim(typesBitSet)) : typesBitSet;
        this.typesBitSet = typesBitSet;
        this.typesCount = typesCount;
        this.canBeNull = canBeNull;
        this.merged = false;
        assert (this.typesCount > 1) : "Multi type state with single type.";
    }

    protected MultiTypeState(boolean canBeNull, MultiTypeState other) {
        this.typesBitSet = other.typesBitSet;
        this.typesCount = other.typesCount;
        this.canBeNull = canBeNull;
        this.merged = other.merged;
    }

    @Override
    public int objectsCount() {
        return this.typesCount;
    }

    @Override
    public AnalysisType exactType() {
        return null;
    }

    @Override
    public int typesCount() {
        return this.typesCount;
    }

    protected BitSet typesBitSet() {
        return this.typesBitSet;
    }

    @Override
    public final Iterator<AnalysisType> typesIterator(final BigBang bb) {
        return new BitSetIterator<AnalysisType>(this){

            @Override
            public AnalysisType next() {
                return bb.getUniverse().getType(this.nextSetBit());
            }
        };
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(final BigBang bb) {
        return new BitSetIterator<AnalysisObject>(this){

            @Override
            public AnalysisObject next() {
                return bb.getUniverse().getType(this.nextSetBit()).getContextInsensitiveAnalysisObject();
            }
        };
    }

    @Override
    public Iterator<AnalysisObject> objectsIterator(AnalysisType exactType) {
        throw AnalysisError.shouldNotReachHere("unimplemented");
    }

    @Override
    public final boolean containsType(AnalysisType exactType) {
        return this.typesBitSet.get(exactType.getId());
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean resultCanBeNull) {
        if (resultCanBeNull == this.canBeNull()) {
            return this;
        }
        return PointsToStats.registerTypeState(bb, new MultiTypeState(resultCanBeNull, this));
    }

    @Override
    public final boolean canBeNull() {
        return this.canBeNull;
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().isMergingEnabled()) : "policy mismatch";
        if (!this.merged) {
            for (AnalysisType type : this.types(bb)) {
                type.getContextInsensitiveAnalysisObject().noteMerge(bb);
            }
            this.merged = true;
        }
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.typesBitSet.hashCode();
        result = 31 * result + (this.canBeNull ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTypeState that = (MultiTypeState)o;
        return this.canBeNull == that.canBeNull && this.typesCount == that.typesCount && this.typesBitSet.equals(that.typesBitSet);
    }

    public String toString() {
        return "MType<" + this.typesCount + ":" + (this.canBeNull ? "null," : "") + "TODO>";
    }

    private abstract class BitSetIterator<T>
    implements Iterator<T> {
        private int current;

        private BitSetIterator() {
            this.current = MultiTypeState.this.typesBitSet.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.current >= 0;
        }

        public Integer nextSetBit() {
            int next = this.current;
            this.current = MultiTypeState.this.typesBitSet.nextSetBit(this.current + 1);
            return next;
        }
    }
}

