/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualParameterTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ConcurrentLightHashMap;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class PointsToAnalysisMethod
extends AnalysisMethod {
    private MethodTypeFlow typeFlow;
    private Object parsingReason;
    private Set<InvokeTypeFlow> implementationInvokedBy;
    private volatile Object contextInsensitiveVirtualInvoke;
    private volatile Object contextInsensitiveSpecialInvoke;
    private static final AtomicReferenceFieldUpdater<PointsToAnalysisMethod, Object> VIRTUAL_INVOKE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PointsToAnalysisMethod.class, Object.class, "contextInsensitiveVirtualInvoke");
    private static final AtomicReferenceFieldUpdater<PointsToAnalysisMethod, Object> SPECIAL_INVOKE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PointsToAnalysisMethod.class, Object.class, "contextInsensitiveSpecialInvoke");

    public PointsToAnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped) {
        super(universe, wrapped, MultiMethod.ORIGINAL_METHOD, null);
        this.typeFlow = this.declaringClass.universe.analysisPolicy().createMethodTypeFlow(this);
    }

    private PointsToAnalysisMethod(AnalysisMethod original, MultiMethod.MultiMethodKey multiMethodKey) {
        super(original, multiMethodKey);
        this.typeFlow = this.declaringClass.universe.analysisPolicy().createMethodTypeFlow(this);
    }

    @Override
    protected AnalysisMethod createMultiMethod(AnalysisMethod analysisMethod, MultiMethod.MultiMethodKey newMultiMethodKey) {
        return new PointsToAnalysisMethod(analysisMethod, newMultiMethodKey);
    }

    @Override
    public void startTrackInvocations() {
        if (this.implementationInvokedBy == null) {
            this.implementationInvokedBy = ConcurrentHashMap.newKeySet();
        }
    }

    public MethodTypeFlow getTypeFlow() {
        return this.typeFlow;
    }

    @Override
    public boolean registerAsInvoked(Object reason) {
        assert (reason instanceof InvokeTypeFlow || reason instanceof String) : reason;
        return super.registerAsInvoked(PointsToAnalysisMethod.unwrapInvokeReason(reason));
    }

    @Override
    public boolean registerAsImplementationInvoked(Object reason) {
        assert (reason instanceof InvokeTypeFlow || reason instanceof String) : reason;
        if (this.implementationInvokedBy != null && reason instanceof InvokeTypeFlow) {
            this.implementationInvokedBy.add((InvokeTypeFlow)reason);
        }
        return super.registerAsImplementationInvoked(PointsToAnalysisMethod.unwrapInvokeReason(reason));
    }

    public static Object unwrapInvokeReason(Object reason) {
        if (reason == null) {
            return "static root method";
        }
        if (reason instanceof InvokeTypeFlow) {
            BytecodePosition source = (BytecodePosition)((InvokeTypeFlow)reason).getSource();
            return source != null ? source : "root method";
        }
        return reason;
    }

    @Override
    public List<BytecodePosition> getInvokeLocations() {
        ArrayList<BytecodePosition> locations = new ArrayList<BytecodePosition>();
        for (InvokeTypeFlow invoke : this.implementationInvokedBy) {
            if (InvokeTypeFlow.isContextInsensitiveVirtualInvoke(invoke)) {
                locations.addAll(((AbstractVirtualInvokeTypeFlow)invoke).getInvokeLocations());
                continue;
            }
            if (invoke.getSource() == null) continue;
            locations.add((BytecodePosition)invoke.getSource());
        }
        return locations;
    }

    @Override
    public Iterable<? extends InvokeInfo> getInvokes() {
        return this.getTypeFlow().getInvokes();
    }

    public void setParsingReason(Object parsingReason) {
        this.parsingReason = parsingReason;
    }

    @Override
    public Object getParsingReason() {
        return this.parsingReason;
    }

    public InvokeTypeFlow initAndGetContextInsensitiveInvoke(PointsToAnalysis bb, BytecodePosition originalLocation, boolean isSpecial, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        AtomicReferenceFieldUpdater<PointsToAnalysisMethod, Object> invokeUpdater = isSpecial ? SPECIAL_INVOKE_UPDATER : VIRTUAL_INVOKE_UPDATER;
        InvokeTypeFlow flow = ConcurrentLightHashMap.computeIfAbsent(this, invokeUpdater, callerMultiMethodKey, key -> {
            InvokeTypeFlow result = PointsToAnalysisMethod.createContextInsensitiveInvoke(bb, this, originalLocation, isSpecial, key);
            PointsToAnalysisMethod.initContextInsensitiveInvoke(bb, this, result);
            return result;
        });
        return flow;
    }

    private static InvokeTypeFlow createContextInsensitiveInvoke(PointsToAnalysis bb, PointsToAnalysisMethod method, BytecodePosition originalLocation, boolean isSpecial, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        TypeFlow<?> receiverFlow;
        assert (!method.isStatic()) : method;
        TypeFlow[] actualParameters = new TypeFlow[method.getSignature().getParameterCount(true)];
        AnalysisType receiverType = method.getDeclaringClass();
        actualParameters[0] = receiverFlow = receiverType.getTypeFlow(bb, false);
        for (int i = 1; i < actualParameters.length; ++i) {
            actualParameters[i] = new ActualParameterTypeFlow((AnalysisType)method.getSignature().getParameterType(i - 1));
            actualParameters[i].enableFlow(bb);
        }
        ActualReturnTypeFlow actualReturn = null;
        AnalysisType returnType = (AnalysisType)method.getSignature().getReturnType();
        if (bb.isSupportedJavaKind(returnType.getStorageKind()) || bb.usePredicates() && returnType.getStorageKind() == JavaKind.Void) {
            actualReturn = new ActualReturnTypeFlow(returnType);
            actualReturn.enableFlow(bb);
        }
        InvokeTypeFlow invoke = isSpecial ? bb.analysisPolicy().createSpecialInvokeTypeFlow(originalLocation, receiverType, method, actualParameters, actualReturn, callerMultiMethodKey) : bb.analysisPolicy().createVirtualInvokeTypeFlow(originalLocation, receiverType, method, actualParameters, actualReturn, callerMultiMethodKey);
        invoke.enableFlow(bb);
        invoke.markAsContextInsensitive();
        return invoke;
    }

    private static void initContextInsensitiveInvoke(PointsToAnalysis bb, AnalysisMethod method, InvokeTypeFlow invoke) {
        AnalysisType receiverType = method.getDeclaringClass();
        TypeFlow<BytecodePosition> receiverFlow = receiverType.getTypeFlow(bb, false);
        receiverFlow.addObserver(bb, invoke);
    }

    public InvokeTypeFlow getContextInsensitiveVirtualInvoke(MultiMethod.MultiMethodKey callerMultiMethodKey) {
        InvokeTypeFlow invoke = (InvokeTypeFlow)ConcurrentLightHashMap.get(this, VIRTUAL_INVOKE_UPDATER, callerMultiMethodKey);
        AnalysisError.guarantee(invoke != null);
        return invoke;
    }

    @Override
    public boolean validateFixedPointState(BigBang bb) {
        if (this.typeFlow != null) {
            for (MethodFlowsGraph flowsGraph : this.typeFlow.getFlows()) {
                for (TypeFlow<?> flow : flowsGraph.flows()) {
                    assert (flow.validateFixedPointState(bb));
                }
            }
        }
        return true;
    }

    @Override
    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.contextInsensitiveVirtualInvoke = null;
        this.contextInsensitiveSpecialInvoke = null;
        this.typeFlow = null;
        this.implementationInvokedBy = null;
    }

    @Override
    public void setOpaqueReturn() {
        super.setOpaqueReturn();
        assert (!this.getTypeFlow().flowsGraphCreated()) : "must call setOpaqueReturn before typeflow is created";
    }
}

