/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.util.GraalAccess;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.ResolvedJavaField;

public interface OriginalFieldProvider {
    public static ResolvedJavaField getOriginalField(ResolvedJavaField field) {
        ResolvedJavaField cur = field;
        while (cur instanceof OriginalFieldProvider) {
            OriginalFieldProvider originalFieldProvider = (OriginalFieldProvider)cur;
            cur = originalFieldProvider.unwrapTowardsOriginalField();
        }
        return cur;
    }

    public static Field getJavaField(ResolvedJavaField field) {
        ResolvedJavaField originalField = OriginalFieldProvider.getOriginalField(field);
        if (originalField != null) {
            try {
                return GraalAccess.getOriginalSnippetReflection().originalField(originalField);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return null;
    }

    public ResolvedJavaField unwrapTowardsOriginalField();
}

