/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ContextInsensitiveFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaField;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class AnalysisField
extends AnalysisElement
implements WrappedJavaField,
OriginalFieldProvider {
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isAccessedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isAccessed");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isReadUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isRead");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isWrittenUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isWritten");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isFoldedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isFolded");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isUnsafeAccessedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isUnsafeAccessed");
    private static final AtomicIntegerFieldUpdater<AnalysisField> unsafeFrozenTypeStateUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisField.class, "unsafeFrozenTypeState");
    private final int id;
    private final boolean isInBaseLayer;
    public final ResolvedJavaField wrapped;
    protected FieldTypeFlow staticFieldFlow;
    protected FieldTypeFlow initialInstanceFieldFlow;
    protected ContextInsensitiveFieldTypeFlow instanceFieldFlow;
    private volatile Object isRead;
    private volatile Object isAccessed;
    private volatile Object isWritten;
    private volatile Object isFolded;
    private boolean isJNIAccessed;
    private volatile Object isUnsafeAccessed;
    private volatile int unsafeFrozenTypeState;
    private volatile Object observers;
    private boolean canBeNull;
    private ConcurrentMap<Object, Boolean> readBy;
    private ConcurrentMap<Object, Boolean> writtenBy;
    protected TypeState instanceFieldTypeState;
    protected int position;
    protected final AnalysisType declaringClass;
    protected final AnalysisType fieldType;
    protected Object fieldValueInterceptor;

    public AnalysisField(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        assert (!wrappedField.isInternal()) : wrappedField;
        this.position = -1;
        this.wrapped = wrappedField;
        boolean trackAccessChain = (Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options());
        this.readBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.writtenBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.declaringClass = universe.lookup((JavaType)wrappedField.getDeclaringClass());
        this.fieldType = AnalysisField.getDeclaredType(universe, wrappedField);
        if (this.isStatic()) {
            this.canBeNull = false;
            this.staticFieldFlow = new FieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = null;
        } else {
            this.canBeNull = !this.getStorageKind().isPrimitive();
            this.instanceFieldFlow = new ContextInsensitiveFieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = new FieldTypeFlow(this, this.getType());
        }
        if (universe.hostVM().useBaseLayer()) {
            int fid = universe.getImageLayerLoader().lookupHostedFieldInBaseLayer(this);
            if (fid != -1) {
                this.id = fid;
                this.isInBaseLayer = true;
            } else {
                this.id = universe.computeNextFieldId();
                this.isInBaseLayer = false;
            }
        } else {
            this.id = universe.computeNextFieldId();
            this.isInBaseLayer = false;
        }
    }

    @Override
    protected AnalysisUniverse getUniverse() {
        return this.declaringClass.getUniverse();
    }

    private static AnalysisType getDeclaredType(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        ResolvedJavaType resolvedType;
        try {
            resolvedType = wrappedField.getType().resolve(OriginalClassProvider.getOriginalType((JavaType)wrappedField.getDeclaringClass()));
        }
        catch (LinkageError e) {
            return universe.objectType();
        }
        return universe.lookup((JavaType)resolvedType);
    }

    @Override
    public ResolvedJavaField getWrapped() {
        return this.wrapped;
    }

    public int getId() {
        return this.id;
    }

    public boolean isInBaseLayer() {
        return this.isInBaseLayer;
    }

    public int hashCode() {
        return this.id;
    }

    public JavaKind getStorageKind() {
        return this.fieldType.getStorageKind();
    }

    public TypeState getTypeState() {
        if (this.getType().getStorageKind() != JavaKind.Object) {
            return null;
        }
        if (this.isStatic()) {
            return this.staticFieldFlow.getState();
        }
        return this.getInstanceFieldTypeState();
    }

    public TypeState getInstanceFieldTypeState() {
        return this.instanceFieldFlow.getState();
    }

    public FieldTypeFlow getInitialInstanceFieldFlow() {
        return this.initialInstanceFieldFlow;
    }

    public FieldTypeFlow getStaticFieldFlow() {
        assert (Modifier.isStatic(this.getModifiers())) : this;
        return this.staticFieldFlow;
    }

    public ContextInsensitiveFieldTypeFlow getInstanceFieldFlow() {
        assert (!Modifier.isStatic(this.getModifiers())) : this;
        return this.instanceFieldFlow;
    }

    public void cleanupAfterAnalysis() {
        this.staticFieldFlow = null;
        this.instanceFieldFlow = null;
        this.initialInstanceFieldFlow = null;
        this.readBy = null;
        this.writtenBy = null;
        this.instanceFieldTypeState = null;
    }

    public boolean registerAsAccessed(Object reason) {
        this.getDeclaringClass().registerAsReachable(this);
        assert (this.isValidReason(reason)) : "Registering a field as accessed needs to provide a valid reason.";
        boolean firstAttempt = AtomicUtils.atomicSet(this, reason, isAccessedUpdater);
        if (firstAttempt) {
            this.onReachable();
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        }
        return firstAttempt;
    }

    public boolean registerAsRead(Object reason) {
        this.getDeclaringClass().registerAsReachable(this);
        assert (this.isValidReason(reason)) : "Registering a field as read needs to provide a valid reason.";
        boolean firstAttempt = AtomicUtils.atomicSet(this, reason, isReadUpdater);
        if (this.readBy != null) {
            this.readBy.put(reason, Boolean.TRUE);
        }
        if (firstAttempt) {
            this.onReachable();
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        }
        return firstAttempt;
    }

    public boolean registerAsWritten(Object reason) {
        this.getDeclaringClass().registerAsReachable(this);
        assert (this.isValidReason(reason)) : "Registering a field as written needs to provide a valid reason.";
        boolean firstAttempt = AtomicUtils.atomicSet(this, reason, isWrittenUpdater);
        if (this.writtenBy != null && reason != null) {
            this.writtenBy.put(reason, Boolean.TRUE);
        }
        if (firstAttempt) {
            this.onReachable();
            if (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object) {
                this.getUniverse().onFieldAccessed(this);
            }
        }
        return firstAttempt;
    }

    public void registerAsFolded(Object reason) {
        this.getDeclaringClass().registerAsReachable(this);
        assert (this.isValidReason(reason)) : "Registering a field as folded needs to provide a valid reason.";
        if (AtomicUtils.atomicSet(this, reason, isFoldedUpdater)) {
            assert (this.getDeclaringClass().isReachable()) : this;
            this.onReachable();
        }
    }

    public boolean registerAsUnsafeAccessed(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a field as unsafe accessed needs to provide a valid reason.";
        this.registerAsAccessed(reason);
        if (AtomicUtils.atomicSet(this, reason, isUnsafeAccessedUpdater)) {
            this.registerAsWritten(reason);
            if (this.isStatic()) {
                this.getUniverse().registerUnsafeAccessedStaticField(this);
            } else {
                AnalysisType declaringType = this.getDeclaringClass();
                declaringType.registerUnsafeAccessedField(this);
            }
            return true;
        }
        return false;
    }

    public boolean isUnsafeAccessed() {
        return AtomicUtils.isSet(this, isUnsafeAccessedUpdater);
    }

    public void registerAsJNIAccessed() {
        this.isJNIAccessed = true;
    }

    public boolean isJNIAccessed() {
        return this.isJNIAccessed;
    }

    public void registerAsFrozenUnsafeAccessed() {
        unsafeFrozenTypeStateUpdater.set(this, 1);
    }

    public boolean hasUnsafeFrozenTypeState() {
        return AtomicUtils.isSet(this, unsafeFrozenTypeStateUpdater);
    }

    public Object getReadBy() {
        return isReadUpdater.get(this);
    }

    public Object getAccessedReason() {
        return this.isAccessed;
    }

    public boolean isAccessed() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater) || AtomicUtils.isSet(this, isWrittenUpdater) && (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object);
    }

    public boolean isRead() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater);
    }

    public Object getReadReason() {
        return this.isRead;
    }

    public boolean isWritten() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isWrittenUpdater);
    }

    public Object getWrittenReason() {
        return this.isWritten;
    }

    public boolean isFolded() {
        return AtomicUtils.isSet(this, isFoldedUpdater);
    }

    public Object getFoldedReason() {
        return this.isFolded;
    }

    @Override
    public boolean isReachable() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater) || AtomicUtils.isSet(this, isWrittenUpdater) || AtomicUtils.isSet(this, isFoldedUpdater);
    }

    @Override
    public void onReachable() {
        this.notifyReachabilityCallbacks(this.declaringClass.getUniverse(), new ArrayList<AnalysisFuture<Void>>());
    }

    public Object getFieldValueInterceptor() {
        return this.fieldValueInterceptor;
    }

    public void setFieldValueInterceptor(Object fieldValueInterceptor) {
        this.fieldValueInterceptor = fieldValueInterceptor;
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public int getPosition() {
        AnalysisError.guarantee(this.position != -1, "Unknown position for field %s", this);
        return this.position;
    }

    public AnalysisType getType() {
        return this.fieldType;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        throw GraalError.unimplementedOverride();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public String toString() {
        return "AnalysisField<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ", accessed: " + (this.isAccessed != null) + ", read: " + (this.isRead != null) + ", written: " + (this.isWritten != null) + ", folded: " + this.isFolded() + ">";
    }

    @Override
    public ResolvedJavaField unwrapTowardsOriginalField() {
        return this.wrapped;
    }

    public JavaConstant getConstantValue() {
        return this.getUniverse().lookup(this.getWrapped().getConstantValue());
    }

    public void beforeFieldValueAccess() {
        this.declaringClass.registerAsReachable(this);
        this.declaringClass.forAllSuperTypes(type -> {
            type.ensureOnTypeReachableTaskDone();
            List<AnalysisFuture<Void>> notifications = type.scheduledTypeReachableNotifications;
            if (notifications != null) {
                for (AnalysisFuture<Void> notification : notifications) {
                    notification.ensureDone();
                }
                type.scheduledTypeReachableNotifications = null;
            }
        });
    }
}

