/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class SubstitutionProcessor {
    public static final SubstitutionProcessor IDENTITY = new IdentitySubstitutionProcessor();

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        return type;
    }

    public ResolvedJavaField lookup(ResolvedJavaField field) {
        return field;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        return method;
    }

    public static void extendsTheChain(SubstitutionProcessor head, SubstitutionProcessor[] tail) {
        ChainedSubstitutionProcessor endOfchain = null;
        SubstitutionProcessor endOfHead = head;
        while (endOfHead instanceof ChainedSubstitutionProcessor) {
            endOfchain = (ChainedSubstitutionProcessor)endOfHead;
            endOfHead = endOfchain.second;
        }
        assert (endOfchain != null);
        SubstitutionProcessor[] tailChain = new SubstitutionProcessor[tail.length + 1];
        System.arraycopy(tail, 0, tailChain, 1, tail.length);
        tailChain[0] = endOfHead;
        endOfchain.second = SubstitutionProcessor.chainUpInOrder(tailChain);
    }

    public static SubstitutionProcessor chainUpInOrder(SubstitutionProcessor ... processors) {
        SubstitutionProcessor current = null;
        for (int i = processors.length - 1; i >= 0; --i) {
            current = current == null ? processors[i] : SubstitutionProcessor.chain(processors[i], current);
        }
        return current;
    }

    public static SubstitutionProcessor chain(SubstitutionProcessor first, SubstitutionProcessor second) {
        if (first == IDENTITY) {
            return second;
        }
        if (second == IDENTITY) {
            return first;
        }
        return new ChainedSubstitutionProcessor(first, second);
    }

    static final class ChainedSubstitutionProcessor
    extends SubstitutionProcessor {
        private final SubstitutionProcessor first;
        private SubstitutionProcessor second;

        private ChainedSubstitutionProcessor(SubstitutionProcessor first, SubstitutionProcessor second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public ResolvedJavaType lookup(ResolvedJavaType type) {
            return this.second.lookup(this.first.lookup(type));
        }

        @Override
        public ResolvedJavaField lookup(ResolvedJavaField field) {
            return this.second.lookup(this.first.lookup(field));
        }

        @Override
        public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
            return this.second.lookup(this.first.lookup(method));
        }
    }

    static final class IdentitySubstitutionProcessor
    extends SubstitutionProcessor {
        private IdentitySubstitutionProcessor() {
        }
    }
}

