/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;

public final class ImageHeapObjectArray
extends ImageHeapArray {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
    private static final VarHandle elementsHandle = ReflectionUtil.unreflectField(ObjectArrayData.class, (String)"arrayElementValues", (MethodHandles.Lookup)MethodHandles.lookup());

    ImageHeapObjectArray(AnalysisType type, JavaConstant hostedObject, int length) {
        this(type, hostedObject, length, -1);
    }

    ImageHeapObjectArray(AnalysisType type, JavaConstant hostedObject, int length, int identityHashCode) {
        super(new ObjectArrayData(type, hostedObject, null, length, identityHashCode), false);
    }

    ImageHeapObjectArray(AnalysisType type, int length) {
        super(new ObjectArrayData(type, null, new Object[length], length, -1), false);
    }

    private ImageHeapObjectArray(ImageHeapConstant.ConstantData data, boolean compressed) {
        super(data, compressed);
    }

    @Override
    public ObjectArrayData getConstantData() {
        return (ObjectArrayData)super.getConstantData();
    }

    void setElementValues(Object[] elementValues) {
        boolean success = elementsHandle.compareAndSet(this.constantData, null, elementValues);
        AnalysisError.guarantee(success, "Unexpected field values reference for constant %s", this);
    }

    Object[] getElementValues() {
        AnalysisError.guarantee(this.isReaderInstalled());
        Object[] arrayElements = this.getConstantData().arrayElementValues;
        AnalysisError.guarantee(arrayElements != null);
        return arrayElements;
    }

    @Override
    public Object getElement(int idx) {
        return arrayHandle.getVolatile(this.getElementValues(), idx);
    }

    @Override
    public JavaConstant readElementValue(int index) {
        Object value = this.getElement(index);
        return value instanceof JavaConstant ? (JavaConstant)value : (JavaConstant)((AnalysisFuture)value).ensureDone();
    }

    @Override
    public void setElement(int idx, JavaConstant value) {
        arrayHandle.setVolatile(this.getElementValues(), idx, value);
    }

    void setElementTask(int idx, AnalysisFuture<JavaConstant> task) {
        arrayHandle.setVolatile(this.getElementValues(), idx, task);
    }

    @Override
    public int getLength() {
        return this.getConstantData().length;
    }

    public JavaConstant compress() {
        assert (!this.compressed) : this;
        return new ImageHeapObjectArray(this.constantData, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed) : this;
        return new ImageHeapObjectArray(this.constantData, false);
    }

    @Override
    public ImageHeapConstant forObjectClone() {
        assert (this.constantData.type.isCloneableWithAllocation()) : "all arrays implement Cloneable";
        Object[] arrayElements = this.getElementValues();
        Objects.requireNonNull(arrayElements, "Cannot clone an array before the element values are set.");
        Object[] newArrayElementValues = Arrays.copyOf(arrayElements, arrayElements.length);
        return new ImageHeapObjectArray(new ObjectArrayData(this.constantData.type, null, newArrayElementValues, arrayElements.length, -1), this.compressed);
    }

    private static final class ObjectArrayData
    extends ImageHeapConstant.ConstantData {
        private Object[] arrayElementValues;
        final int length;

        private ObjectArrayData(AnalysisType type, JavaConstant hostedObject, Object[] arrayElementValues, int length, int identityHashCode) {
            super(type, hostedObject, identityHashCode);
            this.arrayElementValues = arrayElementValues;
            this.length = length;
            assert (type.isArray() && !type.getComponentType().isPrimitive()) : type;
        }
    }
}

