/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.TypedConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class ImageHeapConstant
implements JavaConstant,
TypedConstant,
CompressibleConstant,
VMConstant {
    private static final AtomicInteger currentId = new AtomicInteger(0);
    public static final VarHandle isReachableHandle = ReflectionUtil.unreflectField(ConstantData.class, (String)"isReachable", (MethodHandles.Lookup)MethodHandles.lookup());
    protected final ConstantData constantData;
    protected final boolean compressed;

    ImageHeapConstant(ConstantData constantData, boolean compressed) {
        this.constantData = constantData;
        this.compressed = compressed;
    }

    public ConstantData getConstantData() {
        return this.constantData;
    }

    public void ensureReaderInstalled() {
        if (this.constantData.hostedValuesReader != null) {
            this.constantData.hostedValuesReader.ensureDone();
        }
    }

    protected boolean isReaderInstalled() {
        return this.constantData.hostedValuesReader == null || this.constantData.hostedValuesReader.isDone();
    }

    boolean markReachable(ObjectScanner.ScanReason reason) {
        this.ensureReaderInstalled();
        return isReachableHandle.compareAndSet(this.constantData, null, reason);
    }

    public boolean isReachable() {
        return isReachableHandle.get(this.constantData) != null;
    }

    public boolean allowConstantFolding() {
        return this.constantData.type.isInitialized() || this.constantData.hostedObject == null;
    }

    public Object getReachableReason() {
        return this.constantData.isReachable;
    }

    public boolean hasIdentityHashCode() {
        return this.constantData.identityHashCode > 0;
    }

    public int getIdentityHashCode() {
        AnalysisError.guarantee(this.constantData.hostedObject == null, "ImageHeapConstant only stores the identity hash code when there is no hosted object.", new Object[0]);
        AnalysisError.guarantee(this.constantData.identityHashCode > 0, "The provided identity hashcode value must be a positive number to be on par with the Java HotSpot VM.", new Object[0]);
        return this.constantData.identityHashCode;
    }

    public void markInBaseLayer() {
        this.constantData.isInBaseLayer = true;
    }

    public boolean isInBaseLayer() {
        return this.constantData.isInBaseLayer;
    }

    public JavaConstant getHostedObject() {
        AnalysisError.guarantee(!CompressibleConstant.isCompressed((JavaConstant)this.constantData.hostedObject), "References to hosted objects should never be compressed.", new Object[0]);
        return this.constantData.hostedObject;
    }

    public boolean isBackedByHostedObject() {
        return this.constantData.hostedObject != null;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    @Override
    public AnalysisType getType() {
        return this.constantData.type;
    }

    public Object asBoxedPrimitive() {
        return null;
    }

    public int asInt() {
        return 0;
    }

    public boolean asBoolean() {
        return false;
    }

    public long asLong() {
        return 0L;
    }

    public float asFloat() {
        return 0.0f;
    }

    public double asDouble() {
        return 0.0;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public String toValueString() {
        if (this.constantData.type.getJavaClass() == String.class && this.constantData.hostedObject != null) {
            String valueString = this.constantData.hostedObject.toValueString();
            return valueString.substring(1, valueString.length() - 1);
        }
        return this.constantData.type.getName();
    }

    public abstract ImageHeapConstant forObjectClone();

    public boolean equals(Object o) {
        if (o instanceof ImageHeapConstant) {
            ImageHeapConstant other = (ImageHeapConstant)o;
            return this.constantData == other.constantData && this.compressed == other.compressed;
        }
        return false;
    }

    public int hashCode() {
        return this.constantData.hashCode() + (this.compressed ? 1 : 0);
    }

    public String toString() {
        return "ImageHeapConstant<" + this.constantData.type.toJavaName() + ", reachable: " + this.isReachable() + ", reader installed: " + this.isReaderInstalled() + ", compressed: " + this.compressed + ", backed: " + this.isBackedByHostedObject() + ">";
    }

    static abstract class ConstantData {
        protected final AnalysisType type;
        private final JavaConstant hostedObject;
        private final int identityHashCode;
        protected final int id;
        AnalysisFuture<Void> hostedValuesReader;
        private volatile Object isReachable;
        private boolean isInBaseLayer;

        ConstantData(AnalysisType type, JavaConstant hostedObject, int identityHashCode) {
            Objects.requireNonNull(type);
            this.type = type;
            this.hostedObject = CompressibleConstant.uncompress((JavaConstant)hostedObject);
            this.identityHashCode = hostedObject == null ? (identityHashCode == -1 ? System.identityHashCode(new Object()) : identityHashCode) : -1;
            this.id = currentId.getAndIncrement();
        }

        public int hashCode() {
            return this.hostedObject != null ? this.hostedObject.hashCode() : super.hashCode();
        }
    }
}

