/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.PrimitiveConstantTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.util.ClassUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.graal.compiler.graph.Node;
import jdk.vm.ci.code.BytecodePosition;

public abstract class TypeFlow<T> {
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> USE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "uses");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> INPUTS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "inputs");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> OBSERVERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "observers");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> OBSERVEES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "observees");
    protected static final AtomicInteger nextId = new AtomicInteger();
    protected final int id = nextId.incrementAndGet();
    protected T source;
    protected final AnalysisType declaredType;
    protected volatile TypeState state;
    private volatile Object uses;
    private volatile Object inputs;
    private volatile Object observers;
    private volatile Object observees;
    private int slot;
    private final boolean isClone;
    protected final MethodFlowsGraph graphRef;
    public volatile boolean inQueue;
    private volatile boolean isSaturated;
    private boolean isValid = true;
    private static final AtomicReferenceFieldUpdater<TypeFlow, TypeState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, TypeState.class, "state");
    protected final boolean isPrimitiveFlow;

    private TypeFlow(T source, AnalysisType declaredType, TypeState typeState, int slot, boolean isClone, MethodFlowsGraph graphRef) {
        this.source = source;
        this.declaredType = declaredType;
        this.slot = slot;
        this.isClone = isClone;
        this.graphRef = graphRef;
        this.state = typeState;
        this.isPrimitiveFlow = declaredType != null ? declaredType.isPrimitive() || declaredType.isWordType() : typeState.isPrimitive();
        this.validateSource();
        assert (this.primitiveFlowCheck(this.state)) : this;
    }

    private void validateSource() {
        assert (!(this.source instanceof Node)) : "must not reference Graal node from TypeFlow: " + String.valueOf(this.source);
    }

    public TypeFlow() {
        this(null, null, TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(TypeState typeState) {
        this(null, null, typeState, -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType) {
        this(source, declaredType, TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType, boolean canBeNull) {
        this(source, declaredType, canBeNull ? TypeState.forNull() : TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType, TypeState state) {
        this(source, declaredType, state, -1, false, null);
    }

    public TypeFlow(TypeFlow<T> original, MethodFlowsGraph graphRef) {
        this(original, graphRef, TypeState.forEmpty());
    }

    public TypeFlow(TypeFlow<T> original, MethodFlowsGraph graphRef, TypeState cloneState) {
        this(original.getSource(), original.getDeclaredType(), cloneState, original.getSlot(), true, graphRef);
        PointsToStats.registerTypeFlowRetainReason(this, original);
    }

    public TypeFlow<T> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return this;
    }

    public void initFlow(PointsToAnalysis bb) {
        throw AnalysisError.shouldNotReachHere("Type flow " + this.format(false, true) + " is not overriding initFlow().");
    }

    public boolean needsInitialization() {
        return false;
    }

    public TypeFlow<?> receiver() {
        return null;
    }

    public int id() {
        return this.id;
    }

    public MethodFlowsGraph graphRef() {
        if (this.graphRef != null) {
            return this.graphRef;
        }
        T t = this.source;
        if (t instanceof BytecodePosition) {
            MethodTypeFlow methodFlow;
            BytecodePosition position = (BytecodePosition)t;
            if (!this.isClone && (methodFlow = ((PointsToAnalysisMethod)position.getMethod()).getTypeFlow()).flowsGraphCreated()) {
                return methodFlow.getMethodFlowsGraph();
            }
        }
        return null;
    }

    public AnalysisMethod method() {
        if (this.graphRef != null) {
            return this.graphRef.getMethod();
        }
        if (this.source instanceof BytecodePosition) {
            BytecodePosition position = (BytecodePosition)this.source;
            return (AnalysisMethod)position.getMethod();
        }
        return null;
    }

    public T getSource() {
        return this.source;
    }

    public boolean isClone() {
        return this.isClone;
    }

    public boolean isContextInsensitive() {
        return false;
    }

    public AnalysisType getDeclaredType() {
        return this.declaredType;
    }

    public TypeState getState() {
        return this.state;
    }

    public boolean isAllInstantiated() {
        return this instanceof AllInstantiatedTypeFlow;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isSaturated() {
        return this.isSaturated;
    }

    public boolean canSaturate() {
        return true;
    }

    public void setSaturated() {
        this.isSaturated = true;
    }

    public boolean addState(PointsToAnalysis bb, TypeState add) {
        return this.addState(bb, add, true);
    }

    public boolean addState(PointsToAnalysis bb, TypeState add, boolean postFlow) {
        TypeState after;
        TypeState before;
        PointsToStats.registerTypeFlowUpdate(bb, this, add);
        do {
            TypeState filteredAdd;
            if (!(after = TypeState.forUnion(bb, before = this.state, filteredAdd = this.filter(bb, add))).equals(before)) continue;
            return false;
        } while (!STATE_UPDATER.compareAndSet(this, before, after));
        PointsToStats.registerTypeFlowSuccessfulUpdate(bb, this, add);
        assert (!bb.trackPrimitiveValues() || this.primitiveFlowCheck(after)) : String.valueOf(this) + "," + String.valueOf(after);
        if (this.checkSaturated(bb, after)) {
            this.onSaturated(bb);
        } else if (postFlow) {
            bb.postFlow(this);
        }
        return true;
    }

    private boolean primitiveFlowCheck(TypeState newState) {
        return !this.isPrimitiveFlow || newState.isPrimitive() || newState.isEmpty();
    }

    public boolean addUse(PointsToAnalysis bb, TypeFlow<?> use) {
        return this.addUse(bb, use, true);
    }

    private boolean checkDefUseCompatibility(TypeFlow<?> use) {
        if (this.declaredType == null || use.declaredType == null) {
            return true;
        }
        if (this.isPrimitiveFlow != use.isPrimitiveFlow) {
            return this instanceof OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow;
        }
        return true;
    }

    public boolean addUse(PointsToAnalysis bb, TypeFlow<?> use, boolean propagateTypeState) {
        assert (!bb.trackPrimitiveValues() || this.checkDefUseCompatibility(use)) : "Incompatible flows: " + String.valueOf(this) + " connected with " + String.valueOf(use);
        if (this.isSaturated() && propagateTypeState) {
            this.registerInput(bb, use);
            this.notifyUseOfSaturation(bb, use);
            return false;
        }
        if (this.doAddUse(bb, use)) {
            if (propagateTypeState) {
                if (this.isSaturated()) {
                    this.notifyUseOfSaturation(bb, use);
                    this.removeUse(use);
                    return false;
                }
                use.addState(bb, this.getState());
            }
            return true;
        }
        return false;
    }

    protected void notifyUseOfSaturation(PointsToAnalysis bb, TypeFlow<?> use) {
        use.onInputSaturated(bb, this);
    }

    protected boolean doAddUse(PointsToAnalysis bb, TypeFlow<?> use) {
        if (use.equals(this)) {
            return false;
        }
        if (!use.isValid()) {
            return false;
        }
        this.registerInput(bb, use);
        if (use.isSaturated()) {
            return false;
        }
        return ConcurrentLightHashSet.addElement(this, USE_UPDATER, use);
    }

    private void registerInput(PointsToAnalysis bb, TypeFlow<?> use) {
        if (bb.trackTypeFlowInputs()) {
            use.addInput(this);
        }
    }

    public boolean removeUse(TypeFlow<?> use) {
        return ConcurrentLightHashSet.removeElement(this, USE_UPDATER, use);
    }

    public void clearUses() {
        ConcurrentLightHashSet.clear(this, USE_UPDATER);
    }

    public Collection<TypeFlow<?>> getUses() {
        return ConcurrentLightHashSet.getElements(this, USE_UPDATER);
    }

    public void addObserver(PointsToAnalysis bb, TypeFlow<?> observer) {
        this.addObserver(bb, observer, true);
    }

    public boolean addObserver(PointsToAnalysis bb, TypeFlow<?> observer, boolean triggerUpdate) {
        if (this.isSaturated() && triggerUpdate) {
            this.registerObservee(bb, observer);
            this.notifyObserverOfSaturation(bb, observer);
            return false;
        }
        if (this.doAddObserver(bb, observer)) {
            if (triggerUpdate) {
                if (this.isSaturated()) {
                    this.notifyObserverOfSaturation(bb, observer);
                    this.removeObserver(observer);
                    return false;
                }
                if (!this.state.isEmpty()) {
                    bb.postTask(ignore -> observer.onObservedUpdate(bb));
                }
            }
            return true;
        }
        return false;
    }

    protected void notifyObserverOfSaturation(PointsToAnalysis bb, TypeFlow<?> observer) {
        observer.onObservedSaturated(bb, this);
    }

    private boolean doAddObserver(PointsToAnalysis bb, TypeFlow<?> observer) {
        if (observer.equals(this)) {
            return false;
        }
        if (!observer.isValid()) {
            return false;
        }
        this.registerObservee(bb, observer);
        return ConcurrentLightHashSet.addElement(this, OBSERVERS_UPDATER, observer);
    }

    private void registerObservee(PointsToAnalysis bb, TypeFlow<?> observer) {
        if (bb.trackTypeFlowInputs()) {
            observer.addObservee(this);
        }
    }

    public boolean removeObserver(TypeFlow<?> observer) {
        return ConcurrentLightHashSet.removeElement(this, OBSERVERS_UPDATER, observer);
    }

    public void clearObservers() {
        ConcurrentLightHashSet.clear(this, OBSERVERS_UPDATER);
    }

    public Collection<TypeFlow<?>> getObservers() {
        return ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER);
    }

    public void addObservee(TypeFlow<?> observee) {
        ConcurrentLightHashSet.addElement(this, OBSERVEES_UPDATER, observee);
    }

    public Collection<TypeFlow<?>> getObservees() {
        return ConcurrentLightHashSet.getElements(this, OBSERVEES_UPDATER);
    }

    public void clearObservees() {
        ConcurrentLightHashSet.clear(this, OBSERVEES_UPDATER);
    }

    public void addInput(TypeFlow<?> input) {
        ConcurrentLightHashSet.addElement(this, INPUTS_UPDATER, input);
    }

    public Collection<TypeFlow<?>> getInputs() {
        return ConcurrentLightHashSet.getElements(this, INPUTS_UPDATER);
    }

    public void clearInputs() {
        ConcurrentLightHashSet.clear(this, INPUTS_UPDATER);
    }

    public TypeState filter(PointsToAnalysis bb, TypeState newState) {
        return newState;
    }

    public TypeState declaredTypeFilter(PointsToAnalysis bb, TypeState newState) {
        return this.declaredTypeFilter(bb, newState, true);
    }

    public TypeState declaredTypeFilter(PointsToAnalysis bb, TypeState newState, boolean onlyWithRelaxedTypeFlowConstraints) {
        if (onlyWithRelaxedTypeFlowConstraints && !bb.analysisPolicy().relaxTypeFlowConstraints()) {
            return newState;
        }
        if (this.declaredType == null) {
            return newState;
        }
        if (this.declaredType.equals(bb.getObjectType())) {
            return newState;
        }
        if (this.isPrimitiveFlow) {
            assert (newState.isPrimitive() || newState.isEmpty()) : String.valueOf(newState) + "," + String.valueOf(this);
            return newState;
        }
        return TypeState.forIntersection(bb, newState, this.declaredType.getAssignableTypes(true));
    }

    public static AnalysisType filterUncheckedInterface(AnalysisType type) {
        AnalysisType elementalType;
        if (type != null && (elementalType = type.getElementalType()).isInterface() && !elementalType.isWordType()) {
            return type.getUniverse().objectType().getArrayClass(type.getArrayDimension());
        }
        return type;
    }

    public void update(PointsToAnalysis bb) {
        TypeState curState = this.getState();
        for (TypeFlow<?> use : this.getUses()) {
            if (!use.isValid() || use.isSaturated()) {
                this.removeUse(use);
                continue;
            }
            use.addState(bb, curState);
        }
        for (TypeFlow<?> observer : this.getObservers()) {
            if (observer.isValid()) {
                observer.onObservedUpdate(bb);
                continue;
            }
            this.removeObserver(observer);
        }
    }

    public void onObservedUpdate(PointsToAnalysis bb) {
    }

    boolean checkSaturated(PointsToAnalysis bb, TypeState typeState) {
        if (!bb.analysisPolicy().removeSaturatedTypeFlows()) {
            return false;
        }
        if (!this.canSaturate()) {
            return false;
        }
        if (typeState.isPrimitive()) {
            return !(typeState instanceof PrimitiveConstantTypeState);
        }
        return typeState.typesCount() > bb.analysisPolicy().typeFlowSaturationCutoff();
    }

    protected void onSaturated(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().removeSaturatedTypeFlows()) : "The type flow saturation optimization is disabled.";
        assert (this.canSaturate()) : "This type flow cannot saturate.";
        assert (bb.analysisPolicy().aliasArrayTypeFlows()) : "Array type flows must be aliased.";
        if (this.isSaturated()) {
            return;
        }
        this.setSaturated();
        this.onSaturated();
        this.notifySaturated(bb);
    }

    protected void onSaturated() {
    }

    private void notifySaturated(PointsToAnalysis bb) {
        for (TypeFlow<?> use : this.getUses()) {
            this.notifyUseOfSaturation(bb, use);
            this.removeUse(use);
        }
        for (TypeFlow<?> observer : this.getObservers()) {
            this.notifyObserverOfSaturation(bb, observer);
            this.removeObserver(observer);
        }
    }

    protected void swapOut(PointsToAnalysis bb, TypeFlow<?> newFlow) {
        for (TypeFlow<?> use : this.getUses()) {
            this.swapAtUse(bb, newFlow, use);
        }
        for (TypeFlow<?> observer : this.getObservers()) {
            this.swapAtObserver(bb, newFlow, observer);
        }
    }

    protected void swapAtUse(PointsToAnalysis bb, TypeFlow<?> newFlow, TypeFlow<?> use) {
        this.removeUse(use);
        newFlow.addUse(bb, use);
    }

    protected void swapAtObserver(PointsToAnalysis bb, TypeFlow<?> newFlow, TypeFlow<?> observer) {
        this.removeObserver(observer);
        observer.replacedObservedWith(bb, newFlow);
    }

    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        assert (bb.analysisPolicy().removeSaturatedTypeFlows()) : "The type flow saturation optimization is disabled.";
        if (!this.canSaturate()) {
            return;
        }
        this.onSaturated(bb);
    }

    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
    }

    public void replaceObservedWith(PointsToAnalysis bb, AnalysisType newObservedType) {
        this.replacedObservedWith(bb, newObservedType.getTypeFlow(bb, false));
    }

    public void replacedObservedWith(PointsToAnalysis bb, TypeFlow<?> newObservedFlow) {
        this.setObserved(newObservedFlow);
        newObservedFlow.addObserver(bb, this);
    }

    protected void setObserved(TypeFlow<?> newObservedFlow) {
    }

    void updateSource(T newSource) {
        this.source = newSource;
        this.validateSource();
    }

    public String formatSource() {
        if (this.source instanceof BytecodePosition) {
            BytecodePosition position = (BytecodePosition)this.source;
            return position.getMethod().asStackTraceElement(position.getBCI()).toString();
        }
        if (this.source == null && this.method() != null) {
            return this.method().asStackTraceElement(-1).toString();
        }
        return "<unknown-position>";
    }

    public String format(boolean withState, boolean withSource) {
        return ClassUtil.getUnqualifiedName(this.getClass()) + (String)(withSource ? " at " + this.formatSource() : "") + (String)(withState ? " with state <" + String.valueOf(this.getState()) + ">" : "");
    }

    public String toString() {
        return this.format(true, true);
    }

    public final boolean equals(Object other) {
        return other == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }
}

