/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.api;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisGraphDecoder;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class HostVM {
    protected final OptionValues options;
    protected final ClassLoader classLoader;
    protected final List<BiConsumer<AnalysisMethod, StructuredGraph>> methodAfterParsingListeners;
    private final List<BiConsumer<Feature.DuringAnalysisAccess, Class<?>>> classReachabilityListeners;
    protected HostedProviders providers;
    public static final Object PARSING_UNHANDLED = new Object();
    public static final Object PARSING_FAILED = new Object();
    protected static final MultiMethodAnalysisPolicy DEFAULT_MULTIMETHOD_ANALYSIS_POLICY = new MultiMethodAnalysisPolicy(){

        @Override
        public <T extends AnalysisMethod> Collection<T> determineCallees(BigBang bb, T implementation, T target, MultiMethod.MultiMethodKey callerMultiMethodKey, InvokeTypeFlow invokeFlow) {
            return List.of(implementation);
        }

        @Override
        public boolean performParameterLinking(MultiMethod.MultiMethodKey callerMultiMethodKey, MultiMethod.MultiMethodKey calleeMultiMethodKey) {
            return true;
        }

        @Override
        public boolean performReturnLinking(MultiMethod.MultiMethodKey callerMultiMethodKey, MultiMethod.MultiMethodKey calleeMultiMethodKey) {
            return true;
        }

        @Override
        public boolean canComputeReturnedParameterIndex(MultiMethod.MultiMethodKey multiMethodKey) {
            return true;
        }

        @Override
        public boolean insertPlaceholderParamAndReturnFlows(MultiMethod.MultiMethodKey multiMethodKey) {
            return false;
        }

        @Override
        public boolean unknownReturnValue(BigBang bb, MultiMethod.MultiMethodKey callerMultiMethodKey, AnalysisMethod implementation) {
            return false;
        }
    };

    protected HostVM(OptionValues options, ClassLoader classLoader) {
        this.options = options;
        this.classLoader = classLoader;
        this.methodAfterParsingListeners = new CopyOnWriteArrayList<BiConsumer<AnalysisMethod, StructuredGraph>>();
        this.classReachabilityListeners = new ArrayList();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public OptionValues options() {
        return this.options;
    }

    public boolean isRelocatedPointer(JavaConstant constant) {
        return false;
    }

    public Optional<AnalysisMethod> handleForeignCall(ForeignCallDescriptor foreignCallDescriptor, ForeignCallsProvider foreignCallsProvider) {
        return Optional.empty();
    }

    public void registerClassReachabilityListener(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener) {
        this.classReachabilityListeners.add(listener);
    }

    public void notifyClassReachabilityListener(AnalysisUniverse universe, Feature.DuringAnalysisAccess access) {
        for (AnalysisType type : universe.getTypes()) {
            if (!type.isReachable() || type.getReachabilityListenerNotified()) continue;
            type.setReachabilityListenerNotified(true);
            for (BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener : this.classReachabilityListeners) {
                listener.accept(access, type.getJavaClass());
            }
        }
    }

    public void registerType(AnalysisType newValue) {
    }

    public void registerType(AnalysisType newValue, int identityHashCode) {
    }

    public void checkType(ResolvedJavaType type, AnalysisUniverse universe) {
    }

    public abstract void onTypeReachable(BigBang var1, AnalysisType var2);

    public void onTypeInstantiated(BigBang bb, AnalysisType type) {
    }

    public boolean useBaseLayer() {
        return false;
    }

    public abstract boolean isInitialized(AnalysisType var1);

    public GraphBuilderConfiguration updateGraphBuilderConfiguration(GraphBuilderConfiguration config, AnalysisMethod method) {
        return config;
    }

    public abstract GraphBuilderPhase.Instance createGraphBuilderPhase(HostedProviders var1, GraphBuilderConfiguration var2, OptimisticOptimizations var3, IntrinsicContext var4);

    public String getImageName() {
        return null;
    }

    public void recordActivity() {
    }

    public void addMethodAfterParsingListener(BiConsumer<AnalysisMethod, StructuredGraph> methodAfterParsingHook) {
        this.methodAfterParsingListeners.add(methodAfterParsingHook);
    }

    public void methodAfterParsingHook(BigBang bb, AnalysisMethod method, StructuredGraph graph) {
        for (BiConsumer<AnalysisMethod, StructuredGraph> listener : this.methodAfterParsingListeners) {
            listener.accept(method, graph);
        }
    }

    public void methodBeforeTypeFlowCreationHook(BigBang bb, AnalysisMethod method, StructuredGraph graph) {
    }

    public boolean hasNeverInlineDirective(ResolvedJavaMethod method) {
        return true;
    }

    public InlineBeforeAnalysisGraphDecoder createInlineBeforeAnalysisGraphDecoder(BigBang bb, AnalysisMethod method, StructuredGraph resultGraph) {
        return new InlineBeforeAnalysisGraphDecoder(bb, InlineBeforeAnalysisPolicy.NO_INLINING, resultGraph, bb.getProviders(method), null);
    }

    public boolean skipInterface(AnalysisUniverse universe, ResolvedJavaType interfaceType, ResolvedJavaType implementingType) {
        return false;
    }

    public boolean platformSupported(AnnotatedElement element) {
        return true;
    }

    public void clearInThread() {
    }

    public abstract Comparator<? super ResolvedJavaType> getTypeComparator();

    public Object parseGraph(BigBang bb, DebugContext debug, AnalysisMethod method) {
        return PARSING_UNHANDLED;
    }

    public boolean validateGraph(PointsToAnalysis bb, StructuredGraph graph) {
        return true;
    }

    public StructuredGraph.AllowAssumptions allowAssumptions(AnalysisMethod method) {
        return StructuredGraph.AllowAssumptions.NO;
    }

    public boolean recordInlinedMethods(AnalysisMethod method) {
        return false;
    }

    public void initializeProviders(HostedProviders newProviders) {
        AnalysisError.guarantee(this.providers == null, "can only initialize providers once", new Object[0]);
        this.providers = newProviders;
    }

    public HostedProviders getProviders(MultiMethod.MultiMethodKey key) {
        return this.providers;
    }

    public boolean isFieldIncluded(BigBang bb, Field field) {
        return true;
    }

    public MultiMethodAnalysisPolicy getMultiMethodAnalysisPolicy() {
        return DEFAULT_MULTIMETHOD_ANALYSIS_POLICY;
    }

    public boolean ignoreInstanceOfTypeDisallowed() {
        return false;
    }

    public Function<AnalysisType, ResolvedJavaType> getStrengthenGraphsToTargetFunction(MultiMethod.MultiMethodKey key) {
        return t -> t;
    }

    public boolean allowConstantFolding(AnalysisMethod method) {
        return method.isOriginalMethod();
    }

    public static interface MultiMethodAnalysisPolicy {
        public <T extends AnalysisMethod> Collection<T> determineCallees(BigBang var1, T var2, T var3, MultiMethod.MultiMethodKey var4, InvokeTypeFlow var5);

        public boolean performParameterLinking(MultiMethod.MultiMethodKey var1, MultiMethod.MultiMethodKey var2);

        public boolean performReturnLinking(MultiMethod.MultiMethodKey var1, MultiMethod.MultiMethodKey var2);

        public boolean canComputeReturnedParameterIndex(MultiMethod.MultiMethodKey var1);

        public boolean insertPlaceholderParamAndReturnFlows(MultiMethod.MultiMethodKey var1);

        public boolean unknownReturnValue(BigBang var1, MultiMethod.MultiMethodKey var2, AnalysisMethod var3);
    }
}

