/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.phases;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.extended.UnsafeAccessNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.replacements.PEGraphDecoder;
import jdk.graal.compiler.replacements.nodes.MethodHandleWithExceptionNode;
import jdk.graal.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;

public class InlineBeforeAnalysisGraphDecoder
extends PEGraphDecoder {
    private Field dmhStaticAccessorOffsetField;
    private Field dmhStaticAccessorBaseField;
    private AnalysisField dmhStaticAccessorOffsetAnalysisField;
    private AnalysisField dmhStaticAccessorBaseAnalysisField;
    protected final BigBang bb;
    protected final InlineBeforeAnalysisPolicy policy;

    public InlineBeforeAnalysisGraphDecoder(BigBang bb, InlineBeforeAnalysisPolicy policy, StructuredGraph graph, HostedProviders providers, LoopExplosionPlugin loopExplosionPlugin) {
        super(AnalysisParsedGraph.HOST_ARCHITECTURE, graph, (CoreProviders)providers, loopExplosionPlugin, providers.getGraphBuilderPlugins().getInvocationPlugins(), new InlineInvokePlugin[]{new InlineBeforeAnalysisInlineInvokePlugin(policy)}, null, policy.nodePlugins, null, null, new ConcurrentHashMap(), new ConcurrentHashMap(), policy.needsExplicitExceptions(), false);
        this.bb = bb;
        this.policy = policy;
        if (graph.getDebug().isLogEnabled()) {
            graph.getDebug().logv("InlineBeforeAnalysis: decoding " + graph.method().format("%H.%n(%p)"), new Object[0]);
        }
    }

    protected InvocationPlugin getInvocationPlugin(ResolvedJavaMethod targetMethod) {
        if (this.policy.tryInvocationPlugins()) {
            return super.getInvocationPlugin(targetMethod);
        }
        return null;
    }

    protected void cleanupGraph(GraphDecoder.MethodScope ms) {
        super.cleanupGraph(ms);
        InlineBeforeAnalysisMethodScope methodScope = InlineBeforeAnalysisGraphDecoder.cast(ms);
        methodScope.encodedGraphs.add((Object)methodScope.encodedGraph);
        for (EncodedGraph encodedGraph : methodScope.encodedGraphs) {
            super.recordGraphElements(encodedGraph);
        }
    }

    protected PEGraphDecoder.PEMethodScope createMethodScope(StructuredGraph targetGraph, PEGraphDecoder.PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, ResolvedJavaMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, ValueNode[] arguments) {
        return new InlineBeforeAnalysisMethodScope(this, targetGraph, caller, callerLoopScope, encodedGraph, (AnalysisMethod)method, invokeData, inliningDepth, arguments);
    }

    protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        return aMethod.ensureGraphParsed(this.bb).getEncodedGraph();
    }

    protected Node addFloatingNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        assert (node.isUnregistered()) : "If node is already in the graph, we would count it twice";
        this.maybeAbortInlining(methodScope, loopScope, node);
        return super.addFloatingNode(methodScope, loopScope, node);
    }

    protected final Node canonicalizeFixedNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        Node canonical = node;
        if (node instanceof UnsafeAccessNode) {
            UnsafeAccessNode unsafeAccess = (UnsafeAccessNode)node;
            canonical = this.canonicalizeUnsafeAccess(unsafeAccess);
        }
        canonical = super.canonicalizeFixedNode(methodScope, loopScope, canonical);
        canonical = this.doCanonicalizeFixedNode(InlineBeforeAnalysisGraphDecoder.cast(methodScope), loopScope, canonical);
        if (canonical == node || canonical != null && canonical.isUnregistered()) {
            this.maybeAbortInlining(methodScope, loopScope, canonical);
        }
        return canonical;
    }

    protected boolean shouldOmitIntermediateMethodInStates(ResolvedJavaMethod method) {
        return this.policy.shouldOmitIntermediateMethodInState((AnalysisMethod)method);
    }

    protected Node doCanonicalizeFixedNode(InlineBeforeAnalysisMethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        return node;
    }

    private Node canonicalizeUnsafeAccess(UnsafeAccessNode node) {
        Class clazz;
        long offset;
        LoadFieldNode offsetLoad;
        ValueNode valueNode;
        if (!(node.isCanonicalizable() && (valueNode = node.offset()) instanceof LoadFieldNode && (offsetLoad = (LoadFieldNode)valueNode).object() != null && offsetLoad.object().isJavaConstant())) {
            return node;
        }
        this.ensureDMHStaticAccessorFieldsInitialized();
        if (!offsetLoad.field().equals((Object)this.dmhStaticAccessorOffsetAnalysisField)) {
            return node;
        }
        JavaConstant accessorConstant = offsetLoad.object().asJavaConstant();
        Object accessor = this.bb.getSnippetReflectionProvider().asObject(Object.class, accessorConstant);
        try {
            offset = this.dmhStaticAccessorOffsetField.getLong(accessor);
            clazz = (Class)this.dmhStaticAccessorBaseField.get(accessor);
        }
        catch (IllegalAccessException e) {
            throw AnalysisError.shouldNotReachHere(e);
        }
        if (clazz == null) {
            return node;
        }
        ResolvedJavaType type = GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(clazz);
        ResolvedJavaField hostField = UnsafeAccessNode.findStaticFieldWithOffset((ResolvedJavaType)type, (long)offset, (JavaKind)node.accessKind());
        if (hostField == null) {
            return node;
        }
        AnalysisField field = this.bb.getUniverse().lookup((JavaField)hostField);
        if (field.isInternal() || field.getJavaKind() != node.accessKind()) {
            return node;
        }
        return node.cloneAsFieldAccess((ResolvedJavaField)field);
    }

    protected Node handleFloatingNodeAfterAdd(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, Node node) {
        Node canonical = node;
        if (canonical instanceof IsNullNode) {
            IsNullNode isNull = (IsNullNode)canonical;
            canonical = this.canonicalizeIsNull(isNull);
        }
        if (canonical != node) {
            canonical.setNodeSourcePosition(node.getNodeSourcePosition());
            node.replaceAtUsagesAndDelete(canonical);
        }
        return super.handleFloatingNodeAfterAdd(s, loopScope, canonical);
    }

    private Node canonicalizeIsNull(IsNullNode node) {
        LoadFieldNode fieldLoad;
        ValueNode valueNode = node.getValue();
        if (!(valueNode instanceof LoadFieldNode) || (fieldLoad = (LoadFieldNode)valueNode).object() == null || !fieldLoad.object().isJavaConstant()) {
            return node;
        }
        this.ensureDMHStaticAccessorFieldsInitialized();
        if (!fieldLoad.field().equals((Object)this.dmhStaticAccessorBaseAnalysisField)) {
            return node;
        }
        return LogicConstantNode.contradiction((Graph)node.graph());
    }

    private void ensureDMHStaticAccessorFieldsInitialized() {
        if (this.dmhStaticAccessorOffsetField == null) {
            Class staticAccessorClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle$StaticAccessor");
            this.dmhStaticAccessorOffsetField = ReflectionUtil.lookupField((Class)staticAccessorClass, (String)"staticOffset");
            this.dmhStaticAccessorBaseField = ReflectionUtil.lookupField((Class)staticAccessorClass, (String)"staticBase");
            this.dmhStaticAccessorOffsetAnalysisField = this.bb.getMetaAccess().lookupJavaField(this.dmhStaticAccessorOffsetField);
            this.dmhStaticAccessorBaseAnalysisField = this.bb.getMetaAccess().lookupJavaField(this.dmhStaticAccessorBaseField);
        }
    }

    protected void handleNonInlinedInvoke(GraphDecoder.MethodScope ms, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData) {
        InlineBeforeAnalysisMethodScope methodScope = InlineBeforeAnalysisGraphDecoder.cast(ms);
        this.maybeAbortInlining((GraphDecoder.MethodScope)methodScope, loopScope, (Node)((Invoke)invokeData.invoke).asNode());
        if (!methodScope.inliningAborted && methodScope.isInlinedMethod()) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(methodScope.inliningDepth) + "  nonInlinedInvoke " + String.valueOf(invokeData.callTarget.targetMethod()) + ": " + String.valueOf(methodScope.policyScope), new Object[0]);
            }
            if (!methodScope.policyScope.processNonInlinedInvoke(this.providers, invokeData.callTarget)) {
                this.abortInlining(methodScope);
            }
        }
        super.handleNonInlinedInvoke((GraphDecoder.MethodScope)methodScope, loopScope, invokeData);
    }

    protected void maybeAbortInlining(GraphDecoder.MethodScope ms, GraphDecoder.LoopScope loopScope, Node node) {
        InlineBeforeAnalysisMethodScope methodScope = InlineBeforeAnalysisGraphDecoder.cast(ms);
        if (!methodScope.inliningAborted && methodScope.isInlinedMethod()) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(methodScope.inliningDepth) + "  node " + String.valueOf(node) + ": " + String.valueOf(methodScope.policyScope), new Object[0]);
            }
            if (!methodScope.policyScope.processNode(this.bb.getMetaAccess(), (AnalysisMethod)methodScope.method, node)) {
                this.abortInlining(methodScope);
            }
        }
    }

    protected void abortInlining(InlineBeforeAnalysisMethodScope methodScope) {
        if (!methodScope.inliningAborted) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(methodScope.inliningDepth) + "    abort!", new Object[0]);
            }
            methodScope.inliningAborted = true;
        }
    }

    protected GraphDecoder.LoopScope processNextNode(GraphDecoder.MethodScope ms, GraphDecoder.LoopScope loopScope) {
        InlineBeforeAnalysisMethodScope methodScope = InlineBeforeAnalysisGraphDecoder.cast(ms);
        if (methodScope.inliningAborted) {
            loopScope.nodesToProcess.clear();
            return loopScope;
        }
        return super.processNextNode((GraphDecoder.MethodScope)methodScope, loopScope);
    }

    protected GraphDecoder.LoopScope handleMethodHandle(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokableData<MethodHandleWithExceptionNode> invokableData) {
        CallTargetNode callTarget;
        boolean intrinsifiedMethodHandle;
        MethodHandleWithExceptionNode node = (MethodHandleWithExceptionNode)invokableData.invoke;
        WithExceptionNode replacement = node.trySimplify(this.providers.getConstantReflection().getMethodHandleAccess());
        boolean bl = intrinsifiedMethodHandle = replacement != node;
        if (!intrinsifiedMethodHandle) {
            replacement = node.replaceWithInvoke().asNode();
        }
        InvokeWithExceptionNode invoke = (InvokeWithExceptionNode)replacement;
        this.registerNode(loopScope, invokableData.orderId, (Node)invoke, true, false);
        GraphDecoder.InvokeData invokeData = new GraphDecoder.InvokeData((Invoke)invoke, invokableData.contextType, invokableData.orderId, -1, intrinsifiedMethodHandle, invokableData.stateAfterOrderId, invokableData.nextOrderId, invokableData.exceptionOrderId, invokableData.exceptionStateOrderId, invokableData.exceptionNextOrderId);
        CallTargetNode callTargetNode = invoke.callTarget();
        if (callTargetNode instanceof ResolvedMethodHandleCallTargetNode) {
            ResolvedMethodHandleCallTargetNode t = (ResolvedMethodHandleCallTargetNode)callTargetNode;
            callTarget = new MethodCallTargetNode(t.invokeKind(), t.targetMethod(), (ValueNode[])t.arguments().toArray((Object[])ValueNode.EMPTY_ARRAY), t.returnStamp(), t.getTypeProfile());
        } else {
            callTarget = (CallTargetNode)invoke.callTarget().copyWithInputs(false);
        }
        invoke.callTarget().replaceAtUsagesAndDelete(null);
        invokeData.callTarget = callTarget;
        return this.handleInvokeWithCallTarget((PEGraphDecoder.PEMethodScope)s, loopScope, invokeData);
    }

    protected void recordGraphElements(EncodedGraph encodedGraph) {
    }

    protected void finishInlining(GraphDecoder.MethodScope is) {
        InlineBeforeAnalysisMethodScope inlineScope = InlineBeforeAnalysisGraphDecoder.cast(is);
        InlineBeforeAnalysisMethodScope callerScope = InlineBeforeAnalysisGraphDecoder.cast((GraphDecoder.MethodScope)inlineScope.caller);
        GraphDecoder.LoopScope callerLoopScope = inlineScope.callerLoopScope;
        GraphDecoder.InvokeData invokeData = inlineScope.invokeData;
        if (inlineScope.inliningAborted) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(callerScope.inliningDepth) + "  aborted " + invokeData.callTarget.targetMethod().format("%H.%n(%p)") + ": " + String.valueOf(inlineScope.policyScope), new Object[0]);
            }
            AnalysisError.guarantee(inlineScope.policyScope.allowAbort(), "Unexpected abort: %s", new Object[]{inlineScope});
            if (callerScope.policyScope != null) {
                callerScope.policyScope.abortCalleeScope(inlineScope.policyScope);
            }
            if (invokeData.invokePredecessor.next() != null) {
                this.killControlFlowNodes(inlineScope, invokeData.invokePredecessor.next());
                assert (invokeData.invokePredecessor.next() == null) : "Successor must have been a fixed node created in the aborted scope, which is deleted now";
            }
            invokeData.invokePredecessor.setNext(((Invoke)invokeData.invoke).asFixedNode());
            if (inlineScope.exceptionPlaceholderNode != null) {
                assert (invokeData.invoke instanceof InvokeWithExceptionNode) : (Invoke)invokeData.invoke;
                assert (this.lookupNode(callerLoopScope, invokeData.exceptionOrderId) == inlineScope.exceptionPlaceholderNode) : inlineScope;
                this.registerNode(callerLoopScope, invokeData.exceptionOrderId, null, true, true);
                FixedNode exceptionReplacement = this.makeStubNode((GraphDecoder.MethodScope)callerScope, callerLoopScope, invokeData.exceptionOrderId);
                inlineScope.exceptionPlaceholderNode.replaceAtUsagesAndDelete((Node)exceptionReplacement);
            }
            this.handleNonInlinedInvoke((GraphDecoder.MethodScope)callerScope, callerLoopScope, invokeData);
            return;
        }
        if (this.graph.getDebug().isLogEnabled()) {
            this.graph.getDebug().logv("  ".repeat(callerScope.inliningDepth) + "  committed " + invokeData.callTarget.targetMethod().format("%H.%n(%p)") + ": " + String.valueOf(inlineScope.policyScope), new Object[0]);
        }
        if (callerScope.policyScope != null) {
            callerScope.policyScope.commitCalleeScope(inlineScope.policyScope);
        }
        InlineBeforeAnalysisMethodScope.recordInlined(callerScope, inlineScope);
        NodeSourcePosition callerBytecodePosition = callerScope.getCallerNodeSourcePosition();
        NodeSourcePosition reason = callerBytecodePosition != null ? callerBytecodePosition : callerScope.method;
        reason = reason == null ? this.graph.method() : reason;
        ((AnalysisMethod)invokeData.callTarget.targetMethod()).registerAsInlined(reason);
        super.finishInlining((GraphDecoder.MethodScope)inlineScope);
    }

    private void killControlFlowNodes(PEGraphDecoder.PEMethodScope inlineScope, FixedNode start) {
        ArrayDeque<Node> workList = null;
        FixedNode cur = start;
        while (true) {
            assert (!cur.isDeleted()) : cur;
            assert (this.graph.isNew(inlineScope.methodStartMark, (Node)cur)) : cur;
            FixedNode next = null;
            if (cur instanceof FixedWithNextNode) {
                next = ((FixedWithNextNode)cur).next();
            } else if (cur instanceof ControlSplitNode) {
                for (Node successor : cur.successors()) {
                    if (next == null) {
                        next = successor;
                        continue;
                    }
                    if (workList == null) {
                        workList = new ArrayDeque<Node>();
                    }
                    workList.push(successor);
                }
            } else if (cur instanceof AbstractEndNode) {
                next = ((AbstractEndNode)cur).merge();
            } else if (!(cur instanceof ControlSinkNode)) {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)cur);
            }
            if (cur instanceof AbstractMergeNode) {
                for (ValueNode phi : ((AbstractMergeNode)cur).phis().snapshot()) {
                    phi.replaceAtUsages(null);
                    phi.safeDelete();
                }
            }
            cur.replaceAtPredecessor(null);
            cur.replaceAtUsages(null);
            cur.safeDelete();
            if (next != null) {
                cur = next;
                continue;
            }
            if (workList == null || workList.isEmpty()) break;
            cur = (Node)workList.pop();
        }
    }

    protected static InlineBeforeAnalysisMethodScope cast(GraphDecoder.MethodScope methodScope) {
        return (InlineBeforeAnalysisMethodScope)methodScope;
    }

    protected FixedWithNextNode afterMethodScopeCreation(PEGraphDecoder.PEMethodScope is, FixedWithNextNode predecessor) {
        InlineBeforeAnalysisMethodScope inlineScope = InlineBeforeAnalysisGraphDecoder.cast((GraphDecoder.MethodScope)is);
        NodeSourcePosition sourcePosition = ((Invoke)inlineScope.invokeData.invoke).asNode().getNodeSourcePosition();
        return this.policy.processInvokeArgs((AnalysisMethod)inlineScope.method, predecessor, inlineScope.getArguments(), sourcePosition);
    }

    static final class InlineBeforeAnalysisInlineInvokePlugin
    implements InlineInvokePlugin {
        private final InlineBeforeAnalysisPolicy policy;

        InlineBeforeAnalysisInlineInvokePlugin(InlineBeforeAnalysisPolicy policy) {
            this.policy = policy;
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod m, ValueNode[] args) {
            InlineBeforeAnalysisPolicy.AbstractPolicyScope policyScope = InlineBeforeAnalysisGraphDecoder.cast((GraphDecoder.MethodScope)((PEGraphDecoder.PENonAppendGraphBuilderContext)b).methodScope).policyScope;
            AnalysisMethod method = (AnalysisMethod)m;
            if (this.policy.shouldInlineInvoke(b, policyScope, method, args)) {
                return this.policy.createInvokeInfo(method);
            }
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
    }

    public class InlineBeforeAnalysisMethodScope
    extends PEGraphDecoder.PEMethodScope {
        public final InlineBeforeAnalysisPolicy.AbstractPolicyScope policyScope;
        private boolean inliningAborted;
        private final EconomicSet<EncodedGraph> encodedGraphs;

        InlineBeforeAnalysisMethodScope(InlineBeforeAnalysisGraphDecoder this$0, StructuredGraph targetGraph, PEGraphDecoder.PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, AnalysisMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, ValueNode[] arguments) {
            super((PEGraphDecoder)this$0, targetGraph, caller, callerLoopScope, encodedGraph, (ResolvedJavaMethod)method, invokeData, inliningDepth, arguments);
            if (caller == null) {
                this.policyScope = this$0.policy.createRootScope();
                if (this$0.graph.getDebug().isLogEnabled()) {
                    this$0.graph.getDebug().logv("  ".repeat(inliningDepth) + "createRootScope for " + method.format("%H.%n(%p)") + ": " + String.valueOf(this.policyScope), new Object[0]);
                }
            } else {
                boolean[] constArgsWithReceiver = new boolean[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    constArgsWithReceiver[i] = arguments[i].isConstant();
                }
                this.policyScope = this$0.policy.openCalleeScope(InlineBeforeAnalysisGraphDecoder.cast((GraphDecoder.MethodScope)caller).policyScope, method);
                if (this$0.graph.getDebug().isLogEnabled()) {
                    this$0.graph.getDebug().logv("  ".repeat(inliningDepth) + "openCalleeScope for " + method.format("%H.%n(%p)") + ": " + String.valueOf(this.policyScope), new Object[0]);
                }
            }
            this.encodedGraphs = EconomicSet.create();
        }

        static void recordInlined(InlineBeforeAnalysisMethodScope callerScope, InlineBeforeAnalysisMethodScope calleeScope) {
            EconomicSet<EncodedGraph> callerEncodedGraphs = callerScope.encodedGraphs;
            callerEncodedGraphs.addAll(calleeScope.encodedGraphs);
            callerEncodedGraphs.add((Object)calleeScope.encodedGraph);
        }
    }
}

