/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ConstantContextSensitiveObject;
import com.oracle.graal.pointsto.heap.TypeData;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashMap;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class AnalysisType
extends AnalysisElement
implements WrappedJavaType,
OriginalClassProvider,
Comparable<AnalysisType> {
    private static final AtomicReferenceFieldUpdater<AnalysisType, ConcurrentHashMap> UNSAFE_ACCESS_FIELDS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, ConcurrentHashMap.class, "unsafeAccessedFields");
    private static final AtomicReferenceFieldUpdater<AnalysisType, AnalysisObject> UNIQUE_CONSTANT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, AnalysisObject.class, "uniqueConstant");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "interceptors");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> subtypeReachableNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "subtypeReachableNotifications");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> overrideReachableNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "overrideReachableNotifications");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> instantiatedNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "typeInstantiatedNotifications");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> objectReachableCallbacksUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "objectReachableCallbacks");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> isAllocatedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "isAllocated");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> isInHeapUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "isInHeap");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> isReachableUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "isReachable");
    private static final AtomicIntegerFieldUpdater<AnalysisType> isAnySubtypeInstantiatedUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisType.class, "isAnySubtypeInstantiated");
    protected final AnalysisUniverse universe;
    private final ResolvedJavaType wrapped;
    private ResolvedJavaType wrappedWithResolve;
    private final String qualifiedName;
    private final String unqualifiedName;
    private volatile Object isInHeap;
    private volatile Object isAllocated;
    private volatile Object isReachable;
    private volatile int isAnySubtypeInstantiated;
    private boolean reachabilityListenerNotified;
    private boolean unsafeFieldsRecomputed;
    private boolean unsafeAccessedFieldsRegistered;
    private volatile ConcurrentHashMap<UnsafePartitionKind, Collection<AnalysisField>> unsafeAccessedFields;
    private final Set<AnalysisType> subTypes;
    AnalysisType superClass;
    private final int id;
    private final JavaKind storageKind;
    private final boolean isCloneableWithAllocation;
    private AnalysisObject contextInsensitiveAnalysisObject;
    private ConcurrentMap<JavaConstant, AnalysisObject> constantObjectsCache;
    private volatile AnalysisObject uniqueConstant;
    private final ConcurrentHashMap<ResolvedJavaMethod, Object> resolvedMethods = new ConcurrentHashMap();
    private static final Object NULL_METHOD = new Object();
    private final AnalysisType componentType;
    private final AnalysisType elementalType;
    private final AnalysisType[] interfaces;
    private final boolean isArray;
    private final boolean isJavaLangObject;
    private final int dimension;
    private volatile Object interceptors;
    private final AnalysisFuture<Void> onTypeReachableTask;
    private final AnalysisFuture<Void> initializeMetaDataTask;
    private final AnalysisFuture<TypeData> typeData;
    private volatile Object subtypeReachableNotifications;
    private volatile Object overrideReachableNotifications;
    List<AnalysisFuture<Void>> scheduledTypeReachableNotifications;
    private volatile Object typeInstantiatedNotifications;
    private volatile Object objectReachableCallbacks;
    public TypeState assignableTypesState = TypeState.forNull();
    public TypeState assignableTypesNonNullState = TypeState.forEmpty();
    public AllInstantiatedTypeFlow instantiatedTypes;
    public AllInstantiatedTypeFlow instantiatedTypesNonNull;
    private volatile AnalysisType arrayClass = null;
    private volatile ResolvedJavaField[] instanceFieldsWithSuper;
    private volatile ResolvedJavaField[] instanceFieldsWithoutSuper;
    private static final int ANNOTATION = 8192;

    public AnalysisType(AnalysisUniverse universe, ResolvedJavaType javaType, JavaKind storageKind, AnalysisType objectType, AnalysisType cloneableType) {
        this.universe = universe;
        this.wrapped = javaType;
        this.qualifiedName = this.wrapped.toJavaName(true);
        this.unqualifiedName = this.wrapped.toJavaName(false);
        this.isArray = this.wrapped.isArray();
        this.isJavaLangObject = this.wrapped.isJavaLangObject();
        this.storageKind = storageKind;
        if (!this.isPrimitive() && !this.isWordType()) {
            this.instantiatedTypes = new AllInstantiatedTypeFlow(this, true);
            this.instantiatedTypesNonNull = new AllInstantiatedTypeFlow(this, false);
        }
        if (universe.analysisPolicy().needsConstantCache()) {
            this.constantObjectsCache = new ConcurrentHashMap<JavaConstant, AnalysisObject>();
        }
        try {
            this.link();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.superClass = universe.lookup((JavaType)this.wrapped.getSuperclass());
        this.interfaces = this.convertTypes(this.wrapped.getInterfaces());
        if (this.isArray()) {
            this.componentType = universe.lookup((JavaType)this.wrapped.getComponentType());
            int dim = 0;
            AnalysisType elemType = this;
            while (elemType.isArray()) {
                elemType = elemType.getComponentType();
                ++dim;
            }
            if (elemType.getSuperclass() != null) {
                elemType.getSuperclass().getArrayClass(dim);
            }
            this.elementalType = elemType;
            if (dim >= 2) {
                objectType.getArrayClass(dim - 1);
            }
            for (AnalysisType interf : elemType.getInterfaces()) {
                interf.getArrayClass(dim);
            }
            this.dimension = dim;
        } else {
            this.componentType = null;
            this.elementalType = this;
            this.dimension = 0;
        }
        this.id = universe.nextTypeId.getAndIncrement();
        this.subTypes = ConcurrentHashMap.newKeySet();
        this.addSubType(this);
        if (this.superClass != null) {
            this.superClass.addSubType(this);
        }
        if (this.isInterface() && this.interfaces.length == 0) {
            objectType.addSubType(this);
        }
        for (AnalysisType interf : this.interfaces) {
            interf.addSubType(this);
        }
        this.contextInsensitiveAnalysisObject = new AnalysisObject(universe, this);
        assert (this.getSuperclass() == null || this.getId() > this.getSuperclass().getId());
        this.isCloneableWithAllocation = this.isJavaLangObject() || this.isInterface() ? false : cloneableType.isAssignableFrom(this);
        this.onTypeReachableTask = new AnalysisFuture<Object>(() -> universe.onTypeReachable(this), null);
        this.initializeMetaDataTask = new AnalysisFuture<Object>(() -> universe.initializeMetaData(this), null);
        this.typeData = new AnalysisFuture<TypeData>(() -> {
            AnalysisError.guarantee(universe.getHeapScanner() != null, "Heap scanner is not available.", new Object[0]);
            return universe.getHeapScanner().computeTypeData(this);
        });
    }

    private AnalysisType[] convertTypes(ResolvedJavaType[] originalTypes) {
        ArrayList<AnalysisType> result = new ArrayList<AnalysisType>(originalTypes.length);
        for (ResolvedJavaType originalType : originalTypes) {
            if (this.universe.hostVM.skipInterface(this.universe, originalType, this.wrapped)) continue;
            result.add(this.universe.lookup((JavaType)originalType));
        }
        return result.toArray(new AnalysisType[result.size()]);
    }

    public AnalysisType getArrayClass(int dim) {
        AnalysisType result = this;
        for (int i = 0; i < dim; ++i) {
            result = result.getArrayClass();
        }
        return result;
    }

    public int getArrayDimension() {
        return this.dimension;
    }

    public void cleanupAfterAnalysis() {
        this.instantiatedTypes = null;
        this.instantiatedTypesNonNull = null;
        this.assignableTypesState = null;
        this.assignableTypesNonNullState = null;
        this.contextInsensitiveAnalysisObject = null;
        this.constantObjectsCache = null;
        this.uniqueConstant = null;
        this.unsafeAccessedFields = null;
        this.scheduledTypeReachableNotifications = null;
    }

    public int getId() {
        return this.id;
    }

    public AnalysisObject getContextInsensitiveAnalysisObject() {
        return this.contextInsensitiveAnalysisObject;
    }

    public AnalysisObject getUniqueConstantObject() {
        return this.uniqueConstant;
    }

    public AnalysisObject getCachedConstantObject(PointsToAnalysis bb, JavaConstant constant, Function<JavaConstant, AnalysisObject> constantTransformer) {
        assert (bb.analysisPolicy().needsConstantCache()) : "The analysis policy doesn't specify the need for a constants cache.";
        assert (bb.trackConcreteAnalysisObjects(this)) : this;
        assert (!(constant instanceof PrimitiveConstant)) : "The analysis should not model PrimitiveConstant.";
        if (this.uniqueConstant != null) {
            return this.uniqueConstant;
        }
        if (bb.maxConstantObjectsPerType() > 0 && this.constantObjectsCache.size() >= bb.maxConstantObjectsPerType()) {
            this.mergeConstantObjects(bb);
            return this.uniqueConstant;
        }
        return this.constantObjectsCache.computeIfAbsent(constant, constantTransformer);
    }

    private void mergeConstantObjects(PointsToAnalysis bb) {
        ConstantContextSensitiveObject uConstant = new ConstantContextSensitiveObject(bb, this);
        if (UNIQUE_CONSTANT_UPDATER.compareAndSet(this, null, uConstant)) {
            this.constantObjectsCache.values().forEach(constantObject -> {
                if (constantObject instanceof ConstantContextSensitiveObject) {
                    ConstantContextSensitiveObject ct = (ConstantContextSensitiveObject)constantObject;
                    ct.setMergedWithUniqueConstantObject();
                    ct.mergeInstanceFieldsFlows(bb, this.uniqueConstant);
                }
            });
        }
    }

    public TypeFlow<?> getTypeFlow(BigBang bb, boolean includeNull) {
        if (this.isPrimitive() || this.isWordType()) {
            return ((PointsToAnalysis)bb).getAnyPrimitiveSourceTypeFlow();
        }
        if (includeNull) {
            return this.instantiatedTypes;
        }
        return this.instantiatedTypesNonNull;
    }

    public TypeState getAssignableTypes(boolean includeNull) {
        if (includeNull) {
            return this.assignableTypesState;
        }
        return this.assignableTypesNonNullState;
    }

    public static boolean verifyAssignableTypes(BigBang bb) {
        List<AnalysisType> allTypes = bb.getUniverse().getTypes();
        ConcurrentHashMap.KeySetView mismatchedAssignableResults = ConcurrentHashMap.newKeySet();
        allTypes.parallelStream().filter(t -> t.instantiatedTypes != null).forEach(t1 -> {
            for (AnalysisType t2 : allTypes) {
                boolean expected = t2.isInstantiated() ? t1.isAssignableFrom(t2) : false;
                boolean actual = t1.instantiatedTypes.getState().containsType(t2);
                if (actual == expected) continue;
                mismatchedAssignableResults.add("assignableTypes mismatch: " + t1.toJavaName(true) + " (instantiated: " + t1.isInstantiated() + ") - " + t2.toJavaName(true) + " (instantiated: " + t2.isInstantiated() + "): expected=" + expected + ", actual=" + actual);
            }
        });
        if (!mismatchedAssignableResults.isEmpty()) {
            mismatchedAssignableResults.forEach(System.err::println);
            throw new AssertionError((Object)"Verification of all-instantiated type flows failed");
        }
        return true;
    }

    public boolean registerAsInHeap(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a type as in-heap needs to provide a valid reason.";
        this.registerAsReachable(reason);
        if (AtomicUtils.atomicSet(this, reason, isInHeapUpdater)) {
            this.onInstantiated(UsageKind.InHeap);
            return true;
        }
        return false;
    }

    public boolean registerAsAllocated(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a type as allocated needs to provide a valid reason.";
        this.registerAsReachable(reason);
        if (AtomicUtils.atomicSet(this, reason, isAllocatedUpdater)) {
            this.onInstantiated(UsageKind.Allocated);
            return true;
        }
        return false;
    }

    protected void onInstantiated(UsageKind usage) {
        this.universe.onTypeInstantiated(this, usage);
        this.notifyInstantiatedCallbacks();
        this.processMethodOverrides();
    }

    private void processMethodOverrides() {
        HashSet seenSubtypes = new HashSet();
        this.forAllSuperTypes(superType -> {
            AtomicUtils.atomicMark(superType, isAnySubtypeInstantiatedUpdater);
            seenSubtypes.add(superType);
            Map overrides = ConcurrentLightHashMap.getEntries(superType, overrideReachableNotificationsUpdater);
            for (Map.Entry entry : overrides.entrySet()) {
                AnalysisMethod baseMethod = (AnalysisMethod)entry.getKey();
                Set overrideNotifications = (Set)entry.getValue();
                for (AnalysisType subType : seenSubtypes) {
                    AnalysisMethod override = baseMethod.resolveInType(subType);
                    if (override == null || !override.isReachable()) continue;
                    overrideNotifications.forEach(n -> n.notifyCallback(this.universe, override));
                }
            }
        });
    }

    public void registerAsAssignable(BigBang bb) {
    }

    public boolean registerAsReachable(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a type as reachable needs to provide a valid reason.";
        if (!AtomicUtils.isSet(this, isReachableUpdater)) {
            this.forAllSuperTypes(type -> type.registerAsReachable(reason), false);
            AtomicUtils.atomicSetAndRun(this, reason, isReachableUpdater, this::onReachable);
            return true;
        }
        return false;
    }

    @Override
    protected void onReachable() {
        ArrayList<AnalysisFuture<Void>> futures = new ArrayList<AnalysisFuture<Void>>();
        this.notifyReachabilityCallbacks(this.universe, futures);
        this.forAllSuperTypes(type -> ConcurrentLightHashSet.forEach(type, subtypeReachableNotificationsUpdater, n -> futures.add(n.notifyCallback(this.universe, this))));
        if (futures.size() > 0) {
            this.scheduledTypeReachableNotifications = futures;
        }
        this.universe.notifyReachableType();
        this.universe.hostVM.checkForbidden(this, UsageKind.Reachable);
        if (this.isArray()) {
            this.registerAsAllocated("All array types are marked as instantiated eagerly.");
        }
        this.ensureOnTypeReachableTaskDone();
    }

    public void registerSubtypeReachabilityNotification(AnalysisElement.SubtypeReachableNotification notification) {
        ConcurrentLightHashSet.addElement(this, subtypeReachableNotificationsUpdater, notification);
    }

    public void registerOverrideReachabilityNotification(AnalysisMethod declaredMethod, AnalysisElement.MethodOverrideReachableNotification notification) {
        assert (declaredMethod.getDeclaringClass() == this) : declaredMethod;
        Set overrideNotifications = ConcurrentLightHashMap.computeIfAbsent(this, overrideReachableNotificationsUpdater, declaredMethod, m -> ConcurrentHashMap.newKeySet());
        overrideNotifications.add(notification);
    }

    public Set<AnalysisElement.MethodOverrideReachableNotification> getOverrideReachabilityNotifications(AnalysisMethod method) {
        return ConcurrentLightHashMap.getOrDefault(this, overrideReachableNotificationsUpdater, method, Collections.emptySet());
    }

    public <T> void registerObjectReachableCallback(BiConsumer<Feature.DuringAnalysisAccess, T> callback) {
        ConcurrentLightHashSet.addElement(this, objectReachableCallbacksUpdater, callback);
        for (AnalysisType subType : this.subTypes) {
            if (subType.equals(this)) continue;
            subType.registerObjectReachableCallback(callback);
        }
    }

    public <T> void notifyObjectReachable(Feature.DuringAnalysisAccess access, T object) {
        ConcurrentLightHashSet.forEach(this, objectReachableCallbacksUpdater, c -> c.accept(access, object));
    }

    public void registerInstantiatedCallback(Consumer<Feature.DuringAnalysisAccess> callback) {
        if (this.isInstantiated()) {
            callback.accept(this.universe.getConcurrentAnalysisAccess());
        } else {
            AnalysisElement.ElementNotification notification = new AnalysisElement.ElementNotification(callback);
            ConcurrentLightHashSet.addElement(this, instantiatedNotificationsUpdater, notification);
            if (this.isInstantiated()) {
                this.notifyInstantiatedCallback(notification);
            }
        }
    }

    private void notifyInstantiatedCallback(AnalysisElement.ElementNotification notification) {
        notification.notifyCallback(this.universe, this);
        ConcurrentLightHashSet.removeElement(this, instantiatedNotificationsUpdater, notification);
    }

    protected void notifyInstantiatedCallbacks() {
        ConcurrentLightHashSet.forEach(this, instantiatedNotificationsUpdater, c -> c.notifyCallback(this.universe, this));
        ConcurrentLightHashSet.removeElementIf(this, instantiatedNotificationsUpdater, AnalysisElement.ElementNotification::isNotified);
    }

    public void forAllSuperTypes(Consumer<AnalysisType> superTypeConsumer) {
        this.forAllSuperTypes(superTypeConsumer, true);
    }

    protected void forAllSuperTypes(Consumer<AnalysisType> superTypeConsumer, boolean includeThisType) {
        AnalysisType.forAllSuperTypes(this.elementalType, this.dimension, includeThisType, superTypeConsumer);
        for (int i = 0; i < this.dimension; ++i) {
            AnalysisType.forAllSuperTypes(this, i, false, superTypeConsumer);
        }
        if (this.dimension > 0 && !this.elementalType.isPrimitive() && !this.elementalType.isJavaLangObject()) {
            AnalysisType.forAllSuperTypes(this.universe.objectType(), this.dimension, true, superTypeConsumer);
        }
        if (this.isInterface()) {
            superTypeConsumer.accept(this.universe.objectType());
        }
    }

    private static void forAllSuperTypes(AnalysisType elementType, int arrayDimension, boolean processType, Consumer<AnalysisType> superTypeConsumer) {
        if (elementType == null) {
            return;
        }
        if (processType) {
            superTypeConsumer.accept(elementType.getArrayClass(arrayDimension));
        }
        for (AnalysisType interf : elementType.getInterfaces()) {
            AnalysisType.forAllSuperTypes(interf, arrayDimension, true, superTypeConsumer);
        }
        AnalysisType.forAllSuperTypes(elementType.getSuperclass(), arrayDimension, true, superTypeConsumer);
    }

    protected synchronized void addAssignableType(BigBang bb, TypeState typeState) {
        this.assignableTypesState = TypeState.forUnion((PointsToAnalysis)bb, this.assignableTypesState, typeState);
        this.assignableTypesNonNullState = this.assignableTypesState.forNonNull((PointsToAnalysis)bb);
    }

    public TypeData getOrComputeData() {
        GraalError.guarantee((boolean)this.isReachable(), (String)"TypeData is only available for reachable types");
        return this.typeData.ensureDone();
    }

    public void ensureOnTypeReachableTaskDone() {
        this.onTypeReachableTask.ensureDone();
    }

    public AnalysisFuture<Void> getInitializeMetaDataTask() {
        return this.initializeMetaDataTask;
    }

    public boolean getReachabilityListenerNotified() {
        return this.reachabilityListenerNotified;
    }

    public void setReachabilityListenerNotified(boolean reachabilityListenerNotified) {
        this.reachabilityListenerNotified = reachabilityListenerNotified;
    }

    public void registerUnsafeFieldsRecomputed() {
        this.unsafeFieldsRecomputed = true;
    }

    public void registerUnsafeAccessedField(AnalysisField field, UnsafePartitionKind partitionKind) {
        Collection<AnalysisField> unsafePartition;
        this.unsafeAccessedFieldsRegistered = true;
        if (this.unsafeAccessedFields == null) {
            UNSAFE_ACCESS_FIELDS_UPDATER.compareAndSet(this, null, new ConcurrentHashMap());
        }
        if ((unsafePartition = this.unsafeAccessedFields.get(partitionKind)) == null) {
            ConcurrentLinkedQueue<AnalysisField> newPartition = new ConcurrentLinkedQueue<AnalysisField>();
            ConcurrentLinkedQueue<AnalysisField> oldPartition = this.unsafeAccessedFields.putIfAbsent(partitionKind, newPartition);
            Collection<AnalysisField> collection = unsafePartition = oldPartition != null ? oldPartition : newPartition;
        }
        assert (!unsafePartition.contains(field)) : "Field " + String.valueOf(field) + " already registered as unsafe accessed with " + String.valueOf(this);
        unsafePartition.add(field);
    }

    private boolean hasUnsafeAccessedFields() {
        return this.unsafeAccessedFieldsRegistered || this.getSuperclass() != null && this.getSuperclass().hasUnsafeAccessedFields();
    }

    public List<AnalysisField> unsafeAccessedFields() {
        return this.unsafeAccessedFields(DefaultUnsafePartition.get());
    }

    public List<AnalysisField> unsafeAccessedFields(UnsafePartitionKind partitionKind) {
        if (!this.hasUnsafeAccessedFields()) {
            return Collections.emptyList();
        }
        return this.allUnsafeAccessedFields(partitionKind);
    }

    private List<AnalysisField> allUnsafeAccessedFields(UnsafePartitionKind partitionKind) {
        ArrayList<AnalysisField> unsafePartition = new ArrayList<AnalysisField>();
        unsafePartition.addAll(this.unsafeAccessedFields != null && this.unsafeAccessedFields.containsKey(partitionKind) ? this.unsafeAccessedFields.get(partitionKind) : Collections.emptyList());
        if (this.getSuperclass() != null) {
            List<AnalysisField> superFileds = this.getSuperclass().allUnsafeAccessedFields(partitionKind);
            unsafePartition.addAll(superFileds);
        }
        return unsafePartition;
    }

    public boolean isInstantiated() {
        boolean instantiated;
        boolean bl = instantiated = this.isInHeap() || this.isAllocated();
        assert (!instantiated || this.isReachable()) : this;
        return instantiated;
    }

    public boolean isAnySubtypeInstantiated() {
        return AtomicUtils.isSet(this, isAnySubtypeInstantiatedUpdater);
    }

    public boolean unsafeFieldsRecomputed() {
        return this.unsafeFieldsRecomputed;
    }

    @Override
    public boolean isReachable() {
        return AtomicUtils.isSet(this, isReachableUpdater);
    }

    public Object getReachableReason() {
        return this.isReachable;
    }

    public final JavaKind getStorageKind() {
        return this.storageKind;
    }

    public boolean isWordType() {
        return this.getJavaKind() != this.getStorageKind();
    }

    @Override
    public ResolvedJavaType getWrapped() {
        return this.wrapped;
    }

    public ResolvedJavaType getWrappedWithResolve() {
        if (this.wrappedWithResolve == null) {
            this.wrappedWithResolve = this.universe.substitutions.resolve(this.wrapped);
        }
        return this.wrappedWithResolve;
    }

    @Override
    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass((JavaType)this.wrapped);
    }

    public final String getName() {
        return this.wrapped.getName();
    }

    public String toJavaName() {
        return this.qualifiedName;
    }

    public String toJavaName(boolean qualified) {
        return qualified ? this.qualifiedName : this.unqualifiedName;
    }

    public final JavaKind getJavaKind() {
        return this.wrapped.getJavaKind();
    }

    public final ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public final boolean hasFinalizer() {
        return false;
    }

    public final Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public final boolean isInitialized() {
        return this.universe.hostVM.isInitialized(this);
    }

    public void initialize() {
        if (!this.wrapped.isInitialized()) {
            throw GraalError.shouldNotReachHere((String)("Classes can only be initialized using methods in ClassInitializationFeature: " + this.toClassName()));
        }
    }

    public final AnalysisType getArrayClass() {
        if (this.arrayClass == null) {
            this.arrayClass = this.universe.lookup((JavaType)this.wrapped.getArrayClass());
        }
        return this.arrayClass;
    }

    public boolean isInterface() {
        return this.wrapped.isInterface();
    }

    public boolean isEnum() {
        return this.wrapped.isEnum();
    }

    public boolean isInstanceClass() {
        return this.wrapped.isInstanceClass();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isJavaLangObject() {
        return this.isJavaLangObject;
    }

    public boolean isPrimitive() {
        return this.wrapped.isPrimitive();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        return this.wrapped.isAssignableFrom(((AnalysisType)other).getWrappedWithResolve());
    }

    public boolean isInstance(JavaConstant obj) {
        return this.wrapped.isInstance(this.universe.toHosted(obj));
    }

    public AnalysisType getSuperclass() {
        return this.superClass;
    }

    public AnalysisType[] getInterfaces() {
        return this.interfaces;
    }

    public ResolvedJavaType getSingleImplementor() {
        return this;
    }

    public Set<AnalysisType> getSubTypes() {
        return this.subTypes;
    }

    private void addSubType(AnalysisType subType) {
        boolean result = this.subTypes.add(subType);
        if (!subType.equals(this)) {
            ConcurrentLightHashSet.forEach(this, objectReachableCallbacksUpdater, callback -> subType.registerObjectReachableCallback((BiConsumer)callback));
        }
        assert (result) : "Tried to add a " + String.valueOf(subType) + " which is already registered";
    }

    public Set<AnalysisType> getAllSubtypes() {
        HashSet<AnalysisType> result = new HashSet<AnalysisType>();
        AnalysisType.collectSubtypes(this, result);
        return result;
    }

    private static void collectSubtypes(AnalysisType baseType, Set<AnalysisType> result) {
        for (AnalysisType subType : baseType.getSubTypes()) {
            if (!result.add(subType)) continue;
            AnalysisType.collectSubtypes(subType, result);
        }
    }

    public AnalysisType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return this.universe.lookup((JavaType)this.wrapped.findLeastCommonAncestor(((AnalysisType)otherType).getWrappedWithResolve()));
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        Assumptions.AssumptionResult wrappedResult = this.wrapped.findLeafConcreteSubtype();
        if (wrappedResult != null && wrappedResult.isAssumptionFree()) {
            return new Assumptions.AssumptionResult((Object)this.universe.lookup((JavaType)wrappedResult.getResult()));
        }
        return null;
    }

    public AnalysisType getComponentType() {
        return this.componentType;
    }

    public AnalysisType getElementalType() {
        return this.elementalType;
    }

    public boolean hasSubTypes() {
        return this.subTypes.size() > 1;
    }

    public AnalysisMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        throw GraalError.unimplementedOverride();
    }

    public AnalysisMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        Object resolvedMethod = this.resolvedMethods.get(method);
        if (resolvedMethod == null) {
            Object oldResolvedMethod;
            ResolvedJavaType substCallerType;
            ResolvedJavaMethod substMethod = this.universe.substitutions.resolve(((AnalysisMethod)method).wrapped);
            Object newResolvedMethod = this.universe.lookup((JavaMethod)this.wrapped.resolveConcreteMethod(substMethod, substCallerType = substMethod.getDeclaringClass()));
            if (newResolvedMethod == null) {
                newResolvedMethod = this.getUniverse().getBigbang().fallbackResolveConcreteMethod(this, (AnalysisMethod)method);
            }
            if (newResolvedMethod == null) {
                newResolvedMethod = NULL_METHOD;
            }
            resolvedMethod = (oldResolvedMethod = this.resolvedMethods.putIfAbsent(method, newResolvedMethod)) != null ? oldResolvedMethod : newResolvedMethod;
        }
        return resolvedMethod == NULL_METHOD ? null : (AnalysisMethod)resolvedMethod;
    }

    public AnalysisMethod resolveConcreteMethod(ResolvedJavaMethod method) {
        return this.resolveConcreteMethod(method, null);
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return null;
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return this.universe.lookup((JavaField)this.wrapped.findInstanceFieldWithOffset(offset, expectedKind));
    }

    public void clearInstanceFieldsCache() {
        this.instanceFieldsWithSuper = null;
        this.instanceFieldsWithoutSuper = null;
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        ResolvedJavaField[] result;
        ResolvedJavaField[] resolvedJavaFieldArray = result = includeSuperclasses ? this.instanceFieldsWithSuper : this.instanceFieldsWithoutSuper;
        if (result != null) {
            return result;
        }
        return this.initializeInstanceFields(includeSuperclasses);
    }

    private ResolvedJavaField[] initializeInstanceFields(boolean includeSuperclasses) {
        ArrayList<ResolvedJavaField> list = new ArrayList<ResolvedJavaField>();
        if (includeSuperclasses && this.getSuperclass() != null) {
            list.addAll(Arrays.asList(this.getSuperclass().getInstanceFields(true)));
        }
        ResolvedJavaField[] result = this.convertFields(this.interceptInstanceFields(this.wrapped.getInstanceFields(false)), list, includeSuperclasses);
        if (includeSuperclasses) {
            this.instanceFieldsWithSuper = result;
        } else {
            this.instanceFieldsWithoutSuper = result;
        }
        return result;
    }

    private ResolvedJavaField[] convertFields(ResolvedJavaField[] originals, List<ResolvedJavaField> list, boolean listIncludesSuperClassesFields) {
        for (ResolvedJavaField original : originals) {
            if (original.isInternal() || !this.universe.hostVM.platformSupported((AnnotatedElement)original)) continue;
            try {
                AnalysisField aField = this.universe.lookup((JavaField)original);
                if (aField == null) continue;
                if (listIncludesSuperClassesFields || aField.isStatic()) {
                    aField.setPosition(list.size());
                }
                list.add(aField);
            }
            catch (UnsupportedFeatureException unsupportedFeatureException) {
                // empty catch block
            }
        }
        return list.toArray(new ResolvedJavaField[list.size()]);
    }

    public ResolvedJavaField[] getStaticFields() {
        return this.convertFields(this.wrapped.getStaticFields(), new ArrayList<ResolvedJavaField>(), false);
    }

    public String getSourceFileName() {
        return this.wrapped.isPrimitive() ? null : this.wrapped.getSourceFileName();
    }

    public String toString() {
        return "AnalysisType<" + this.unqualifiedName + " -> " + this.wrapped.toString() + ", allocated: " + (this.isAllocated != null) + ", inHeap: " + (this.isInHeap != null) + ", reachable: " + (this.isReachable != null) + ">";
    }

    public boolean isLocal() {
        try {
            return this.wrapped.isLocal();
        }
        catch (InternalError e) {
            LogUtils.warning((String)("Unknown locality of class " + this.wrapped.getName() + ", assuming class is not local. To remove the warning report an issue to the library or language author. The issue is caused by " + this.wrapped.getName() + " which is not following the naming convention."));
            return false;
        }
    }

    public boolean isMember() {
        return this.wrapped.isMember();
    }

    public AnalysisType getEnclosingType() {
        return this.universe.lookup((JavaType)this.wrapped.getEnclosingType());
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.getDeclaredMethods(true);
    }

    public AnalysisMethod[] getDeclaredMethods(boolean forceLink) {
        GraalError.guarantee((!forceLink ? 1 : 0) != 0, (String)"only use getDeclaredMethods without forcing to link, because linking can throw LinkageError");
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredMethods(forceLink));
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return this.getDeclaredConstructors(true);
    }

    public AnalysisMethod[] getDeclaredConstructors(boolean forceLink) {
        GraalError.guarantee((!forceLink ? 1 : 0) != 0, (String)"only use getDeclaredConstructors without forcing to link, because linking can throw LinkageError");
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredConstructors(forceLink));
    }

    public AnalysisMethod findMethod(String name, Signature signature) {
        for (AnalysisMethod method : this.getDeclaredMethods(false)) {
            if (!method.getName().equals(name) || !method.getSignature().equals(signature)) continue;
            return method;
        }
        return null;
    }

    public AnalysisMethod getClassInitializer() {
        return this.universe.lookup((JavaMethod)this.wrapped.getClassInitializer());
    }

    public boolean isLinked() {
        return this.wrapped.isLinked();
    }

    public boolean isInHeap() {
        return AtomicUtils.isSet(this, isInHeapUpdater);
    }

    public Object getInHeapReason() {
        return this.isInHeap;
    }

    public boolean isAllocated() {
        return AtomicUtils.isSet(this, isAllocatedUpdater);
    }

    public Object getAllocatedReason() {
        return this.isAllocated;
    }

    public void link() {
        this.wrapped.link();
    }

    public boolean hasDefaultMethods() {
        return this.wrapped.hasDefaultMethods();
    }

    public boolean declaresDefaultMethods() {
        return this.wrapped.declaresDefaultMethods();
    }

    public boolean isCloneableWithAllocation() {
        return this.isCloneableWithAllocation;
    }

    public ResolvedJavaType getHostClass() {
        return this.universe.lookup((JavaType)this.wrapped.getHostClass());
    }

    @Override
    public AnalysisUniverse getUniverse() {
        return this.universe;
    }

    @Override
    public int compareTo(AnalysisType other) {
        return Integer.compare(this.id, other.id);
    }

    public int hashCode() {
        assert (this.id != 0 || this.isJavaLangObject()) : "Type id not set yet";
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public void addInstanceFieldsInterceptor(InstanceFieldsInterceptor interceptor) {
        ConcurrentLightHashSet.addElement(this, INTERCEPTORS_UPDATER, interceptor);
    }

    private ResolvedJavaField[] interceptInstanceFields(ResolvedJavaField[] fields) {
        ResolvedJavaField[] result = fields;
        for (Object interceptor : ConcurrentLightHashSet.getElements(this, INTERCEPTORS_UPDATER)) {
            result = ((InstanceFieldsInterceptor)interceptor).interceptInstanceFields(this.universe, result, this);
        }
        return result;
    }

    public static enum UsageKind {
        InHeap,
        Allocated,
        Reachable;

    }

    public static interface InstanceFieldsInterceptor {
        public ResolvedJavaField[] interceptInstanceFields(AnalysisUniverse var1, ResolvedJavaField[] var2, AnalysisType var3);
    }
}

