/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;

public final class ImageHeapInstance
extends ImageHeapConstant {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
    public static final VarHandle valuesHandle = ReflectionUtil.unreflectField(InstanceData.class, (String)"fieldValues", (MethodHandles.Lookup)MethodHandles.lookup());

    ImageHeapInstance(AnalysisType type, JavaConstant object) {
        super(new InstanceData(type, object, ImageHeapInstance.createIdentityHashCode(object)), false);
    }

    public ImageHeapInstance(AnalysisType type) {
        this(type, null, type.getInstanceFields(true).length);
    }

    private ImageHeapInstance(AnalysisType type, JavaConstant object, int length) {
        this(type, object, ImageHeapInstance.createIdentityHashCode(object), new Object[length], false);
    }

    private ImageHeapInstance(AnalysisType type, JavaConstant object, int identityHashCode, Object[] fieldValues, boolean compressed) {
        super(new InstanceData(type, object, identityHashCode, fieldValues), compressed);
    }

    ImageHeapInstance(ImageHeapConstant.ConstantData data, boolean compressed) {
        super(data, compressed);
    }

    @Override
    public InstanceData getConstantData() {
        return (InstanceData)super.getConstantData();
    }

    void setFieldValues(Object[] fieldValues) {
        boolean success = valuesHandle.compareAndSet(this.constantData, null, fieldValues);
        AnalysisError.guarantee(success, "Unexpected field values reference for constant %s", this);
    }

    private Object[] getFieldValues() {
        AnalysisError.guarantee(this.isReaderInstalled());
        Object[] fieldValues = this.getConstantData().fieldValues;
        AnalysisError.guarantee(fieldValues != null);
        return fieldValues;
    }

    void setFieldTask(AnalysisField field, AnalysisFuture<JavaConstant> task) {
        arrayHandle.setVolatile(this.getFieldValues(), field.getPosition(), task);
    }

    public void setFieldValue(AnalysisField field, JavaConstant value) {
        arrayHandle.setVolatile(this.getFieldValues(), field.getPosition(), value);
    }

    public Object getFieldValue(AnalysisField field) {
        return arrayHandle.getVolatile(this.getFieldValues(), field.getPosition());
    }

    public JavaConstant readFieldValue(AnalysisField field) {
        Object value = this.getFieldValue(field);
        return value instanceof JavaConstant ? (JavaConstant)value : (JavaConstant)((AnalysisFuture)value).ensureDone();
    }

    public JavaConstant compress() {
        assert (!this.compressed) : this;
        return new ImageHeapInstance(this.constantData, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed) : this;
        return new ImageHeapInstance(this.constantData, false);
    }

    @Override
    public ImageHeapConstant forObjectClone() {
        if (!this.constantData.type.isCloneableWithAllocation()) {
            return null;
        }
        Object[] fieldValues = this.getFieldValues();
        Objects.requireNonNull(fieldValues, "Cannot clone an instance before the field values are set.");
        Object[] newFieldValues = Arrays.copyOf(fieldValues, fieldValues.length);
        JavaConstant newObject = null;
        return new ImageHeapInstance(this.constantData.type, newObject, ImageHeapInstance.createIdentityHashCode(newObject), newFieldValues, this.compressed);
    }

    public static class InstanceData
    extends ImageHeapConstant.ConstantData {
        private Object[] fieldValues;

        InstanceData(AnalysisType type, JavaConstant object, int identityHashCode) {
            super(type, object, identityHashCode);
        }

        InstanceData(AnalysisType type, JavaConstant object, int identityHashCode, Object[] fieldValues) {
            super(type, object, identityHashCode);
            this.fieldValues = fieldValues;
        }
    }
}

