/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.heap.TypeData;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.util.LogUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.options.OptionKey;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HeapSnapshotVerifier {
    protected final BigBang bb;
    protected final ImageHeapScanner scanner;
    protected final ImageHeap imageHeap;
    protected ObjectScanner.ReusableSet scannedObjects;
    private boolean heapPatched;
    private boolean analysisModified;
    private final int verbosity;
    private int iterations;
    private static final int INFO = 1;
    private static final int WARNING = 2;
    private static final int ALL = 3;

    public HeapSnapshotVerifier(BigBang bb, ImageHeap imageHeap, ImageHeapScanner scanner) {
        this.bb = bb;
        this.scanner = scanner;
        this.imageHeap = imageHeap;
        this.scannedObjects = new ObjectScanner.ReusableSet();
        this.verbosity = (Integer)Options.HeapVerifierVerbosity.getValue(bb.getOptions());
    }

    public boolean checkHeapSnapshot(DebugContext debug, UniverseMetaAccess metaAccess, String stage, Map<Constant, Object> embeddedConstants) {
        CompletionExecutor executor = new CompletionExecutor(debug, this.bb);
        executor.init();
        return this.checkHeapSnapshot(metaAccess, executor, stage, false, embeddedConstants);
    }

    public boolean checkHeapSnapshot(UniverseMetaAccess metaAccess, CompletionExecutor executor, String phase, boolean forAnalysis, Map<Constant, Object> embeddedConstants) {
        this.info("Verifying the heap snapshot %s%s ...", phase, forAnalysis ? ", iteration " + this.iterations : "");
        this.analysisModified = false;
        this.heapPatched = false;
        int reachableTypesBefore = this.bb.getUniverse().getReachableTypes();
        ++this.iterations;
        this.scannedObjects.reset();
        ObjectScanner objectScanner = this.installObjectScanner(metaAccess, executor);
        executor.start();
        this.scanTypes(objectScanner);
        objectScanner.scanBootImageHeapRoots(embeddedConstants);
        try {
            executor.complete();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        executor.shutdown();
        if (this.heapPatched) {
            this.info("Heap verification patched the heap snapshot.", new Object[0]);
        } else {
            this.info("Heap verification didn't find any heap snapshot modifications.", new Object[0]);
        }
        int verificationReachableTypes = this.bb.getUniverse().getReachableTypes() - reachableTypesBefore;
        if (forAnalysis) {
            if (verificationReachableTypes > 0) {
                this.info("Heap verification made %s new types reachable.", verificationReachableTypes);
            } else {
                this.info("Heap verification didn't make any new types reachable.", new Object[0]);
            }
            if (this.analysisModified) {
                this.info("Heap verification modified the analysis state. Executing an additional analysis iteration.", new Object[0]);
            } else {
                this.info("Heap verification didn't modify the analysis state. Heap state stabilized after %s iterations.", this.iterations);
            }
        } else if (this.analysisModified || verificationReachableTypes > 0) {
            Object error;
            Object object = error = this.analysisModified ? "modified the analysis state" : "";
            error = (String)error + (String)(verificationReachableTypes > 0 ? (this.analysisModified ? " and " : "") + "made " + verificationReachableTypes + " new types reachable" : "");
            throw AnalysisError.shouldNotReachHere("Heap verification " + (String)error + ". This is illegal at this stage.");
        }
        return this.analysisModified || verificationReachableTypes > 0;
    }

    protected ObjectScanner installObjectScanner(UniverseMetaAccess metaAccess, CompletionExecutor executor) {
        return new ObjectScanner(this.bb, executor, this.scannedObjects, new ScanningObserver());
    }

    protected void scanTypes(ObjectScanner objectScanner) {
    }

    public void cleanupAfterAnalysis() {
    }

    private void onNoTaskForClassConstant(AnalysisType type, ObjectScanner.ScanReason reason) {
        this.analysisModified = true;
        if (this.printAll()) {
            this.warning(reason, "No snapshot task found for class constant %s %n", type.toJavaName());
        }
    }

    private void onTaskForClassConstantNotDone(JavaConstant object, AnalysisType type, ObjectScanner.ScanReason reason) {
        this.analysisModified = true;
        if (this.printAll()) {
            if (object != null) {
                this.warning(reason, "Snapshot not yet computed for class %s of object %s %n", type.toJavaName(), object);
            } else {
                this.warning(reason, "Snapshot not yet computed for class constant %n new value: %s %n", type.toJavaName());
            }
        }
    }

    private boolean printInfo() {
        return this.verbosity >= 1;
    }

    private boolean printWarning() {
        return this.verbosity >= 2;
    }

    private boolean printAll() {
        return this.verbosity >= 3;
    }

    private void info(String format, Object ... args) {
        if (this.printInfo()) {
            LogUtils.info((String)String.format(format, args));
        }
    }

    private void warning(ObjectScanner.ScanReason reason, String format, Object ... args) {
        LogUtils.warning((String)HeapSnapshotVerifier.formatReason(this.bb, reason, format, "Value was reached by", args));
    }

    private void analysisWarning(ObjectScanner.ScanReason reason, String format, Object ... args) {
        LogUtils.warning((String)HeapSnapshotVerifier.formatReason(this.bb, reason, format, "This leads to an analysis state change when", args));
    }

    private RuntimeException error(ObjectScanner.ScanReason reason, String format, Object ... args) {
        throw AnalysisError.shouldNotReachHere(HeapSnapshotVerifier.formatReason(this.bb, reason, format, args));
    }

    public static String formatReason(BigBang bb, ObjectScanner.ScanReason reason, String format, Object ... args) {
        return HeapSnapshotVerifier.formatReason(bb, reason, format, "", args);
    }

    private static String formatReason(BigBang bb, ObjectScanner.ScanReason reason, String format, String backtraceHeader, Object ... args) {
        Object message = HeapSnapshotVerifier.format(bb, format, args);
        StringBuilder objectBacktrace = new StringBuilder();
        ObjectScanner.buildObjectBacktrace(bb, reason, objectBacktrace, backtraceHeader);
        message = (String)message + String.valueOf(objectBacktrace);
        return message;
    }

    private String asString(JavaConstant array) {
        return ObjectScanner.asString(this.bb, array, false);
    }

    public static String format(BigBang bb, String msg, Object ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof JavaConstant) {
                    args[i] = ObjectScanner.asString(bb, (JavaConstant)args[i]);
                    continue;
                }
                if (!(args[i] instanceof AnalysisField)) continue;
                args[i] = ((AnalysisField)args[i]).format("%H.%n");
            }
        }
        return String.format(msg, args);
    }

    static class Options {
        public static final OptionKey<Integer> HeapVerifierVerbosity = new OptionKey((Object)0);

        Options() {
        }
    }

    protected final class ScanningObserver
    implements ObjectScanningObserver {
        @Override
        public boolean forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            return this.verifyFieldValue(receiver, field, fieldValue, reason);
        }

        @Override
        public boolean forPrimitiveFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            return this.verifyFieldValue(receiver, field, fieldValue, reason);
        }

        @Override
        public boolean forNullFieldValue(JavaConstant receiver, AnalysisField field, ObjectScanner.ScanReason reason) {
            return this.verifyFieldValue(receiver, field, JavaConstant.NULL_POINTER, reason);
        }

        @Override
        public boolean forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            return this.verifyFieldValue(receiver, field, fieldValue, reason);
        }

        private boolean verifyFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            if (field.isStatic()) {
                TypeData typeData = field.getDeclaringClass().getOrComputeData();
                JavaConstant fieldSnapshot = typeData.readFieldValue(field);
                this.verifyStaticFieldValue(typeData, field, fieldSnapshot, fieldValue, reason);
            } else {
                ImageHeapInstance receiverObject = (ImageHeapInstance)this.getSnapshot(receiver, reason);
                JavaConstant fieldSnapshot = receiverObject.readFieldValue(field);
                this.verifyInstanceFieldValue(field, receiver, receiverObject, fieldSnapshot, fieldValue, reason);
            }
            return false;
        }

        private void verifyStaticFieldValue(TypeData typeData, AnalysisField field, JavaConstant fieldSnapshot, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            JavaConstant result = fieldSnapshot;
            JavaConstant unwrappedSnapshot = ScanningObserver.maybeUnwrapSnapshot(fieldSnapshot, fieldValue instanceof ImageHeapConstant);
            if (!Objects.equals(unwrappedSnapshot, fieldValue)) {
                String format = "Value mismatch for static field %s %n snapshot:  %s %n new value: %s %n";
                Consumer<ObjectScanner.ScanReason> onAnalysisModified = this.analysisModified(reason, format, field, unwrappedSnapshot, fieldValue);
                result = HeapSnapshotVerifier.this.scanner.patchStaticField(typeData, field, fieldValue, reason, onAnalysisModified).ensureDone();
                HeapSnapshotVerifier.this.heapPatched = true;
            } else if (ScanningObserver.patchPrimitiveArrayValue(HeapSnapshotVerifier.this.bb, fieldSnapshot, fieldValue)) {
                HeapSnapshotVerifier.this.heapPatched = true;
            }
            HeapSnapshotVerifier.this.scanner.ensureReaderInstalled(result);
        }

        private void verifyInstanceFieldValue(AnalysisField field, JavaConstant receiver, ImageHeapInstance receiverObject, JavaConstant fieldSnapshot, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            JavaConstant result = fieldSnapshot;
            JavaConstant unwrappedSnapshot = ScanningObserver.maybeUnwrapSnapshot(fieldSnapshot, fieldValue instanceof ImageHeapConstant);
            if (!Objects.equals(unwrappedSnapshot, fieldValue)) {
                String format = "Value mismatch for instance field %s of %s %n snapshot:  %s %n new value: %s %n";
                Consumer<ObjectScanner.ScanReason> onAnalysisModified = this.analysisModified(reason, format, field, HeapSnapshotVerifier.this.asString(receiver), unwrappedSnapshot, fieldValue);
                result = HeapSnapshotVerifier.this.scanner.patchInstanceField(receiverObject, field, fieldValue, reason, onAnalysisModified).ensureDone();
                HeapSnapshotVerifier.this.heapPatched = true;
            } else if (ScanningObserver.patchPrimitiveArrayValue(HeapSnapshotVerifier.this.bb, fieldSnapshot, fieldValue)) {
                HeapSnapshotVerifier.this.heapPatched = true;
            }
            HeapSnapshotVerifier.this.scanner.ensureReaderInstalled(result);
        }

        private Consumer<ObjectScanner.ScanReason> analysisModified(ObjectScanner.ScanReason reason, String format, Object ... args) {
            if (HeapSnapshotVerifier.this.printAll()) {
                HeapSnapshotVerifier.this.warning(reason, format, args);
                return deepReason -> {
                    HeapSnapshotVerifier.this.analysisModified = true;
                };
            }
            return deepReason -> {
                HeapSnapshotVerifier.this.analysisModified = true;
                if (HeapSnapshotVerifier.this.printWarning()) {
                    HeapSnapshotVerifier.this.analysisWarning((ObjectScanner.ScanReason)deepReason, format, args);
                }
            };
        }

        @Override
        public boolean forNullArrayElement(JavaConstant array, AnalysisType arrayType, int index, ObjectScanner.ScanReason reason) {
            return this.verifyArrayElementValue(JavaConstant.NULL_POINTER, index, reason, array);
        }

        @Override
        public boolean forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementValue, AnalysisType elementType, int index, ObjectScanner.ScanReason reason) {
            return this.verifyArrayElementValue(elementValue, index, reason, array);
        }

        private boolean verifyArrayElementValue(JavaConstant elementValue, int index, ObjectScanner.ScanReason reason, JavaConstant array) {
            JavaConstant elementSnapshot;
            ImageHeapObjectArray arrayObject = (ImageHeapObjectArray)this.getSnapshot(array, reason);
            JavaConstant result = elementSnapshot = arrayObject.readElementValue(index);
            if (!Objects.equals(ScanningObserver.maybeUnwrapSnapshot(elementSnapshot, elementValue instanceof ImageHeapConstant), elementValue)) {
                String format = "Value mismatch for array element at index %s of %s %n snapshot:  %s %n new value: %s %n";
                Consumer<ObjectScanner.ScanReason> onAnalysisModified = this.analysisModified(reason, format, index, HeapSnapshotVerifier.this.asString(array), elementSnapshot, elementValue);
                result = HeapSnapshotVerifier.this.scanner.patchArrayElement(arrayObject, index, elementValue, reason, onAnalysisModified).ensureDone();
                HeapSnapshotVerifier.this.heapPatched = true;
            } else if (ScanningObserver.patchPrimitiveArrayValue(HeapSnapshotVerifier.this.bb, elementSnapshot, elementValue)) {
                HeapSnapshotVerifier.this.heapPatched = true;
            }
            HeapSnapshotVerifier.this.scanner.ensureReaderInstalled(result);
            return false;
        }

        public static boolean patchPrimitiveArrayValue(BigBang bb, JavaConstant snapshot, JavaConstant newValue) {
            if (snapshot.isNull()) {
                AnalysisError.guarantee(newValue.isNull());
                return false;
            }
            if (ScanningObserver.isPrimitiveArrayConstant(bb, snapshot)) {
                AnalysisError.guarantee(ScanningObserver.isPrimitiveArrayConstant(bb, newValue));
                Object snapshotArray = ((ImageHeapPrimitiveArray)snapshot).getArray();
                Object newValueArray = ObjectScanner.constantAsObject(bb, newValue);
                if (!Objects.deepEquals(snapshotArray, newValueArray)) {
                    AnalysisError.guarantee(bb.getConstantReflectionProvider().constantEquals((Constant)snapshot, (Constant)newValue));
                    Integer length = bb.getConstantReflectionProvider().readArrayLength(newValue);
                    System.arraycopy(newValueArray, 0, snapshotArray, 0, length);
                    return true;
                }
            }
            return false;
        }

        static boolean isPrimitiveArrayConstant(BigBang bb, JavaConstant snapshot) {
            if (snapshot.getJavaKind() == JavaKind.Object) {
                AnalysisType type = bb.getMetaAccess().lookupJavaType(snapshot);
                return type.isArray() && type.getComponentType().getJavaKind() != JavaKind.Object;
            }
            return false;
        }

        private ImageHeapConstant getSnapshot(JavaConstant constant, ObjectScanner.ScanReason reason) {
            ImageHeapConstant result;
            if (constant instanceof ImageHeapConstant) {
                result = (ImageHeapConstant)constant;
            } else {
                Object task = HeapSnapshotVerifier.this.imageHeap.getSnapshot(constant);
                if (task == null) {
                    throw HeapSnapshotVerifier.this.error(reason, "Task is null for constant %s.", constant);
                }
                if (task instanceof ImageHeapConstant) {
                    result = (ImageHeapConstant)task;
                } else {
                    AnalysisFuture future = (AnalysisFuture)task;
                    if (future.isDone()) {
                        result = (ImageHeapConstant)future.guardedGet();
                    } else {
                        throw HeapSnapshotVerifier.this.error(reason, "Task not yet executed for constant %s.", constant);
                    }
                }
            }
            if (!result.isReaderInstalled()) {
                result.ensureReaderInstalled();
            }
            return result;
        }

        @Override
        public void forEmbeddedRoot(JavaConstant root, ObjectScanner.ScanReason reason) {
            Object rootTask = HeapSnapshotVerifier.this.imageHeap.getSnapshot(root);
            if (rootTask == null) {
                throw HeapSnapshotVerifier.this.error(reason, "No snapshot task found for embedded root %s %n", root);
            }
            if (rootTask instanceof ImageHeapConstant) {
                ImageHeapConstant snapshot = (ImageHeapConstant)rootTask;
                this.verifyEmbeddedRoot(ScanningObserver.maybeUnwrapSnapshot(snapshot, root instanceof ImageHeapConstant), CompressibleConstant.uncompress((JavaConstant)root), reason);
            } else {
                AnalysisFuture future = (AnalysisFuture)rootTask;
                if (future.isDone()) {
                    ImageHeapConstant snapshot = (ImageHeapConstant)future.guardedGet();
                    this.verifyEmbeddedRoot(ScanningObserver.maybeUnwrapSnapshot(snapshot, root instanceof ImageHeapConstant), root, reason);
                } else {
                    throw HeapSnapshotVerifier.this.error(reason, "Snapshot not yet computed for embedded root %n new value: %s %n", root);
                }
            }
        }

        public static JavaConstant maybeUnwrapSnapshot(JavaConstant snapshot, boolean asImageHeapObject) {
            if (snapshot instanceof ImageHeapConstant) {
                return asImageHeapObject ? snapshot : ((ImageHeapConstant)snapshot).getHostedObject();
            }
            return snapshot;
        }

        private void verifyEmbeddedRoot(JavaConstant rootSnapshot, JavaConstant root, ObjectScanner.ScanReason reason) {
            if (!Objects.equals(rootSnapshot, root)) {
                throw HeapSnapshotVerifier.this.error(reason, "Value mismatch for embedded root %n snapshot: %s %n new value: %s %n", rootSnapshot, root);
            }
        }

        @Override
        public void forScannedConstant(JavaConstant value, ObjectScanner.ScanReason reason) {
            if (HeapSnapshotVerifier.this.bb.getMetaAccess().isInstanceOf(value, Class.class)) {
                AnalysisType type = (AnalysisType)HeapSnapshotVerifier.this.bb.getConstantReflectionProvider().asJavaType((Constant)value);
                this.ensureTypeScanned(value, type, reason);
            } else {
                AnalysisType type = HeapSnapshotVerifier.this.bb.getMetaAccess().lookupJavaType(value);
                this.ensureTypeScanned(value, HeapSnapshotVerifier.this.bb.getConstantReflectionProvider().asJavaClass((ResolvedJavaType)type), type, reason);
            }
        }

        private void ensureTypeScanned(JavaConstant typeConstant, AnalysisType type, ObjectScanner.ScanReason reason) {
            this.ensureTypeScanned(null, typeConstant, type, reason);
        }

        private void ensureTypeScanned(JavaConstant value, JavaConstant typeConstant, AnalysisType type, ObjectScanner.ScanReason reason) {
            Object task;
            if (!type.isReachable()) {
                HeapSnapshotVerifier.this.error(reason, "The heap snapshot verifier discovered a type not marked as reachable: %s", type);
            }
            if ((task = HeapSnapshotVerifier.this.imageHeap.getSnapshot(typeConstant)) == null) {
                HeapSnapshotVerifier.this.onNoTaskForClassConstant(type, reason);
                HeapSnapshotVerifier.this.scanner.toImageHeapObject(typeConstant, reason);
                HeapSnapshotVerifier.this.heapPatched = true;
            } else if (task instanceof ImageHeapConstant) {
                ImageHeapConstant snapshot = (ImageHeapConstant)task;
                this.verifyTypeConstant(ScanningObserver.maybeUnwrapSnapshot(snapshot, typeConstant instanceof ImageHeapConstant), typeConstant, reason);
            } else {
                AnalysisFuture future = (AnalysisFuture)task;
                if (future.isDone()) {
                    JavaConstant snapshot = ScanningObserver.maybeUnwrapSnapshot((JavaConstant)future.guardedGet(), typeConstant instanceof ImageHeapConstant);
                    this.verifyTypeConstant(snapshot, typeConstant, reason);
                } else {
                    HeapSnapshotVerifier.this.onTaskForClassConstantNotDone(value, type, reason);
                    future.ensureDone();
                }
            }
        }

        private void verifyTypeConstant(JavaConstant snapshot, JavaConstant typeConstant, ObjectScanner.ScanReason reason) {
            if (!Objects.equals(snapshot, typeConstant)) {
                throw HeapSnapshotVerifier.this.error(reason, "Value mismatch for class constant%n snapshot:  %s %n new value: %s %n", snapshot, typeConstant);
            }
        }
    }
}

